/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.setup.ConvolutionLayerSetup;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.RnnToFeedForwardPreProcessor;
import org.nd4j.linalg.factory.Nd4j;

public class MultiLayerConfiguration
implements Serializable,
Cloneable {
    protected List<NeuralNetConfiguration> confs;
    protected boolean pretrain = true;
    protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
    protected boolean backprop = false;
    protected BackpropType backpropType = BackpropType.Standard;
    protected int tbpttFwdLength = 20;
    protected int tbpttBackLength = 20;
    @Deprecated
    protected boolean redistributeParams = false;

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toJson();
    }

    public NeuralNetConfiguration getConf(int i) {
        return this.confs.get(i);
    }

    public MultiLayerConfiguration clone() {
        try {
            MultiLayerConfiguration clone = (MultiLayerConfiguration)super.clone();
            if (clone.confs != null) {
                ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
                for (NeuralNetConfiguration neuralNetConfiguration : clone.confs) {
                    list.add(neuralNetConfiguration.clone());
                }
                clone.confs = list;
            }
            if (clone.inputPreProcessors != null) {
                HashMap<Integer, InputPreProcessor> map = new HashMap<Integer, InputPreProcessor>();
                for (Map.Entry entry : clone.inputPreProcessors.entrySet()) {
                    map.put((Integer)entry.getKey(), ((InputPreProcessor)entry.getValue()).clone());
                }
                clone.inputPreProcessors = map;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public InputPreProcessor getInputPreProcess(int curr) {
        return this.inputPreProcessors.get(curr);
    }

    public List<NeuralNetConfiguration> getConfs() {
        return this.confs;
    }

    public boolean isPretrain() {
        return this.pretrain;
    }

    public Map<Integer, InputPreProcessor> getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public boolean isBackprop() {
        return this.backprop;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public int getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public int getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    @Deprecated
    public boolean isRedistributeParams() {
        return this.redistributeParams;
    }

    public void setConfs(List<NeuralNetConfiguration> confs) {
        this.confs = confs;
    }

    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    public void setInputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public void setBackprop(boolean backprop) {
        this.backprop = backprop;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(int tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(int tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    @Deprecated
    public void setRedistributeParams(boolean redistributeParams) {
        this.redistributeParams = redistributeParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLayerConfiguration)) {
            return false;
        }
        MultiLayerConfiguration other = (MultiLayerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<NeuralNetConfiguration> this$confs = this.getConfs();
        List<NeuralNetConfiguration> other$confs = other.getConfs();
        if (this$confs == null ? other$confs != null : !((Object)this$confs).equals(other$confs)) {
            return false;
        }
        if (this.isPretrain() != other.isPretrain()) {
            return false;
        }
        Map<Integer, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
        Map<Integer, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
        if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
            return false;
        }
        if (this.isBackprop() != other.isBackprop()) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
            return false;
        }
        if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
            return false;
        }
        return this.isRedistributeParams() == other.isRedistributeParams();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiLayerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<NeuralNetConfiguration> $confs = this.getConfs();
        result = result * 59 + ($confs == null ? 0 : ((Object)$confs).hashCode());
        result = result * 59 + (this.isPretrain() ? 79 : 97);
        Map<Integer, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
        result = result * 59 + ($inputPreProcessors == null ? 0 : ((Object)$inputPreProcessors).hashCode());
        result = result * 59 + (this.isBackprop() ? 79 : 97);
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 0 : ((Object)((Object)$backpropType)).hashCode());
        result = result * 59 + this.getTbpttFwdLength();
        result = result * 59 + this.getTbpttBackLength();
        result = result * 59 + (this.isRedistributeParams() ? 79 : 97);
        return result;
    }

    private MultiLayerConfiguration(List<NeuralNetConfiguration> confs, boolean pretrain, Map<Integer, InputPreProcessor> inputPreProcessors, boolean backprop, BackpropType backpropType, int tbpttFwdLength, int tbpttBackLength, boolean redistributeParams) {
        this.confs = confs;
        this.pretrain = pretrain;
        this.inputPreProcessors = inputPreProcessors;
        this.backprop = backprop;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
        this.redistributeParams = redistributeParams;
    }

    public MultiLayerConfiguration() {
    }

    public static class Builder {
        protected List<NeuralNetConfiguration> confs = new ArrayList<NeuralNetConfiguration>();
        protected boolean pretrain = true;
        protected double dampingFactor = 100.0;
        protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
        protected boolean backprop = false;
        protected BackpropType backpropType = BackpropType.Standard;
        protected int tbpttFwdLength = 20;
        protected int tbpttBackLength = 20;
        @Deprecated
        protected boolean redistributeParams = false;
        protected int[] cnnInputSize = null;

        @Deprecated
        public Builder redistributeParams(boolean redistributeParams) {
            this.redistributeParams = redistributeParams;
            return this;
        }

        public Builder inputPreProcessor(Integer layer, InputPreProcessor processor) {
            this.inputPreProcessors.put(layer, processor);
            return this;
        }

        public Builder inputPreProcessors(Map<Integer, InputPreProcessor> processors) {
            this.inputPreProcessors = processors;
            return this;
        }

        public Builder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        public Builder backpropType(BackpropType type) {
            this.backpropType = type;
            return this;
        }

        public Builder tBPTTForwardLength(int forwardLength) {
            this.tbpttFwdLength = forwardLength;
            return this;
        }

        public Builder tBPTTBackwardLength(int backwardLength) {
            this.tbpttBackLength = backwardLength;
            return this;
        }

        public Builder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder confs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
            return this;
        }

        public Builder cnnInputSize(int height, int width, int depth) {
            this.cnnInputSize = new int[]{height, width, depth};
            return this;
        }

        public Builder cnnInputSize(int[] cnnInputSize) {
            this.cnnInputSize = cnnInputSize;
            return this;
        }

        public MultiLayerConfiguration build() {
            if (this.cnnInputSize != null) {
                new ConvolutionLayerSetup(this, this.cnnInputSize[0], this.cnnInputSize[1], this.cnnInputSize[2]);
            }
            int nLayers = this.confs.size();
            for (int i = 1; i < nLayers; ++i) {
                Layer lastLayer;
                Layer currLayer;
                if (this.inputPreProcessors.containsKey(i) || (currLayer = this.confs.get(i).getLayer()) instanceof ConvolutionLayer || currLayer instanceof SubsamplingLayer || (lastLayer = this.confs.get(i - 1).getLayer()) instanceof ConvolutionLayer || lastLayer instanceof SubsamplingLayer) continue;
                if (currLayer instanceof DenseLayer || currLayer instanceof BasePretrainNetwork || currLayer instanceof OutputLayer) {
                    if (!(lastLayer instanceof BaseRecurrentLayer)) continue;
                    this.inputPreProcessors.put(i, new RnnToFeedForwardPreProcessor());
                    continue;
                }
                if (!(currLayer instanceof BaseRecurrentLayer) && !(currLayer instanceof RnnOutputLayer) || !(lastLayer instanceof DenseLayer) && !(lastLayer instanceof BasePretrainNetwork)) continue;
                this.inputPreProcessors.put(i, new FeedForwardToRnnPreProcessor());
            }
            MultiLayerConfiguration conf = new MultiLayerConfiguration();
            conf.confs = this.confs;
            conf.pretrain = this.pretrain;
            conf.backprop = this.backprop;
            conf.inputPreProcessors = this.inputPreProcessors;
            conf.backpropType = this.backpropType;
            conf.tbpttFwdLength = this.tbpttFwdLength;
            conf.tbpttBackLength = this.tbpttBackLength;
            conf.redistributeParams = this.redistributeParams;
            Nd4j.getRandom().setSeed(conf.getConf(0).getSeed());
            return conf;
        }

        public List<NeuralNetConfiguration> getConfs() {
            return this.confs;
        }

        public boolean isPretrain() {
            return this.pretrain;
        }

        public double getDampingFactor() {
            return this.dampingFactor;
        }

        public Map<Integer, InputPreProcessor> getInputPreProcessors() {
            return this.inputPreProcessors;
        }

        public boolean isBackprop() {
            return this.backprop;
        }

        public BackpropType getBackpropType() {
            return this.backpropType;
        }

        public int getTbpttFwdLength() {
            return this.tbpttFwdLength;
        }

        public int getTbpttBackLength() {
            return this.tbpttBackLength;
        }

        @Deprecated
        public boolean isRedistributeParams() {
            return this.redistributeParams;
        }

        public int[] getCnnInputSize() {
            return this.cnnInputSize;
        }

        public void setConfs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
        }

        public void setPretrain(boolean pretrain) {
            this.pretrain = pretrain;
        }

        public void setDampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
        }

        public void setInputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessors) {
            this.inputPreProcessors = inputPreProcessors;
        }

        public void setBackprop(boolean backprop) {
            this.backprop = backprop;
        }

        public void setBackpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
        }

        public void setTbpttFwdLength(int tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
        }

        public void setTbpttBackLength(int tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
        }

        @Deprecated
        public void setRedistributeParams(boolean redistributeParams) {
            this.redistributeParams = redistributeParams;
        }

        public void setCnnInputSize(int[] cnnInputSize) {
            this.cnnInputSize = cnnInputSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<NeuralNetConfiguration> this$confs = this.getConfs();
            List<NeuralNetConfiguration> other$confs = other.getConfs();
            if (this$confs == null ? other$confs != null : !((Object)this$confs).equals(other$confs)) {
                return false;
            }
            if (this.isPretrain() != other.isPretrain()) {
                return false;
            }
            if (Double.compare(this.getDampingFactor(), other.getDampingFactor()) != 0) {
                return false;
            }
            Map<Integer, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
            Map<Integer, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
            if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
                return false;
            }
            if (this.isBackprop() != other.isBackprop()) {
                return false;
            }
            BackpropType this$backpropType = this.getBackpropType();
            BackpropType other$backpropType = other.getBackpropType();
            if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
                return false;
            }
            if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
                return false;
            }
            if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
                return false;
            }
            if (this.isRedistributeParams() != other.isRedistributeParams()) {
                return false;
            }
            return Arrays.equals(this.getCnnInputSize(), other.getCnnInputSize());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<NeuralNetConfiguration> $confs = this.getConfs();
            result = result * 59 + ($confs == null ? 0 : ((Object)$confs).hashCode());
            result = result * 59 + (this.isPretrain() ? 79 : 97);
            long $dampingFactor = Double.doubleToLongBits(this.getDampingFactor());
            result = result * 59 + (int)($dampingFactor >>> 32 ^ $dampingFactor);
            Map<Integer, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
            result = result * 59 + ($inputPreProcessors == null ? 0 : ((Object)$inputPreProcessors).hashCode());
            result = result * 59 + (this.isBackprop() ? 79 : 97);
            BackpropType $backpropType = this.getBackpropType();
            result = result * 59 + ($backpropType == null ? 0 : ((Object)((Object)$backpropType)).hashCode());
            result = result * 59 + this.getTbpttFwdLength();
            result = result * 59 + this.getTbpttBackLength();
            result = result * 59 + (this.isRedistributeParams() ? 79 : 97);
            result = result * 59 + Arrays.hashCode(this.getCnnInputSize());
            return result;
        }

        public String toString() {
            return "MultiLayerConfiguration.Builder(confs=" + this.getConfs() + ", pretrain=" + this.isPretrain() + ", dampingFactor=" + this.getDampingFactor() + ", inputPreProcessors=" + this.getInputPreProcessors() + ", backprop=" + this.isBackprop() + ", backpropType=" + (Object)((Object)this.getBackpropType()) + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ", redistributeParams=" + this.isRedistributeParams() + ", cnnInputSize=" + Arrays.toString(this.getCnnInputSize()) + ")";
        }
    }
}

