/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseRecurrentLayer<LayerConfT extends Layer>
extends BaseLayer<LayerConfT> {
    protected Map<String, INDArray> stateMap = new ConcurrentHashMap<String, INDArray>();
    protected Map<String, INDArray> tBpttStateMap = new ConcurrentHashMap<String, INDArray>();

    public BaseRecurrentLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public BaseRecurrentLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    public abstract INDArray rnnTimeStep(INDArray var1);

    public Map<String, INDArray> rnnGetPreviousState() {
        return new HashMap<String, INDArray>(this.stateMap);
    }

    public void rnnSetPreviousState(Map<String, INDArray> stateMap) {
        this.stateMap.clear();
        this.stateMap.putAll(stateMap);
    }

    public void rnnClearPreviousState() {
        this.stateMap.clear();
        this.tBpttStateMap.clear();
    }

    public abstract INDArray rnnActivateUsingStoredState(INDArray var1, boolean var2, boolean var3);

    public Map<String, INDArray> rnnGetTBPTTState() {
        return new HashMap<String, INDArray>(this.tBpttStateMap);
    }

    public void rnnSetTBPTTState(Map<String, INDArray> state) {
        this.tBpttStateMap.clear();
        this.tBpttStateMap.putAll(state);
    }

    public abstract Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray var1, int var2);
}

