/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.trainer;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.EarlyStoppingResult;
import org.deeplearning4j.earlystopping.listener.EarlyStoppingListener;
import org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator;
import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;
import org.deeplearning4j.earlystopping.trainer.IEarlyStoppingTrainer;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarlyStoppingTrainer
implements IEarlyStoppingTrainer {
    private static Logger log = LoggerFactory.getLogger(EarlyStoppingTrainer.class);
    private final EarlyStoppingConfiguration esConfig;
    private MultiLayerNetwork net;
    private final DataSetIterator train;
    private EarlyStoppingListener listener;
    private double bestModelScore = Double.MAX_VALUE;
    private int bestModelEpoch = -1;

    public EarlyStoppingTrainer(EarlyStoppingConfiguration earlyStoppingConfiguration, MultiLayerConfiguration configuration, DataSetIterator train) {
        this(earlyStoppingConfiguration, new MultiLayerNetwork(configuration), train);
        this.net.init();
    }

    public EarlyStoppingTrainer(EarlyStoppingConfiguration esConfig, MultiLayerNetwork net, DataSetIterator train) {
        this(esConfig, net, train, null);
    }

    public EarlyStoppingTrainer(EarlyStoppingConfiguration esConfig, MultiLayerNetwork net, DataSetIterator train, EarlyStoppingListener listener) {
        if (!(esConfig.getEpochTerminationConditions() != null && esConfig.getEpochTerminationConditions().size() != 0 || esConfig.getIterationTerminationConditions() != null && esConfig.getIterationTerminationConditions().size() != 0)) {
            throw new IllegalArgumentException("Cannot conduct early stopping without a termination condition (both Iteration and Epoch termination conditions are null/empty)");
        }
        this.esConfig = esConfig;
        this.net = net;
        this.train = train;
        this.listener = listener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EarlyStoppingResult fit() {
        log.info("Starting early stopping training");
        if (this.esConfig.getScoreCalculator() == null) {
            log.warn("No score calculator provided for early stopping. Score will be reported as 0.0 to epoch termination conditions");
        }
        if (this.esConfig.getIterationTerminationConditions() != null) {
            for (IterationTerminationCondition iterationTerminationCondition : this.esConfig.getIterationTerminationConditions()) {
                iterationTerminationCondition.initialize();
            }
        }
        if (this.esConfig.getEpochTerminationConditions() != null) {
            for (EpochTerminationCondition epochTerminationCondition : this.esConfig.getEpochTerminationConditions()) {
                epochTerminationCondition.initialize();
            }
        }
        if (this.listener != null) {
            this.listener.onStart(this.esConfig, this.net);
        }
        LinkedHashMap<Integer, Double> scoreVsEpoch = new LinkedHashMap<Integer, Double>();
        boolean bl = false;
        while (true) {
            void var2_6;
            this.train.reset();
            boolean terminate = false;
            IterationTerminationCondition terminationReason = null;
            int iterCount = 0;
            while (this.train.hasNext()) {
                DataSet ds = (DataSet)this.train.next();
                try {
                    this.net.fit((org.nd4j.linalg.dataset.api.DataSet)ds);
                }
                catch (Exception e) {
                    MultiLayerNetwork bestModel;
                    log.warn("Early stopping training terminated due to exception at epoch {}, iteration {}", new Object[]{(int)var2_6, iterCount, e});
                    try {
                        bestModel = this.esConfig.getModelSaver().getBestModel();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    return new EarlyStoppingResult(EarlyStoppingResult.TerminationReason.Error, e.toString(), scoreVsEpoch, this.bestModelEpoch, this.bestModelScore, (int)var2_6, bestModel);
                }
                double lastScore = this.net.score();
                for (IterationTerminationCondition c : this.esConfig.getIterationTerminationConditions()) {
                    if (!c.terminate(lastScore)) continue;
                    terminate = true;
                    terminationReason = c;
                    break;
                }
                if (terminate) break;
                ++iterCount;
            }
            if (terminate) {
                MultiLayerNetwork bestModel;
                log.info("Hit per iteration epoch termination condition at epoch {}, iteration {}. Reason: {}", new Object[]{(int)var2_6, iterCount, terminationReason});
                if (this.esConfig.isSaveLastModel()) {
                    try {
                        this.esConfig.getModelSaver().saveLatestModel(this.net, 0.0);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error saving most recent model", e);
                    }
                }
                try {
                    bestModel = this.esConfig.getModelSaver().getBestModel();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                EarlyStoppingResult result = new EarlyStoppingResult(EarlyStoppingResult.TerminationReason.IterationTerminationCondition, terminationReason.toString(), scoreVsEpoch, this.bestModelEpoch, this.bestModelScore, (int)var2_6, bestModel);
                if (this.listener != null) {
                    this.listener.onCompletion(result);
                }
                return result;
            }
            log.info("Completed training epoch {}", (Object)((int)var2_6));
            if ((var2_6 != false || this.esConfig.getEvaluateEveryNEpochs() != 1) && var2_6 % this.esConfig.getEvaluateEveryNEpochs() != false) continue;
            ScoreCalculator sc = this.esConfig.getScoreCalculator();
            double score = sc == null ? 0.0 : this.esConfig.getScoreCalculator().calculateScore(this.net);
            scoreVsEpoch.put((int)(var2_6 - true), score);
            if (sc != null && score < this.bestModelScore) {
                if (this.bestModelEpoch == -1) {
                    log.info("Score at epoch {}: {}", (Object)((int)var2_6), (Object)score);
                } else {
                    log.info("New best model: score = {}, epoch = {} (previous: score = {}, epoch = {})", new Object[]{score, (int)var2_6, this.bestModelScore, this.bestModelEpoch});
                }
                this.bestModelScore = score;
                this.bestModelEpoch = var2_6;
                try {
                    this.esConfig.getModelSaver().saveBestModel(this.net, score);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error saving best model", e);
                }
            }
            if (this.esConfig.isSaveLastModel()) {
                try {
                    this.esConfig.getModelSaver().saveLatestModel(this.net, score);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error saving most recent model", e);
                }
            }
            if (this.listener != null) {
                this.listener.onEpoch((int)var2_6, score, this.esConfig, this.net);
            }
            boolean epochTerminate = false;
            Object termReason = null;
            for (EpochTerminationCondition c : this.esConfig.getEpochTerminationConditions()) {
                if (!c.terminate((int)var2_6, score)) continue;
                epochTerminate = true;
                termReason = c;
                break;
            }
            if (epochTerminate) {
                MultiLayerNetwork bestModel;
                log.info("Hit epoch termination condition at epoch {}. Details: {}", (Object)((int)var2_6), (Object)termReason.toString());
                try {
                    bestModel = this.esConfig.getModelSaver().getBestModel();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                EarlyStoppingResult result = new EarlyStoppingResult(EarlyStoppingResult.TerminationReason.EpochTerminationCondition, termReason.toString(), scoreVsEpoch, this.bestModelEpoch, this.bestModelScore, (int)(var2_6 + true), bestModel);
                if (this.listener != null) {
                    this.listener.onCompletion(result);
                }
                return result;
            }
            ++var2_6;
        }
    }

    @Override
    public void setListener(EarlyStoppingListener listener) {
        this.listener = listener;
    }
}

