/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.earlystopping.saver.InMemoryModelSaver;
import org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator;
import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;

public class EarlyStoppingConfiguration
implements Serializable {
    private EarlyStoppingModelSaver modelSaver;
    private List<EpochTerminationCondition> epochTerminationConditions;
    private List<IterationTerminationCondition> iterationTerminationConditions;
    private boolean saveLastModel;
    private int evaluateEveryNEpochs;
    private ScoreCalculator scoreCalculator;

    private EarlyStoppingConfiguration(Builder builder) {
        this.modelSaver = builder.modelSaver;
        this.epochTerminationConditions = builder.epochTerminationConditions;
        this.iterationTerminationConditions = builder.iterationTerminationConditions;
        this.saveLastModel = builder.saveLastModel;
        this.evaluateEveryNEpochs = builder.evaluateEveryNEpochs;
        this.scoreCalculator = builder.scoreCalculator;
    }

    public EarlyStoppingModelSaver getModelSaver() {
        return this.modelSaver;
    }

    public List<EpochTerminationCondition> getEpochTerminationConditions() {
        return this.epochTerminationConditions;
    }

    public List<IterationTerminationCondition> getIterationTerminationConditions() {
        return this.iterationTerminationConditions;
    }

    public boolean isSaveLastModel() {
        return this.saveLastModel;
    }

    public int getEvaluateEveryNEpochs() {
        return this.evaluateEveryNEpochs;
    }

    public ScoreCalculator getScoreCalculator() {
        return this.scoreCalculator;
    }

    public void setModelSaver(EarlyStoppingModelSaver modelSaver) {
        this.modelSaver = modelSaver;
    }

    public void setEpochTerminationConditions(List<EpochTerminationCondition> epochTerminationConditions) {
        this.epochTerminationConditions = epochTerminationConditions;
    }

    public void setIterationTerminationConditions(List<IterationTerminationCondition> iterationTerminationConditions) {
        this.iterationTerminationConditions = iterationTerminationConditions;
    }

    public void setSaveLastModel(boolean saveLastModel) {
        this.saveLastModel = saveLastModel;
    }

    public void setEvaluateEveryNEpochs(int evaluateEveryNEpochs) {
        this.evaluateEveryNEpochs = evaluateEveryNEpochs;
    }

    public void setScoreCalculator(ScoreCalculator scoreCalculator) {
        this.scoreCalculator = scoreCalculator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyStoppingConfiguration)) {
            return false;
        }
        EarlyStoppingConfiguration other = (EarlyStoppingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EarlyStoppingModelSaver this$modelSaver = this.getModelSaver();
        EarlyStoppingModelSaver other$modelSaver = other.getModelSaver();
        if (this$modelSaver == null ? other$modelSaver != null : !this$modelSaver.equals(other$modelSaver)) {
            return false;
        }
        List<EpochTerminationCondition> this$epochTerminationConditions = this.getEpochTerminationConditions();
        List<EpochTerminationCondition> other$epochTerminationConditions = other.getEpochTerminationConditions();
        if (this$epochTerminationConditions == null ? other$epochTerminationConditions != null : !((Object)this$epochTerminationConditions).equals(other$epochTerminationConditions)) {
            return false;
        }
        List<IterationTerminationCondition> this$iterationTerminationConditions = this.getIterationTerminationConditions();
        List<IterationTerminationCondition> other$iterationTerminationConditions = other.getIterationTerminationConditions();
        if (this$iterationTerminationConditions == null ? other$iterationTerminationConditions != null : !((Object)this$iterationTerminationConditions).equals(other$iterationTerminationConditions)) {
            return false;
        }
        if (this.isSaveLastModel() != other.isSaveLastModel()) {
            return false;
        }
        if (this.getEvaluateEveryNEpochs() != other.getEvaluateEveryNEpochs()) {
            return false;
        }
        ScoreCalculator this$scoreCalculator = this.getScoreCalculator();
        ScoreCalculator other$scoreCalculator = other.getScoreCalculator();
        return !(this$scoreCalculator == null ? other$scoreCalculator != null : !this$scoreCalculator.equals(other$scoreCalculator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EarlyStoppingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EarlyStoppingModelSaver $modelSaver = this.getModelSaver();
        result = result * 59 + ($modelSaver == null ? 0 : $modelSaver.hashCode());
        List<EpochTerminationCondition> $epochTerminationConditions = this.getEpochTerminationConditions();
        result = result * 59 + ($epochTerminationConditions == null ? 0 : ((Object)$epochTerminationConditions).hashCode());
        List<IterationTerminationCondition> $iterationTerminationConditions = this.getIterationTerminationConditions();
        result = result * 59 + ($iterationTerminationConditions == null ? 0 : ((Object)$iterationTerminationConditions).hashCode());
        result = result * 59 + (this.isSaveLastModel() ? 79 : 97);
        result = result * 59 + this.getEvaluateEveryNEpochs();
        ScoreCalculator $scoreCalculator = this.getScoreCalculator();
        result = result * 59 + ($scoreCalculator == null ? 0 : $scoreCalculator.hashCode());
        return result;
    }

    public String toString() {
        return "EarlyStoppingConfiguration(modelSaver=" + this.getModelSaver() + ", epochTerminationConditions=" + this.getEpochTerminationConditions() + ", iterationTerminationConditions=" + this.getIterationTerminationConditions() + ", saveLastModel=" + this.isSaveLastModel() + ", evaluateEveryNEpochs=" + this.getEvaluateEveryNEpochs() + ", scoreCalculator=" + this.getScoreCalculator() + ")";
    }

    public static class Builder {
        private EarlyStoppingModelSaver modelSaver = new InMemoryModelSaver();
        private List<EpochTerminationCondition> epochTerminationConditions = new ArrayList<EpochTerminationCondition>();
        private List<IterationTerminationCondition> iterationTerminationConditions = new ArrayList<IterationTerminationCondition>();
        private boolean saveLastModel = false;
        private int evaluateEveryNEpochs = 1;
        private ScoreCalculator scoreCalculator;

        public Builder modelSaver(EarlyStoppingModelSaver modelSaver) {
            this.modelSaver = modelSaver;
            return this;
        }

        public Builder epochTerminationConditions(EpochTerminationCondition ... terminationConditions) {
            this.epochTerminationConditions.clear();
            Collections.addAll(this.epochTerminationConditions, terminationConditions);
            return this;
        }

        public Builder epochTerminationConditions(List<EpochTerminationCondition> terminationConditions) {
            this.epochTerminationConditions = terminationConditions;
            return this;
        }

        public Builder iterationTerminationConditions(IterationTerminationCondition ... terminationConditions) {
            this.iterationTerminationConditions.clear();
            Collections.addAll(this.iterationTerminationConditions, terminationConditions);
            return this;
        }

        public Builder saveLastModel(boolean saveLastModel) {
            this.saveLastModel = saveLastModel;
            return this;
        }

        public Builder evaluateEveryNEpochs(int everyNEpochs) {
            this.evaluateEveryNEpochs = everyNEpochs;
            return this;
        }

        public Builder scoreCalculator(ScoreCalculator scoreCalculator) {
            this.scoreCalculator = scoreCalculator;
            return this;
        }

        public EarlyStoppingConfiguration build() {
            return new EarlyStoppingConfiguration(this);
        }
    }
}

