/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.Random;
import org.canova.image.loader.LFWLoader;
import org.deeplearning4j.datasets.canova.RecordReaderDataSetIterator;

public class LFWDataSetIterator
extends RecordReaderDataSetIterator {
    protected static int width = 250;
    protected static int height = 250;
    protected static int channels = 3;

    public LFWDataSetIterator(int batchSize, int numExamples) {
        super(new LFWLoader().getRecordReader(numExamples), batchSize, width * height * channels, 1680);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim) {
        super(new LFWLoader().getRecordReader(imgDim[0], imgDim[1], imgDim[2], numExamples), batchSize, imgDim[0] * imgDim[1] * imgDim[2], 1680);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numCategories) {
        super(new LFWLoader().getRecordReader(imgDim[0], imgDim[1], imgDim[2], numExamples), batchSize, imgDim[0] * imgDim[1] * imgDim[2], numCategories);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int numCategories) {
        super(new LFWLoader().getRecordReader(numExamples, numCategories), batchSize, width * height * channels, numCategories);
    }

    public LFWDataSetIterator(int batchSize, int[] imgDim) {
        super(new LFWLoader().getRecordReader(imgDim[0], imgDim[1], imgDim[2]), batchSize, imgDim[0] * imgDim[1] * imgDim[2], 1680);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int numCategories, boolean useSubset) {
        super(new LFWLoader(useSubset).getRecordReader(numExamples, numCategories), batchSize, width * height * channels, numCategories);
    }

    public LFWDataSetIterator(int batchSize, int[] imgDim, boolean useSubset) {
        super(new LFWLoader(useSubset).getRecordReader(imgDim[0], imgDim[1], imgDim[2]), batchSize, imgDim[0] * imgDim[1] * imgDim[2], useSubset ? 432 : 1680);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numCategories, boolean useSubset, Random rng) {
        super(new LFWLoader(useSubset).getRecordReader(imgDim[0], imgDim[1], imgDim[2], numExamples, rng), batchSize, imgDim[0] * imgDim[1] * imgDim[2], numCategories);
    }
}

