/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import org.deeplearning4j.nn.conf.layers.Layer;

public class LocalResponseNormalization
extends Layer {
    protected double n;
    protected double k;
    protected double beta;
    protected double alpha;

    private LocalResponseNormalization(Builder builder) {
        super(builder);
        this.k = builder.k;
        this.n = builder.n;
        this.alpha = builder.alpha;
        this.beta = builder.beta;
    }

    @Override
    public LocalResponseNormalization clone() {
        LocalResponseNormalization clone = (LocalResponseNormalization)super.clone();
        return clone;
    }

    public double getN() {
        return this.n;
    }

    public double getK() {
        return this.k;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setN(double n) {
        this.n = n;
    }

    public void setK(double k) {
        this.k = k;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public LocalResponseNormalization() {
    }

    @Override
    public String toString() {
        return "LocalResponseNormalization(super=" + super.toString() + ", n=" + this.getN() + ", k=" + this.getK() + ", beta=" + this.getBeta() + ", alpha=" + this.getAlpha() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalResponseNormalization)) {
            return false;
        }
        LocalResponseNormalization other = (LocalResponseNormalization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getN(), other.getN()) != 0) {
            return false;
        }
        if (Double.compare(this.getK(), other.getK()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta(), other.getBeta()) != 0) {
            return false;
        }
        return Double.compare(this.getAlpha(), other.getAlpha()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LocalResponseNormalization;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $n = Double.doubleToLongBits(this.getN());
        result = result * 59 + (int)($n >>> 32 ^ $n);
        long $k = Double.doubleToLongBits(this.getK());
        result = result * 59 + (int)($k >>> 32 ^ $k);
        long $beta = Double.doubleToLongBits(this.getBeta());
        result = result * 59 + (int)($beta >>> 32 ^ $beta);
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private double k = 2.0;
        private double n = 5.0;
        private double alpha = 1.0E-4;
        private double beta = 0.75;

        public Builder(double k, double alpha, double beta) {
            this.k = k;
            this.alpha = alpha;
            this.beta = beta;
        }

        public Builder() {
        }

        public Builder k(double k) {
            this.k = k;
            return this;
        }

        public Builder n(double n) {
            this.n = n;
            return this;
        }

        public Builder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(double beta) {
            this.beta = beta;
            return this;
        }

        @Override
        public LocalResponseNormalization build() {
            return new LocalResponseNormalization(this);
        }

        @ConstructorProperties(value={"k", "n", "alpha", "beta"})
        public Builder(double k, double n, double alpha, double beta) {
            this.k = k;
            this.n = n;
            this.alpha = alpha;
            this.beta = beta;
        }
    }
}

