/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.api;

import java.io.Serializable;
import java.util.Collection;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public interface Layer
extends Serializable,
Cloneable,
Model {
    public double calcL2();

    public double calcL1();

    public Type type();

    public Gradient error(INDArray var1);

    public INDArray derivativeActivation(INDArray var1);

    public Gradient calcGradient(Gradient var1, INDArray var2);

    public Pair<Gradient, INDArray> backpropGradient(INDArray var1);

    public void merge(Layer var1, int var2);

    public INDArray activationMean();

    public void update(Gradient var1);

    @Override
    public void update(INDArray var1, String var2);

    public INDArray preOutput(INDArray var1);

    public INDArray preOutput(INDArray var1, TrainingMode var2);

    public INDArray activate(TrainingMode var1);

    public INDArray activate(INDArray var1, TrainingMode var2);

    public INDArray preOutput(INDArray var1, boolean var2);

    public INDArray activate(boolean var1);

    public INDArray activate(INDArray var1, boolean var2);

    public INDArray activate();

    public INDArray activate(INDArray var1);

    public Layer transpose();

    public Layer clone();

    public Collection<IterationListener> getListeners();

    public void setListeners(IterationListener ... var1);

    public void setListeners(Collection<IterationListener> var1);

    public void setIndex(int var1);

    public int getIndex();

    public void setInput(INDArray var1);

    public void setInputMiniBatchSize(int var1);

    public int getInputMiniBatchSize();

    public static enum TrainingMode {
        TRAIN,
        TEST;

    }

    public static enum Type {
        FEED_FORWARD,
        RECURRENT,
        CONVOLUTIONAL,
        SUBSAMPLING,
        RECURSIVE,
        MULTILAYER,
        NORMALIZATION;

    }
}

