/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import org.deeplearning4j.datasets.iterator.DataSetFetcher;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.iterator.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.DataSet;

public class BaseDatasetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -116636792426198949L;
    protected int batch;
    protected int numExamples;
    protected DataSetFetcher fetcher;
    protected DataSetPreProcessor preProcessor;

    public BaseDatasetIterator(int batch, int numExamples, DataSetFetcher fetcher) {
        this.batch = batch;
        if (numExamples < 0) {
            numExamples = fetcher.totalExamples();
        }
        this.numExamples = numExamples;
        this.fetcher = fetcher;
    }

    @Override
    public boolean hasNext() {
        return this.fetcher.hasMore() && this.fetcher.cursor() < this.numExamples;
    }

    @Override
    public org.nd4j.linalg.dataset.DataSet next() {
        this.fetcher.fetch(this.batch);
        org.nd4j.linalg.dataset.DataSet result = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)result);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int totalExamples() {
        return this.fetcher.totalExamples();
    }

    public int inputColumns() {
        return this.fetcher.inputColumns();
    }

    public int totalOutcomes() {
        return this.fetcher.totalOutcomes();
    }

    public void reset() {
        this.fetcher.reset();
    }

    public int batch() {
        return this.batch;
    }

    public int cursor() {
        return this.fetcher.cursor();
    }

    public int numExamples() {
        return this.numExamples;
    }

    public void setPreProcessor(org.nd4j.linalg.dataset.api.DataSetPreProcessor preProcessor) {
        this.preProcessor = (DataSetPreProcessor)preProcessor;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        this.fetcher.fetch(num);
        org.nd4j.linalg.dataset.DataSet next = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)next);
        }
        return next;
    }
}

