/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.kdtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.ndarray.INDArray;

public class HyperRect
implements Serializable {
    private List<Interval> points;

    public HyperRect(List<Interval> points) {
        this.points = points;
    }

    public void enlargeTo(INDArray point) {
        for (int i = 0; i < this.points.size(); ++i) {
            this.points.get(i).enlarge(point.getDouble(i));
        }
    }

    public static List<Interval> point(INDArray vector) {
        ArrayList<Interval> ret = new ArrayList<Interval>();
        for (int i = 0; i < vector.length(); ++i) {
            double curr = vector.getDouble(i);
            ret.add(new Interval(curr, curr));
        }
        return ret;
    }

    public List<Boolean> contains(INDArray hPoint) {
        ArrayList<Boolean> ret = new ArrayList<Boolean>();
        for (int i = 0; i < hPoint.length(); ++i) {
            ret.add(this.points.get(i).contains(hPoint.getDouble(i)));
        }
        return ret;
    }

    public double minDistance(INDArray hPoint) {
        double ret = 0.0;
        for (int i = 0; i < hPoint.length(); ++i) {
            Interval interval;
            double p = hPoint.getDouble(i);
            if (p < (interval = this.points.get(i)).lower) {
                ret += Math.pow(p - interval.lower, 2.0);
                continue;
            }
            ret += Math.pow(p - interval.higher, 2.0);
        }
        ret = Math.pow(ret, 0.5);
        return ret;
    }

    public HyperRect getUpper(INDArray hPoint, int desc) {
        Interval interval = this.points.get(desc);
        double d = hPoint.getDouble(desc);
        if (interval.higher < d) {
            return null;
        }
        HyperRect ret = new HyperRect(new ArrayList<Interval>(this.points));
        Interval i2 = ret.points.get(desc);
        if (i2.lower < d) {
            i2.lower = d;
        }
        return ret;
    }

    public HyperRect getLower(INDArray hPoint, int desc) {
        Interval interval = this.points.get(desc);
        double d = hPoint.getDouble(desc);
        if (interval.higher > d) {
            return null;
        }
        HyperRect ret = new HyperRect(new ArrayList<Interval>(this.points));
        Interval i2 = ret.points.get(desc);
        if (i2.lower > d) {
            i2.lower = d;
        }
        return ret;
    }

    public static class Interval {
        private double lower;
        private double higher;

        public Interval(double lower, double higher) {
            this.lower = lower;
            this.higher = higher;
        }

        public boolean contains(double point) {
            return this.lower <= point || point <= this.higher;
        }

        public void enlarge(double p) {
            if (this.lower > p) {
                this.lower = p;
            } else if (this.higher < p) {
                this.higher = p;
            }
        }
    }
}

