/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.springframework.core.io.ClassPathResource;

public class IrisUtils {
    public static List<DataSet> loadIris(int from, int to) throws IOException {
        int i;
        ClassPathResource resource = new ClassPathResource("/iris.dat");
        List lines = IOUtils.readLines((InputStream)resource.getInputStream());
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        INDArray ret = Nd4j.ones((int)Math.abs(to - from), (int)4);
        double[][] outcomes = new double[lines.size()][3];
        int putCount = 0;
        for (i = from; i < to; ++i) {
            String line = (String)lines.get(i);
            String[] split = line.split(",");
            IrisUtils.addRow(ret, putCount++, split);
            String outcome = split[split.length - 1];
            double[] rowOutcome = new double[3];
            rowOutcome[Integer.parseInt((String)outcome)] = 1.0;
            outcomes[i] = rowOutcome;
        }
        for (i = 0; i < ret.rows(); ++i) {
            DataSet add = new DataSet(ret.getRow(i), Nd4j.create((double[])outcomes[from + i]));
            list.add(add);
        }
        return list;
    }

    private static void addRow(INDArray ret, int row, String[] line) {
        double[] vector = new double[4];
        for (int i = 0; i < 4; ++i) {
            vector[i] = Double.parseDouble(line[i]);
        }
        ret.putRow(row, Nd4j.create((double[])vector));
    }
}

