/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.iterationlistener;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.plot.NeuralNetPlotter;

public class RenderFilterIterationListener
implements IterationListener {
    private int iterations = 10;
    private NeuralNetPlotter plotter = new NeuralNetPlotter();
    private int patchesPerRow = 100;
    private boolean renderFirst = false;
    private boolean invoked = false;

    @Override
    public boolean invoked() {
        return this.invoked;
    }

    @Override
    public void invoke() {
        this.invoked = true;
    }

    public RenderFilterIterationListener(int iterations, boolean renderFirst) {
        this.iterations = iterations;
        this.renderFirst = renderFirst;
    }

    public RenderFilterIterationListener(int iterations, int patchesPerRow) {
        this(iterations, patchesPerRow, false);
    }

    public RenderFilterIterationListener(int iterations, int patchesPerRow, boolean renderFirst) {
        this.iterations = iterations;
        this.patchesPerRow = patchesPerRow;
        this.renderFirst = renderFirst;
    }

    public RenderFilterIterationListener(int iterations, NeuralNetPlotter plotter, int patchesPerRow, boolean renderFirst) {
        this.iterations = iterations;
        this.plotter = plotter;
        this.patchesPerRow = patchesPerRow;
        this.renderFirst = renderFirst;
    }

    public RenderFilterIterationListener(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (iteration == 0 && this.renderFirst || iteration > 0 && iteration % this.iterations == 0) {
            this.invoke();
            Layer layer = (Layer)model;
            this.plotter.renderFilter(layer, this.patchesPerRow);
        }
    }
}

