/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.GRU;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class GRUParamInitializer
implements ParamInitializer {
    public static final String RECURRENT_WEIGHT_KEY = "RW";
    public static final String BIAS_KEY = "b";
    public static final String INPUT_WEIGHT_KEY = "W";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        GRU layerConf = (GRU)conf.getLayer();
        Distribution dist = Distributions.createDistribution(layerConf.getDist());
        int nL = layerConf.getNOut();
        int nLast = layerConf.getNIn();
        conf.addVariable(INPUT_WEIGHT_KEY);
        conf.addVariable(RECURRENT_WEIGHT_KEY);
        conf.addVariable(BIAS_KEY);
        params.put(INPUT_WEIGHT_KEY, WeightInitUtil.initWeights(nLast, 3 * nL, layerConf.getWeightInit(), dist));
        params.put(RECURRENT_WEIGHT_KEY, WeightInitUtil.initWeights(nL, 3 * nL, layerConf.getWeightInit(), dist));
        params.put(BIAS_KEY, Nd4j.zeros((int)1, (int)(3 * nL)));
        params.get(INPUT_WEIGHT_KEY).data().persist();
        params.get(RECURRENT_WEIGHT_KEY).data().persist();
        params.get(BIAS_KEY).data().persist();
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }
}

