/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.AutoEncoder;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.GRU;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.ImageLSTM;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RBM;
import org.deeplearning4j.nn.conf.layers.RecursiveAutoEncoder;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.layers.normalization.LocalResponseNormalization;
import org.deeplearning4j.nn.weights.WeightInit;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoEncoder.class, name="autoEncoder"), @JsonSubTypes.Type(value=ConvolutionLayer.class, name="convolution"), @JsonSubTypes.Type(value=ImageLSTM.class, name="imageLSTM"), @JsonSubTypes.Type(value=GravesLSTM.class, name="gravesLSTM"), @JsonSubTypes.Type(value=GRU.class, name="gru"), @JsonSubTypes.Type(value=OutputLayer.class, name="output"), @JsonSubTypes.Type(value=RnnOutputLayer.class, name="rnnoutput"), @JsonSubTypes.Type(value=RBM.class, name="RBM"), @JsonSubTypes.Type(value=DenseLayer.class, name="dense"), @JsonSubTypes.Type(value=RecursiveAutoEncoder.class, name="recursiveAutoEncoder"), @JsonSubTypes.Type(value=SubsamplingLayer.class, name="subsampling"), @JsonSubTypes.Type(value=LocalResponseNormalization.class, name="localResponseNormalization")})
public abstract class Layer
implements Serializable,
Cloneable {
    protected String activationFunction;
    protected WeightInit weightInit;
    protected double biasInit;
    protected Distribution dist;
    protected double learningRate;
    protected Map<Integer, Double> learningRateAfter;
    protected double lrScoreBasedDecay;
    protected double momentum;
    protected Map<Integer, Double> momentumAfter;
    protected double l1;
    protected double l2;
    protected double dropOut;
    protected Updater updater;
    protected double rho;
    protected double rmsDecay;
    protected double adamMeanDecay = 0.9;
    protected double adamVarDecay = 0.999;
    protected GradientNormalization gradientNormalization = GradientNormalization.None;
    protected double gradientNormalizationThreshold = 1.0;

    public Layer(Builder builder) {
        this.activationFunction = builder.activationFunction;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.learningRateAfter = builder.learningRateAfter;
        this.lrScoreBasedDecay = builder.lrScoreBasedDecay;
        this.momentum = builder.momentum;
        this.momentumAfter = builder.momentumAfter;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.dropOut = builder.dropOut;
        this.updater = builder.updater;
        this.rho = builder.rho;
        this.rmsDecay = builder.rmsDecay;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
    }

    public Layer clone() {
        try {
            Layer clone = (Layer)super.clone();
            if (clone.dist != null) {
                clone.dist = clone.dist.clone();
            }
            if (clone.momentumAfter != null) {
                clone.momentumAfter = new HashMap<Integer, Double>(clone.momentumAfter);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getActivationFunction() {
        return this.activationFunction;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public Map<Integer, Double> getLearningRateAfter() {
        return this.learningRateAfter;
    }

    public double getLrScoreBasedDecay() {
        return this.lrScoreBasedDecay;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public Map<Integer, Double> getMomentumAfter() {
        return this.momentumAfter;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getDropOut() {
        return this.dropOut;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public double getRho() {
        return this.rho;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getAdamMeanDecay() {
        return this.adamMeanDecay;
    }

    public double getAdamVarDecay() {
        return this.adamVarDecay;
    }

    public GradientNormalization getGradientNormalization() {
        return this.gradientNormalization;
    }

    public double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public void setActivationFunction(String activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateAfter(Map<Integer, Double> learningRateAfter) {
        this.learningRateAfter = learningRateAfter;
    }

    public void setLrScoreBasedDecay(double lrScoreBasedDecay) {
        this.lrScoreBasedDecay = lrScoreBasedDecay;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setMomentumAfter(Map<Integer, Double> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setDropOut(double dropOut) {
        this.dropOut = dropOut;
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setAdamMeanDecay(double adamMeanDecay) {
        this.adamMeanDecay = adamMeanDecay;
    }

    public void setAdamVarDecay(double adamVarDecay) {
        this.adamVarDecay = adamVarDecay;
    }

    public void setGradientNormalization(GradientNormalization gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$activationFunction = this.getActivationFunction();
        String other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        Map<Integer, Double> this$learningRateAfter = this.getLearningRateAfter();
        Map<Integer, Double> other$learningRateAfter = other.getLearningRateAfter();
        if (this$learningRateAfter == null ? other$learningRateAfter != null : !((Object)this$learningRateAfter).equals(other$learningRateAfter)) {
            return false;
        }
        if (Double.compare(this.getLrScoreBasedDecay(), other.getLrScoreBasedDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        Map<Integer, Double> this$momentumAfter = this.getMomentumAfter();
        Map<Integer, Double> other$momentumAfter = other.getMomentumAfter();
        if (this$momentumAfter == null ? other$momentumAfter != null : !((Object)this$momentumAfter).equals(other$momentumAfter)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (Double.compare(this.getDropOut(), other.getDropOut()) != 0) {
            return false;
        }
        Updater this$updater = this.getUpdater();
        Updater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
            return false;
        }
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdamMeanDecay(), other.getAdamMeanDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdamVarDecay(), other.getAdamVarDecay()) != 0) {
            return false;
        }
        GradientNormalization this$gradientNormalization = this.getGradientNormalization();
        GradientNormalization other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
            return false;
        }
        return Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 0 : $activationFunction.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 0 : ((Object)((Object)$weightInit)).hashCode());
        long $biasInit = Double.doubleToLongBits(this.getBiasInit());
        result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 0 : $dist.hashCode());
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        Map<Integer, Double> $learningRateAfter = this.getLearningRateAfter();
        result = result * 59 + ($learningRateAfter == null ? 0 : ((Object)$learningRateAfter).hashCode());
        long $lrScoreBasedDecay = Double.doubleToLongBits(this.getLrScoreBasedDecay());
        result = result * 59 + (int)($lrScoreBasedDecay >>> 32 ^ $lrScoreBasedDecay);
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        Map<Integer, Double> $momentumAfter = this.getMomentumAfter();
        result = result * 59 + ($momentumAfter == null ? 0 : ((Object)$momentumAfter).hashCode());
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        long $dropOut = Double.doubleToLongBits(this.getDropOut());
        result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
        Updater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 0 : ((Object)((Object)$updater)).hashCode());
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $adamMeanDecay = Double.doubleToLongBits(this.getAdamMeanDecay());
        result = result * 59 + (int)($adamMeanDecay >>> 32 ^ $adamMeanDecay);
        long $adamVarDecay = Double.doubleToLongBits(this.getAdamVarDecay());
        result = result * 59 + (int)($adamVarDecay >>> 32 ^ $adamVarDecay);
        GradientNormalization $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 0 : ((Object)((Object)$gradientNormalization)).hashCode());
        long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
        result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
        return result;
    }

    public String toString() {
        return "Layer(activationFunction=" + this.getActivationFunction() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", learningRateAfter=" + this.getLearningRateAfter() + ", lrScoreBasedDecay=" + this.getLrScoreBasedDecay() + ", momentum=" + this.getMomentum() + ", momentumAfter=" + this.getMomentumAfter() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", rho=" + this.getRho() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ")";
    }

    public Layer() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String activationFunction = null;
        protected WeightInit weightInit = null;
        protected double biasInit = Double.NaN;
        protected Distribution dist = null;
        protected double learningRate = Double.NaN;
        protected Map<Integer, Double> learningRateAfter = null;
        protected double lrScoreBasedDecay = Double.NaN;
        protected double momentum = Double.NaN;
        protected Map<Integer, Double> momentumAfter = null;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double dropOut = Double.NaN;
        protected Updater updater = null;
        protected double rho = Double.NaN;
        protected double rmsDecay = Double.NaN;
        protected double adamMeanDecay = Double.NaN;
        protected double adamVarDecay = Double.NaN;
        protected GradientNormalization gradientNormalization = null;
        protected double gradientNormalizationThreshold = Double.NaN;

        public T activation(String activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T learningRateAfter(Map<Integer, Double> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
            return (T)this;
        }

        public T learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return (T)this;
        }

        public T l1(double l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public T momentum(double momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            this.updater = updater;
            return (T)this;
        }

        public T rho(double rho) {
            this.rho = rho;
            return (T)this;
        }

        public T rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        public T adamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        public T adamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return (T)this;
        }

        public abstract <E extends Layer> E build();
    }
}

