/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.linalg.factory.Nd4j;

public class BatchNormalization
extends Layer {
    private int[] shape;
    private double decay = 0.9;
    private double eps = Nd4j.EPS_THRESHOLD;
    private int size;
    private boolean finetune;
    private boolean useBatchMean;
    private int N;

    public static BatchNormalizationBuilder builder() {
        return new BatchNormalizationBuilder();
    }

    public int[] getShape() {
        return this.shape;
    }

    public double getDecay() {
        return this.decay;
    }

    public double getEps() {
        return this.eps;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFinetune() {
        return this.finetune;
    }

    public boolean isUseBatchMean() {
        return this.useBatchMean;
    }

    public int getN() {
        return this.N;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public void setDecay(double decay) {
        this.decay = decay;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFinetune(boolean finetune) {
        this.finetune = finetune;
    }

    public void setUseBatchMean(boolean useBatchMean) {
        this.useBatchMean = useBatchMean;
    }

    public void setN(int N) {
        this.N = N;
    }

    public BatchNormalization() {
    }

    @Override
    public String toString() {
        return "BatchNormalization(super=" + super.toString() + ", shape=" + Arrays.toString(this.getShape()) + ", decay=" + this.getDecay() + ", eps=" + this.getEps() + ", size=" + this.getSize() + ", finetune=" + this.isFinetune() + ", useBatchMean=" + this.isUseBatchMean() + ", N=" + this.getN() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchNormalization)) {
            return false;
        }
        BatchNormalization other = (BatchNormalization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        if (Double.compare(this.getDecay(), other.getDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getEps(), other.getEps()) != 0) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isFinetune() != other.isFinetune()) {
            return false;
        }
        if (this.isUseBatchMean() != other.isUseBatchMean()) {
            return false;
        }
        return this.getN() == other.getN();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BatchNormalization;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getShape());
        long $decay = Double.doubleToLongBits(this.getDecay());
        result = result * 59 + (int)($decay >>> 32 ^ $decay);
        long $eps = Double.doubleToLongBits(this.getEps());
        result = result * 59 + (int)($eps >>> 32 ^ $eps);
        result = result * 59 + this.getSize();
        result = result * 59 + (this.isFinetune() ? 79 : 97);
        result = result * 59 + (this.isUseBatchMean() ? 79 : 97);
        result = result * 59 + this.getN();
        return result;
    }

    @ConstructorProperties(value={"shape", "decay", "eps", "size", "finetune", "useBatchMean", "N"})
    public BatchNormalization(int[] shape, double decay, double eps, int size, boolean finetune, boolean useBatchMean, int N) {
        this.shape = shape;
        this.decay = decay;
        this.eps = eps;
        this.size = size;
        this.finetune = finetune;
        this.useBatchMean = useBatchMean;
        this.N = N;
    }

    public static class BatchNormalizationBuilder {
        private int[] shape;
        private double decay;
        private double eps;
        private int size;
        private boolean finetune;
        private boolean useBatchMean;
        private int N;

        BatchNormalizationBuilder() {
        }

        public BatchNormalizationBuilder shape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public BatchNormalizationBuilder decay(double decay) {
            this.decay = decay;
            return this;
        }

        public BatchNormalizationBuilder eps(double eps) {
            this.eps = eps;
            return this;
        }

        public BatchNormalizationBuilder size(int size) {
            this.size = size;
            return this;
        }

        public BatchNormalizationBuilder finetune(boolean finetune) {
            this.finetune = finetune;
            return this;
        }

        public BatchNormalizationBuilder useBatchMean(boolean useBatchMean) {
            this.useBatchMean = useBatchMean;
            return this;
        }

        public BatchNormalizationBuilder N(int N) {
            this.N = N;
            return this;
        }

        public BatchNormalization build() {
            return new BatchNormalization(this.shape, this.decay, this.eps, this.size, this.finetune, this.useBatchMean, this.N);
        }

        public String toString() {
            return "BatchNormalization.BatchNormalizationBuilder(shape=" + Arrays.toString(this.shape) + ", decay=" + this.decay + ", eps=" + this.eps + ", size=" + this.size + ", finetune=" + this.finetune + ", useBatchMean=" + this.useBatchMean + ", N=" + this.N + ")";
        }
    }
}

