/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.BaseInputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ComposableInputPreProcessor
extends BaseInputPreProcessor {
    private InputPreProcessor[] inputPreProcessors;

    @JsonCreator
    public ComposableInputPreProcessor(@JsonProperty(value="inputPreProcessors") InputPreProcessor[] inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    @Override
    public INDArray preProcess(INDArray input, Layer layer) {
        for (InputPreProcessor preProcessor : this.inputPreProcessors) {
            input = preProcessor.preProcess(input, layer);
        }
        return input;
    }

    @Override
    public INDArray backprop(INDArray output, Layer layer) {
        for (InputPreProcessor inputPreProcessor : this.inputPreProcessors) {
            output = inputPreProcessor.backprop(output, layer);
        }
        return output;
    }

    @Override
    public ComposableInputPreProcessor clone() {
        ComposableInputPreProcessor clone = (ComposableInputPreProcessor)super.clone();
        if (clone.inputPreProcessors != null) {
            InputPreProcessor[] processors = new InputPreProcessor[clone.inputPreProcessors.length];
            for (int i = 0; i < clone.inputPreProcessors.length; ++i) {
                processors[i] = clone.inputPreProcessors[i].clone();
            }
            clone.inputPreProcessors = processors;
        }
        return clone;
    }

    public InputPreProcessor[] getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public void setInputPreProcessors(InputPreProcessor[] inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComposableInputPreProcessor)) {
            return false;
        }
        ComposableInputPreProcessor other = (ComposableInputPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getInputPreProcessors(), other.getInputPreProcessors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComposableInputPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getInputPreProcessors());
        return result;
    }

    public String toString() {
        return "ComposableInputPreProcessor(inputPreProcessors=" + Arrays.deepToString(this.getInputPreProcessors()) + ")";
    }
}

