/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.quadtree;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.deeplearning4j.clustering.quadtree.Cell;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class QuadTree
implements Serializable {
    private QuadTree parent;
    private QuadTree northWest;
    private QuadTree northEast;
    private QuadTree southWest;
    private QuadTree southEast;
    private boolean isLeaf = true;
    private int size;
    private int cumSize;
    private Cell boundary;
    static final int QT_NO_DIMS = 2;
    static final int QT_NODE_CAPACITY = 1;
    private INDArray buf = Nd4j.create((int)2);
    private INDArray data;
    private INDArray centerOfMass = Nd4j.create((int)2);
    private int[] index = new int[1];

    public QuadTree(INDArray data) {
        INDArray meanY = data.mean(new int[]{0});
        INDArray minY = data.min(new int[]{0});
        INDArray maxY = data.max(new int[]{0});
        this.init(data, meanY.getDouble(0), meanY.getDouble(1), Math.max(maxY.getDouble(0) - meanY.getDouble(0), meanY.getDouble(0) - minY.getDouble(0)) + Nd4j.EPS_THRESHOLD, Math.max(maxY.getDouble(1) - meanY.getDouble(1), meanY.getDouble(1) - minY.getDouble(1)) + Nd4j.EPS_THRESHOLD);
        this.fill();
    }

    public QuadTree(QuadTree parent, INDArray data, Cell boundary) {
        this.parent = parent;
        this.boundary = boundary;
        this.data = data;
    }

    public QuadTree(Cell boundary) {
        this.boundary = boundary;
    }

    private void init(INDArray data, double x, double y, double hw, double hh) {
        this.boundary = new Cell(x, y, hw, hh);
        this.data = data;
    }

    private void fill() {
        for (int i = 0; i < this.data.rows(); ++i) {
            this.insert(i);
        }
    }

    protected QuadTree findIndex(INDArray coordinates) {
        boolean left = coordinates.getDouble(0) <= this.boundary.getX() + this.boundary.getHw() / 2.0;
        boolean top = coordinates.getDouble(1) <= this.boundary.getY() + this.boundary.getHh() / 2.0;
        QuadTree index = this.getNorthWest();
        if (left) {
            if (!top) {
                index = this.getSouthWest();
            }
        } else {
            index = top ? this.getNorthEast() : this.getSouthEast();
        }
        return index;
    }

    public boolean insert(int newIndex) {
        INDArray point = this.data.slice(newIndex);
        if (!this.boundary.containsPoint(point)) {
            return false;
        }
        ++this.cumSize;
        double mult1 = (double)(this.cumSize - 1) / (double)this.cumSize;
        double mult2 = 1.0 / (double)this.cumSize;
        this.centerOfMass.muli((Number)mult1);
        this.centerOfMass.addi(point.mul((Number)mult2));
        if (this.isLeaf() && this.size < 1) {
            this.index[this.size] = newIndex;
            ++this.size;
            return true;
        }
        if (this.size > 0) {
            for (int i = 0; i < this.size; ++i) {
                INDArray compPoint = this.data.slice(this.index[i]);
                if (point.getDouble(0) != compPoint.getDouble(0) || point.getDouble(1) != compPoint.getDouble(1)) continue;
                return true;
            }
        }
        if (!this.isLeaf()) {
            QuadTree index = this.findIndex(point);
            index.insert(newIndex);
            return true;
        }
        if (this.isLeaf()) {
            this.subDivide();
        }
        boolean ret = this.insertIntoOneOf(newIndex);
        return ret;
    }

    private boolean insertIntoOneOf(int index) {
        boolean success = false;
        if (!success) {
            success = this.northWest.insert(index);
        }
        if (!success) {
            success = this.northEast.insert(index);
        }
        if (!success) {
            success = this.southWest.insert(index);
        }
        if (!success) {
            success = this.southEast.insert(index);
        }
        return success;
    }

    public boolean isCorrect() {
        for (int n = 0; n < this.size; ++n) {
            INDArray point = this.data.slice(this.index[n]);
            if (this.boundary.containsPoint(point)) continue;
            return false;
        }
        return this.isLeaf() || this.northWest.isCorrect() && this.northEast.isCorrect() && this.southWest.isCorrect() && this.southEast.isCorrect();
    }

    public void subDivide() {
        this.northWest = new QuadTree(this, this.data, new Cell(this.boundary.getX() - 0.5 * this.boundary.getHw(), this.boundary.getY() - 0.5 * this.boundary.getHh(), 0.5 * this.boundary.getHw(), 0.5 * this.boundary.getHh()));
        this.northEast = new QuadTree(this, this.data, new Cell(this.boundary.getX() + 0.5 * this.boundary.getHw(), this.boundary.getY() - 0.5 * this.boundary.getHh(), 0.5 * this.boundary.getHw(), 0.5 * this.boundary.getHh()));
        this.southWest = new QuadTree(this, this.data, new Cell(this.boundary.getX() - 0.5 * this.boundary.getHw(), this.boundary.getY() + 0.5 * this.boundary.getHh(), 0.5 * this.boundary.getHw(), 0.5 * this.boundary.getHh()));
        this.southEast = new QuadTree(this, this.data, new Cell(this.boundary.getX() + 0.5 * this.boundary.getHw(), this.boundary.getY() + 0.5 * this.boundary.getHh(), 0.5 * this.boundary.getHw(), 0.5 * this.boundary.getHh()));
    }

    public void computeNonEdgeForces(int pointIndex, double theta, INDArray negativeForce, AtomicDouble sumQ) {
        if (this.cumSize == 0 || this.isLeaf() && this.size == 1 && this.index[0] == pointIndex) {
            return;
        }
        this.buf.assign(this.data.slice(pointIndex)).subi(this.centerOfMass);
        double D = Nd4j.getBlasWrapper().dot(this.buf, this.buf);
        if (this.isLeaf || FastMath.max((double)this.boundary.getHh(), (double)this.boundary.getHw()) / FastMath.sqrt((double)D) < theta) {
            double Q = 1.0 / (1.0 + D);
            double mult = (double)this.cumSize * Q;
            sumQ.addAndGet(mult);
            negativeForce.addi(this.buf.mul((Number)(mult *= Q)));
        } else {
            this.northWest.computeNonEdgeForces(pointIndex, theta, negativeForce, sumQ);
            this.northEast.computeNonEdgeForces(pointIndex, theta, negativeForce, sumQ);
            this.southWest.computeNonEdgeForces(pointIndex, theta, negativeForce, sumQ);
            this.southEast.computeNonEdgeForces(pointIndex, theta, negativeForce, sumQ);
        }
    }

    public void computeEdgeForces(INDArray rowP, INDArray colP, INDArray valP, int N, INDArray posF) {
        if (!rowP.isVector()) {
            throw new IllegalArgumentException("RowP must be a vector");
        }
        for (int n = 0; n < N; ++n) {
            for (int i = rowP.getInt(new int[]{n}); i < rowP.getInt(new int[]{n + 1}); ++i) {
                this.buf.assign(this.data.slice(n)).subi(this.data.slice(colP.getInt(new int[]{i})));
                double D = Nd4j.getBlasWrapper().dot(this.buf, this.buf);
                D = valP.getDouble(i) / D;
                posF.slice(n).addi(this.buf.mul((Number)D));
            }
        }
    }

    public int depth() {
        if (this.isLeaf()) {
            return 1;
        }
        return 1 + Math.max(Math.max(this.northWest.depth(), this.northEast.depth()), Math.max(this.southWest.depth(), this.southEast.depth()));
    }

    public INDArray getCenterOfMass() {
        return this.centerOfMass;
    }

    public void setCenterOfMass(INDArray centerOfMass) {
        this.centerOfMass = centerOfMass;
    }

    public QuadTree getParent() {
        return this.parent;
    }

    public void setParent(QuadTree parent) {
        this.parent = parent;
    }

    public QuadTree getNorthWest() {
        return this.northWest;
    }

    public void setNorthWest(QuadTree northWest) {
        this.northWest = northWest;
    }

    public QuadTree getNorthEast() {
        return this.northEast;
    }

    public void setNorthEast(QuadTree northEast) {
        this.northEast = northEast;
    }

    public QuadTree getSouthWest() {
        return this.southWest;
    }

    public void setSouthWest(QuadTree southWest) {
        this.southWest = southWest;
    }

    public QuadTree getSouthEast() {
        return this.southEast;
    }

    public void setSouthEast(QuadTree southEast) {
        this.southEast = southEast;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getCumSize() {
        return this.cumSize;
    }

    public void setCumSize(int cumSize) {
        this.cumSize = cumSize;
    }

    public Cell getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Cell boundary) {
        this.boundary = boundary;
    }
}

