/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.iterationlistener;

import java.util.ArrayList;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.plot.NeuralNetPlotter;

public class LossPlotterIterationListener
implements IterationListener {
    private int iterations = 1;
    private NeuralNetPlotter plotter = new NeuralNetPlotter();
    private boolean renderFirst = false;
    private ArrayList<Double> scores = new ArrayList();
    private boolean invoked = false;

    @Override
    public boolean invoked() {
        return this.invoked;
    }

    @Override
    public void invoke() {
        this.invoked = true;
    }

    public LossPlotterIterationListener(int iterations, boolean renderFirst) {
        this.iterations = iterations;
        this.renderFirst = renderFirst;
    }

    public LossPlotterIterationListener(int iterations, NeuralNetPlotter plotter) {
        this.iterations = iterations;
        this.plotter = plotter;
    }

    public LossPlotterIterationListener(int iterations, NeuralNetPlotter plotter, boolean renderFirst) {
        this.iterations = iterations;
        this.plotter = plotter;
        this.renderFirst = renderFirst;
    }

    public LossPlotterIterationListener(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        this.scores.add(model.score());
        if (iteration == 0 && this.renderFirst || iteration > 0 && iteration % this.iterations == 0) {
            this.invoke();
            this.plotter.updateGraphDirectory((Layer)model);
            String dataFilePath = this.plotter.writeArray(this.scores);
            this.plotter.renderGraph("loss", dataFilePath, this.plotter.getLayerGraphFilePath() + "loss.png");
        }
    }
}

