/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.updater;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.updater.AdaDeltaUpdater;
import org.deeplearning4j.nn.updater.AdaGradUpdater;
import org.deeplearning4j.nn.updater.AdamUpdater;
import org.deeplearning4j.nn.updater.MultiLayerUpdater;
import org.deeplearning4j.nn.updater.NesterovsUpdater;
import org.deeplearning4j.nn.updater.NoOpUpdater;
import org.deeplearning4j.nn.updater.RmsPropUpdater;
import org.deeplearning4j.nn.updater.SgdUpdater;

public class UpdaterCreator {
    private static org.deeplearning4j.nn.api.Updater getUpdater(NeuralNetConfiguration conf) {
        Updater updater = conf.getLayer().getUpdater();
        switch (updater) {
            case ADADELTA: {
                return new AdaDeltaUpdater();
            }
            case ADAGRAD: {
                return new AdaGradUpdater();
            }
            case ADAM: {
                return new AdamUpdater();
            }
            case NESTEROVS: {
                return new NesterovsUpdater();
            }
            case RMSPROP: {
                return new RmsPropUpdater();
            }
            case SGD: {
                return new SgdUpdater();
            }
            case NONE: {
                return new NoOpUpdater();
            }
            case CUSTOM: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
        }
        return null;
    }

    public static org.deeplearning4j.nn.api.Updater getUpdater(Model layer) {
        if (layer instanceof MultiLayerNetwork) {
            return new MultiLayerUpdater((MultiLayerNetwork)layer);
        }
        return UpdaterCreator.getUpdater(layer.conf());
    }
}

