/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.embedding;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class EmbeddingLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.EmbeddingLayer> {
    public EmbeddingLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray z = this.preOutput(this.input);
        INDArray activationDerivative = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), z).derivative());
        INDArray delta = epsilon.muli(activationDerivative);
        if (this.maskArray != null) {
            delta.muliColumnVector(this.maskArray);
        }
        INDArray weights = this.getParam("W");
        INDArray weightGradients = (INDArray)this.gradientViews.get("W");
        weightGradients.assign((Number)0);
        int[] indexes = new int[this.input.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.input.getInt(new int[]{i, 0});
            weightGradients.getRow(indexes[i]).addi(delta.getRow(i));
        }
        INDArray biasGradientsView = (INDArray)this.gradientViews.get("b");
        INDArray biasGradients = delta.sum(new int[]{0});
        biasGradientsView.assign(biasGradients);
        DefaultGradient ret = new DefaultGradient();
        ret.gradientForVariable().put("W", weightGradients);
        ret.gradientForVariable().put("b", biasGradientsView);
        return new Pair<DefaultGradient, Object>(ret, null);
    }

    @Override
    public INDArray preOutput(boolean training) {
        if (this.input.columns() != 1) {
            throw new IllegalStateException("Cannot do forward pass for embedding layer with input more than one column. Expected input shape: [numExamples,1] with each entry being an integer index");
        }
        int[] indexes = new int[this.input.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.input.getInt(new int[]{i, 0});
        }
        INDArray weights = this.getParam("W");
        INDArray bias = this.getParam("b");
        INDArray rows = Nd4j.createUninitialized((int[])new int[]{indexes.length, weights.size(1)}, (char)'c');
        for (int i = 0; i < indexes.length; ++i) {
            rows.putRow(i, weights.getRow(indexes[i]));
        }
        rows.addiRowVector(bias);
        return rows;
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray rows = this.preOutput(training);
        INDArray ret = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), rows));
        if (this.maskArray != null) {
            ret.muliColumnVector(this.maskArray);
        }
        return ret;
    }

    @Override
    protected void applyDropOutIfNecessary(boolean training) {
        throw new UnsupportedOperationException("Dropout not supported with EmbeddingLayer");
    }
}

