/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.factory;

import org.deeplearning4j.nn.api.LayerFactory;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GRU;
import org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.layers.factory.BatchNormalizationLayerFactory;
import org.deeplearning4j.nn.layers.factory.ConvolutionLayerFactory;
import org.deeplearning4j.nn.layers.factory.DefaultLayerFactory;
import org.deeplearning4j.nn.layers.factory.EmptyFactory;
import org.deeplearning4j.nn.layers.factory.GRULayerFactory;
import org.deeplearning4j.nn.layers.factory.GravesBidirectionalLSTMLayerFactory;
import org.deeplearning4j.nn.layers.factory.GravesLSTMLayerFactory;
import org.deeplearning4j.nn.layers.factory.PretrainLayerFactory;
import org.deeplearning4j.nn.layers.factory.SubsampleLayerFactory;

public class LayerFactories {
    public static LayerFactory getFactory(NeuralNetConfiguration conf) {
        return LayerFactories.getFactory(conf.getLayer());
    }

    public static LayerFactory getFactory(Layer layer) {
        Class<?> clazz = layer.getClass();
        if (clazz.equals(GravesLSTM.class)) {
            return new GravesLSTMLayerFactory(GravesLSTM.class);
        }
        if (clazz.equals(GravesBidirectionalLSTM.class)) {
            return new GravesBidirectionalLSTMLayerFactory(GravesBidirectionalLSTM.class);
        }
        if (clazz.equals(GRU.class)) {
            return new GRULayerFactory(GRU.class);
        }
        if (BasePretrainNetwork.class.isAssignableFrom(clazz)) {
            return new PretrainLayerFactory(clazz);
        }
        if (ConvolutionLayer.class.isAssignableFrom(clazz)) {
            return new ConvolutionLayerFactory(clazz);
        }
        if (SubsamplingLayer.class.isAssignableFrom(clazz)) {
            return new SubsampleLayerFactory(clazz);
        }
        if (BatchNormalization.class.isAssignableFrom(clazz)) {
            return new BatchNormalizationLayerFactory(clazz);
        }
        if (LocalResponseNormalization.class.isAssignableFrom(clazz)) {
            return new EmptyFactory(clazz);
        }
        if (ActivationLayer.class.isAssignableFrom(clazz)) {
            return new EmptyFactory(clazz);
        }
        return new DefaultLayerFactory(clazz);
    }
}

