/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;

public class FeedForwardToRnnPreProcessor
implements InputPreProcessor {
    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize) {
        if (input.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., activations for FF layer)");
        }
        if (input.ordering() == 'c') {
            input = Shape.toOffsetZeroCopy((INDArray)input, (char)'f');
        }
        int[] shape = input.shape();
        INDArray reshaped = input.reshape('f', new int[]{miniBatchSize, shape[0] / miniBatchSize, shape[1]});
        return reshaped.permute(new int[]{0, 2, 1});
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize) {
        int[] shape;
        if (output.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., epsilons from RNN layer)");
        }
        if (output.ordering() != 'f') {
            output = output.dup('f');
        }
        if ((shape = output.shape())[0] == 1) {
            return output.tensorAlongDimension(0, new int[]{1, 2}).permutei(new int[]{1, 0});
        }
        if (shape[2] == 1) {
            return output.tensorAlongDimension(0, new int[]{1, 0});
        }
        INDArray permuted = output.permute(new int[]{0, 2, 1});
        return permuted.reshape('f', shape[0] * shape[2], shape[1]);
    }

    @Override
    public FeedForwardToRnnPreProcessor clone() {
        try {
            FeedForwardToRnnPreProcessor clone = (FeedForwardToRnnPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToRnnPreProcessor)) {
            return false;
        }
        FeedForwardToRnnPreProcessor other = (FeedForwardToRnnPreProcessor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToRnnPreProcessor;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "FeedForwardToRnnPreProcessor()";
    }
}

