/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SubsetVertex
extends GraphVertex {
    private int from;
    private int to;

    public SubsetVertex(@JsonProperty(value="from") int from, @JsonProperty(value="to") int to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public SubsetVertex clone() {
        return new SubsetVertex(this.from, this.to);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SubsetVertex)) {
            return false;
        }
        SubsetVertex s = (SubsetVertex)o;
        return s.from == this.from && s.to == this.to;
    }

    @Override
    public int hashCode() {
        return new Integer(this.from).hashCode() ^ new Integer(this.to).hashCode();
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView) {
        return new org.deeplearning4j.nn.graph.vertex.impl.SubsetVertex(graph, name, idx, this.from, this.to);
    }

    @Override
    public InputType getOutputType(InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length != 1) {
            throw new InvalidInputTypeException("SubsetVertex expects single input type. Received: " + Arrays.toString(vertexInputs));
        }
        switch (vertexInputs[0].getType()) {
            case FF: {
                return InputType.feedForward(this.to - this.from + 1);
            }
            case RNN: {
                return InputType.recurrent(this.to - this.from + 1);
            }
            case CNN: {
                InputType.InputTypeConvolutional conv = (InputType.InputTypeConvolutional)vertexInputs[0];
                int depth = conv.getDepth();
                if (this.to >= depth) {
                    throw new InvalidInputTypeException("Invalid range: Cannot select depth subset [" + this.from + "," + this.to + "] inclusive from CNN activations with " + " [depth,width,height] = [" + depth + "," + conv.getWidth() + "," + conv.getHeight() + "]");
                }
                return InputType.convolutional(this.from - this.to + 1, conv.getWidth(), conv.getHeight());
            }
        }
        throw new RuntimeException("Unknown input type: " + vertexInputs[0]);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public String toString() {
        return "SubsetVertex(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

