/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.preprocessor.CnnToFeedForwardPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.CnnToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.RnnToFeedForwardPreProcessor;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationGraphConfiguration
implements Serializable,
Cloneable {
    private static Logger log = LoggerFactory.getLogger(ComputationGraphConfiguration.class);
    protected Map<String, GraphVertex> vertices = new LinkedHashMap<String, GraphVertex>();
    protected Map<String, List<String>> vertexInputs = new LinkedHashMap<String, List<String>>();
    protected List<String> networkInputs;
    protected List<String> networkOutputs;
    protected boolean pretrain = true;
    protected boolean backprop = false;
    protected BackpropType backpropType = BackpropType.Standard;
    protected int tbpttFwdLength = 20;
    protected int tbpttBackLength = 20;
    protected boolean redistributeParams = false;
    protected NeuralNetConfiguration defaultConfiguration;

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ComputationGraphConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return (ComputationGraphConfiguration)mapper.readValue(json, ComputationGraphConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ComputationGraphConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return (ComputationGraphConfiguration)mapper.readValue(json, ComputationGraphConfiguration.class);
        }
        catch (IOException iOException) {
            AnnotatedClass ac = AnnotatedClass.construct(GraphVertex.class, (AnnotationIntrospector)mapper.getSerializationConfig().getAnnotationIntrospector(), null);
            Collection types = mapper.getSubtypeResolver().collectAndResolveSubtypes(ac, (MapperConfig)mapper.getSerializationConfig(), mapper.getSerializationConfig().getAnnotationIntrospector());
            HashSet<Class> registeredSubtypes = new HashSet<Class>();
            for (NamedType nt : types) {
                registeredSubtypes.add(nt.getType());
            }
            Reflections reflections = new Reflections(new Object[0]);
            Set subTypes = reflections.getSubTypesOf(GraphVertex.class);
            ArrayList<NamedType> toRegister = new ArrayList<NamedType>();
            for (Class c : subTypes) {
                String name;
                if (registeredSubtypes.contains(c)) continue;
                if (ClassUtils.isInnerClass((Class)c)) {
                    Class<?> c2 = c.getDeclaringClass();
                    name = c2.getSimpleName() + "$" + c.getSimpleName();
                } else {
                    name = c.getSimpleName();
                }
                toRegister.add(new NamedType(c, name));
            }
            mapper = NeuralNetConfiguration.reinitMapperWithSubtypes(toRegister);
            try {
                return (ComputationGraphConfiguration)mapper.readValue(json, ComputationGraphConfiguration.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.toJson();
    }

    public ComputationGraphConfiguration clone() {
        ComputationGraphConfiguration conf = new ComputationGraphConfiguration();
        conf.vertices = new HashMap<String, GraphVertex>();
        for (Map.Entry<String, GraphVertex> entry : this.vertices.entrySet()) {
            conf.vertices.put(entry.getKey(), entry.getValue().clone());
        }
        conf.vertexInputs = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> entry : this.vertexInputs.entrySet()) {
            conf.vertexInputs.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        conf.networkInputs = new ArrayList<String>(this.networkInputs);
        conf.networkOutputs = new ArrayList<String>(this.networkOutputs);
        conf.pretrain = this.pretrain;
        conf.backprop = this.backprop;
        conf.backpropType = this.backpropType;
        conf.tbpttFwdLength = this.tbpttFwdLength;
        conf.tbpttBackLength = this.tbpttBackLength;
        conf.redistributeParams = this.redistributeParams;
        conf.defaultConfiguration = this.defaultConfiguration.clone();
        return conf;
    }

    public void validate() {
        if (this.networkInputs == null || this.networkInputs.size() < 1) {
            throw new IllegalStateException("Invalid configuration: network has no inputs");
        }
        if (this.networkOutputs == null || this.networkOutputs.size() < 1) {
            throw new IllegalStateException("Invalid configuration: network has no outputs");
        }
        for (String string : this.networkInputs) {
            if (!this.vertices.containsKey(string)) continue;
            throw new IllegalStateException("Invalid configuration: name \"" + string + "\" is present in both network inputs and graph vertices/layers");
        }
        for (Map.Entry entry : this.vertexInputs.entrySet()) {
            String nodeName = (String)entry.getKey();
            if (entry.getValue() == null || ((List)entry.getValue()).size() == 0) {
                throw new IllegalStateException("Invalid configuration: vertex \"" + nodeName + "\" has no inputs");
            }
            for (String inputName : (List)entry.getValue()) {
                if (this.vertices.containsKey(inputName) || this.networkInputs.contains(inputName)) continue;
                throw new IllegalStateException("Invalid configuration: Vertex \"" + nodeName + "\" has input \"" + inputName + "\" that does not exist");
            }
        }
        for (String string : this.networkOutputs) {
            if (this.vertices.containsKey(string)) continue;
            throw new IllegalStateException("Invalid configuration: Output name \"" + string + "\" is not a valid vertex");
        }
    }

    public void addPreProcessors(InputType ... inputTypes) {
        if (inputTypes == null || inputTypes.length != this.networkInputs.size()) {
            throw new IllegalArgumentException("Invalid number of InputTypes: cannot add preprocessors if number of InputType objects differs from number of network inputs");
        }
        HashMap<String, ArrayList<String>> verticesOutputTo = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, GraphVertex> entry : this.vertices.entrySet()) {
            String vertexName = entry.getKey();
            List<String> vertexInputNames = this.vertexInputs.get(vertexName);
            if (vertexInputNames == null) continue;
            for (String string : vertexInputNames) {
                ArrayList<String> list = (ArrayList<String>)verticesOutputTo.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    verticesOutputTo.put(string, list);
                }
                list.add(vertexName);
            }
        }
        LinkedList<String> noIncomingEdges = new LinkedList<String>(this.networkInputs);
        ArrayList<Object> topologicalOrdering = new ArrayList<Object>();
        HashMap inputEdges = new HashMap();
        for (Map.Entry entry : this.vertexInputs.entrySet()) {
            inputEdges.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        while (noIncomingEdges.size() > 0) {
            String next = noIncomingEdges.removeFirst();
            topologicalOrdering.add(next);
            List list = (List)verticesOutputTo.get(next);
            if (list == null || list.size() <= 0) continue;
            for (String s : list) {
                Set set = (Set)inputEdges.get(s);
                set.remove(next);
                if (set.size() != 0) continue;
                noIncomingEdges.add(s);
            }
        }
        for (Map.Entry entry : inputEdges.entrySet()) {
            Set set = (Set)entry.getValue();
            if (set == null || set.size() <= 0) continue;
            throw new IllegalStateException("Invalid configuration: cycle detected in graph. Cannot calculate topological ordering with graph cycle (cycle includes vertex \"" + (String)entry.getKey() + "\")");
        }
        HashMap<String, InputType> vertexOutputs = new HashMap<String, InputType>();
        for (String string : topologicalOrdering) {
            int inputIdx = this.networkInputs.indexOf(string);
            if (inputIdx != -1) {
                vertexOutputs.put(string, inputTypes[inputIdx]);
                continue;
            }
            GraphVertex gv = this.vertices.get(string);
            ArrayList<InputType> inputTypeList = new ArrayList<InputType>();
            if (gv instanceof LayerVertex) {
                int nIn;
                InputType.InputTypeConvolutional conv;
                String in = this.vertexInputs.get(string).get(0);
                InputType layerInput = (InputType)vertexOutputs.get(in);
                LayerVertex lv = (LayerVertex)gv;
                if (lv.getPreProcessor() != null) continue;
                Layer l = lv.getLayerConf().getLayer();
                if (l instanceof ConvolutionLayer || l instanceof SubsamplingLayer) {
                    switch (layerInput.getType()) {
                        case FF: {
                            log.warn("Automatic addition of FF -> CNN preprocessors: not yet implemented (layer: " + string + ")");
                            break;
                        }
                        case RNN: {
                            log.warn("Automatic addition of RNN -> CNN preprocessors: not yet implemented (layer: " + string + ")");
                            break;
                        }
                        case CNN: {
                            if (!this.networkInputs.contains(this.vertexInputs.get(string).get(0))) break;
                            conv = (InputType.InputTypeConvolutional)layerInput;
                            lv.setPreProcessor(new FeedForwardToCnnPreProcessor(conv.getHeight(), conv.getWidth(), conv.getDepth()));
                        }
                    }
                } else if (l instanceof BaseRecurrentLayer || l instanceof RnnOutputLayer) {
                    switch (layerInput.getType()) {
                        case FF: {
                            lv.setPreProcessor(new FeedForwardToRnnPreProcessor());
                            ComputationGraphConfiguration.setNInIfNecessary(lv, layerInput);
                            break;
                        }
                        case RNN: {
                            ComputationGraphConfiguration.setNInIfNecessary(lv, layerInput);
                            break;
                        }
                        case CNN: {
                            conv = (InputType.InputTypeConvolutional)layerInput;
                            lv.setPreProcessor(new CnnToRnnPreProcessor(conv.getHeight(), conv.getWidth(), conv.getDepth()));
                            nIn = conv.getHeight() * conv.getWidth() * conv.getDepth();
                            ((FeedForwardLayer)lv.getLayerConf().getLayer()).setNIn(nIn);
                        }
                    }
                } else {
                    switch (layerInput.getType()) {
                        case FF: {
                            ComputationGraphConfiguration.setNInIfNecessary(lv, layerInput);
                            break;
                        }
                        case RNN: {
                            lv.setPreProcessor(new RnnToFeedForwardPreProcessor());
                            ComputationGraphConfiguration.setNInIfNecessary(lv, layerInput);
                            break;
                        }
                        case CNN: {
                            conv = (InputType.InputTypeConvolutional)layerInput;
                            lv.setPreProcessor(new CnnToFeedForwardPreProcessor(conv.getHeight(), conv.getWidth(), conv.getDepth()));
                            nIn = conv.getHeight() * conv.getWidth() * conv.getDepth();
                            ((FeedForwardLayer)lv.getLayerConf().getLayer()).setNIn(nIn);
                        }
                    }
                }
                inputTypeList.add(layerInput);
            } else {
                List<String> inputs = this.vertexInputs.get(string);
                if (inputs != null) {
                    for (String inputVertexName : inputs) {
                        inputTypeList.add((InputType)vertexOutputs.get(inputVertexName));
                    }
                }
            }
            InputType outputFromVertex = gv.getOutputType(inputTypeList.toArray(new InputType[inputTypeList.size()]));
            vertexOutputs.put(string, outputFromVertex);
        }
    }

    private static void setNInIfNecessary(LayerVertex lv, InputType inputType) {
        FeedForwardLayer ffl = (FeedForwardLayer)lv.getLayerConf().getLayer();
        if (ffl.getNIn() == 0) {
            int size;
            if (inputType instanceof InputType.InputTypeFeedForward) {
                size = ((InputType.InputTypeFeedForward)inputType).getSize();
            } else if (inputType instanceof InputType.InputTypeRecurrent) {
                size = ((InputType.InputTypeRecurrent)inputType).getSize();
            } else {
                throw new UnsupportedOperationException("Invalid input type");
            }
            if (size > 0) {
                ffl.setNIn(size);
            }
        }
    }

    public Map<String, GraphVertex> getVertices() {
        return this.vertices;
    }

    public Map<String, List<String>> getVertexInputs() {
        return this.vertexInputs;
    }

    public List<String> getNetworkInputs() {
        return this.networkInputs;
    }

    public List<String> getNetworkOutputs() {
        return this.networkOutputs;
    }

    public boolean isPretrain() {
        return this.pretrain;
    }

    public boolean isBackprop() {
        return this.backprop;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public int getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public int getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    public boolean isRedistributeParams() {
        return this.redistributeParams;
    }

    public NeuralNetConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setVertices(Map<String, GraphVertex> vertices) {
        this.vertices = vertices;
    }

    public void setVertexInputs(Map<String, List<String>> vertexInputs) {
        this.vertexInputs = vertexInputs;
    }

    public void setNetworkInputs(List<String> networkInputs) {
        this.networkInputs = networkInputs;
    }

    public void setNetworkOutputs(List<String> networkOutputs) {
        this.networkOutputs = networkOutputs;
    }

    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    public void setBackprop(boolean backprop) {
        this.backprop = backprop;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(int tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(int tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    public void setRedistributeParams(boolean redistributeParams) {
        this.redistributeParams = redistributeParams;
    }

    public void setDefaultConfiguration(NeuralNetConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputationGraphConfiguration)) {
            return false;
        }
        ComputationGraphConfiguration other = (ComputationGraphConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, GraphVertex> this$vertices = this.getVertices();
        Map<String, GraphVertex> other$vertices = other.getVertices();
        if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
            return false;
        }
        Map<String, List<String>> this$vertexInputs = this.getVertexInputs();
        Map<String, List<String>> other$vertexInputs = other.getVertexInputs();
        if (this$vertexInputs == null ? other$vertexInputs != null : !((Object)this$vertexInputs).equals(other$vertexInputs)) {
            return false;
        }
        List<String> this$networkInputs = this.getNetworkInputs();
        List<String> other$networkInputs = other.getNetworkInputs();
        if (this$networkInputs == null ? other$networkInputs != null : !((Object)this$networkInputs).equals(other$networkInputs)) {
            return false;
        }
        List<String> this$networkOutputs = this.getNetworkOutputs();
        List<String> other$networkOutputs = other.getNetworkOutputs();
        if (this$networkOutputs == null ? other$networkOutputs != null : !((Object)this$networkOutputs).equals(other$networkOutputs)) {
            return false;
        }
        if (this.isPretrain() != other.isPretrain()) {
            return false;
        }
        if (this.isBackprop() != other.isBackprop()) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
            return false;
        }
        if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
            return false;
        }
        if (this.isRedistributeParams() != other.isRedistributeParams()) {
            return false;
        }
        NeuralNetConfiguration this$defaultConfiguration = this.getDefaultConfiguration();
        NeuralNetConfiguration other$defaultConfiguration = other.getDefaultConfiguration();
        return !(this$defaultConfiguration == null ? other$defaultConfiguration != null : !((Object)this$defaultConfiguration).equals(other$defaultConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputationGraphConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, GraphVertex> $vertices = this.getVertices();
        result = result * 59 + ($vertices == null ? 0 : ((Object)$vertices).hashCode());
        Map<String, List<String>> $vertexInputs = this.getVertexInputs();
        result = result * 59 + ($vertexInputs == null ? 0 : ((Object)$vertexInputs).hashCode());
        List<String> $networkInputs = this.getNetworkInputs();
        result = result * 59 + ($networkInputs == null ? 0 : ((Object)$networkInputs).hashCode());
        List<String> $networkOutputs = this.getNetworkOutputs();
        result = result * 59 + ($networkOutputs == null ? 0 : ((Object)$networkOutputs).hashCode());
        result = result * 59 + (this.isPretrain() ? 79 : 97);
        result = result * 59 + (this.isBackprop() ? 79 : 97);
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 0 : ((Object)((Object)$backpropType)).hashCode());
        result = result * 59 + this.getTbpttFwdLength();
        result = result * 59 + this.getTbpttBackLength();
        result = result * 59 + (this.isRedistributeParams() ? 79 : 97);
        NeuralNetConfiguration $defaultConfiguration = this.getDefaultConfiguration();
        result = result * 59 + ($defaultConfiguration == null ? 0 : ((Object)$defaultConfiguration).hashCode());
        return result;
    }

    private ComputationGraphConfiguration(Map<String, GraphVertex> vertices, Map<String, List<String>> vertexInputs, List<String> networkInputs, List<String> networkOutputs, boolean pretrain, boolean backprop, BackpropType backpropType, int tbpttFwdLength, int tbpttBackLength, boolean redistributeParams, NeuralNetConfiguration defaultConfiguration) {
        this.vertices = vertices;
        this.vertexInputs = vertexInputs;
        this.networkInputs = networkInputs;
        this.networkOutputs = networkOutputs;
        this.pretrain = pretrain;
        this.backprop = backprop;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
        this.redistributeParams = redistributeParams;
        this.defaultConfiguration = defaultConfiguration;
    }

    public ComputationGraphConfiguration() {
    }

    public static class GraphBuilder {
        protected Map<String, GraphVertex> vertices = new LinkedHashMap<String, GraphVertex>();
        protected Map<String, List<String>> vertexInputs = new LinkedHashMap<String, List<String>>();
        protected List<String> networkInputs = new ArrayList<String>();
        protected List<InputType> networkInputTypes = new ArrayList<InputType>();
        protected List<String> networkOutputs = new ArrayList<String>();
        protected boolean pretrain = false;
        protected boolean backprop = true;
        protected BackpropType backpropType = BackpropType.Standard;
        protected int tbpttFwdLength = 20;
        protected int tbpttBackLength = 20;
        protected Map<String, InputPreProcessor> inputPreProcessors = new LinkedHashMap<String, InputPreProcessor>();
        protected boolean redistributeParams = false;
        protected NeuralNetConfiguration.Builder globalConfiguration;

        public GraphBuilder(NeuralNetConfiguration.Builder globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
        }

        public GraphBuilder redistributeParams(boolean redistributeParams) {
            this.redistributeParams = redistributeParams;
            return this;
        }

        public GraphBuilder inputPreProcessor(String layer, InputPreProcessor processor) {
            this.inputPreProcessors.put(layer, processor);
            return this;
        }

        public GraphBuilder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        public GraphBuilder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public GraphBuilder backpropType(BackpropType type) {
            this.backpropType = type;
            return this;
        }

        public GraphBuilder tBPTTForwardLength(int forwardLength) {
            this.tbpttFwdLength = forwardLength;
            return this;
        }

        public GraphBuilder tBPTTBackwardLength(int backwardLength) {
            this.tbpttBackLength = backwardLength;
            return this;
        }

        public GraphBuilder addLayer(String layerName, Layer layer, String ... layerInputs) {
            return this.addLayer(layerName, layer, (InputPreProcessor)null, layerInputs);
        }

        public GraphBuilder addLayer(String layerName, Layer layer, InputPreProcessor preProcessor, String ... layerInputs) {
            NeuralNetConfiguration.Builder builder = this.globalConfiguration.clone();
            builder.layer(layer);
            this.vertices.put(layerName, new LayerVertex(builder.build(), preProcessor));
            if (layerInputs != null && layerInputs.length > 1) {
                String mergeName = layerName + "-merge";
                this.addVertex(mergeName, new MergeVertex(), layerInputs);
                this.vertexInputs.put(layerName, Collections.singletonList(mergeName));
            } else if (layerInputs != null) {
                this.vertexInputs.put(layerName, Arrays.asList(layerInputs));
            }
            layer.setLayerName(layerName);
            return this;
        }

        public GraphBuilder addInputs(String ... inputNames) {
            Collections.addAll(this.networkInputs, inputNames);
            return this;
        }

        public GraphBuilder setInputTypes(InputType ... inputTypes) {
            if (inputTypes != null && inputTypes.length > 0) {
                Collections.addAll(this.networkInputTypes, inputTypes);
            }
            return this;
        }

        public GraphBuilder setOutputs(String ... outputNames) {
            Collections.addAll(this.networkOutputs, outputNames);
            return this;
        }

        public GraphBuilder addVertex(String vertexName, GraphVertex vertex, String ... vertexInputs) {
            this.vertices.put(vertexName, vertex);
            this.vertexInputs.put(vertexName, Arrays.asList(vertexInputs));
            return this;
        }

        public ComputationGraphConfiguration build() {
            ComputationGraphConfiguration conf = new ComputationGraphConfiguration();
            conf.backprop = this.backprop;
            conf.pretrain = this.pretrain;
            conf.backpropType = this.backpropType;
            conf.tbpttBackLength = this.tbpttBackLength;
            conf.tbpttFwdLength = this.tbpttFwdLength;
            conf.networkInputs = this.networkInputs;
            conf.networkOutputs = this.networkOutputs;
            conf.vertices = this.vertices;
            conf.vertexInputs = this.vertexInputs;
            conf.defaultConfiguration = this.globalConfiguration.build();
            for (Map.Entry<String, InputPreProcessor> entry : this.inputPreProcessors.entrySet()) {
                GraphVertex gv = this.vertices.get(entry.getKey());
                if (gv instanceof LayerVertex) {
                    LayerVertex lv = (LayerVertex)gv;
                    lv.setPreProcessor(entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Invalid configuration: InputPreProcessor defined for GraphVertex \"" + entry.getKey() + "\", but this vertex is not a LayerVertex");
            }
            conf.validate();
            if (this.networkInputTypes.size() > 0) {
                conf.addPreProcessors(this.networkInputTypes.toArray(new InputType[this.networkInputs.size()]));
            }
            return conf;
        }

        public Map<String, GraphVertex> getVertices() {
            return this.vertices;
        }

        public Map<String, List<String>> getVertexInputs() {
            return this.vertexInputs;
        }

        public List<String> getNetworkInputs() {
            return this.networkInputs;
        }

        public List<InputType> getNetworkInputTypes() {
            return this.networkInputTypes;
        }

        public List<String> getNetworkOutputs() {
            return this.networkOutputs;
        }

        public boolean isPretrain() {
            return this.pretrain;
        }

        public boolean isBackprop() {
            return this.backprop;
        }

        public BackpropType getBackpropType() {
            return this.backpropType;
        }

        public int getTbpttFwdLength() {
            return this.tbpttFwdLength;
        }

        public int getTbpttBackLength() {
            return this.tbpttBackLength;
        }

        public Map<String, InputPreProcessor> getInputPreProcessors() {
            return this.inputPreProcessors;
        }

        public boolean isRedistributeParams() {
            return this.redistributeParams;
        }

        public NeuralNetConfiguration.Builder getGlobalConfiguration() {
            return this.globalConfiguration;
        }

        public void setVertices(Map<String, GraphVertex> vertices) {
            this.vertices = vertices;
        }

        public void setVertexInputs(Map<String, List<String>> vertexInputs) {
            this.vertexInputs = vertexInputs;
        }

        public void setNetworkInputs(List<String> networkInputs) {
            this.networkInputs = networkInputs;
        }

        public void setNetworkInputTypes(List<InputType> networkInputTypes) {
            this.networkInputTypes = networkInputTypes;
        }

        public void setNetworkOutputs(List<String> networkOutputs) {
            this.networkOutputs = networkOutputs;
        }

        public void setPretrain(boolean pretrain) {
            this.pretrain = pretrain;
        }

        public void setBackprop(boolean backprop) {
            this.backprop = backprop;
        }

        public void setBackpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
        }

        public void setTbpttFwdLength(int tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
        }

        public void setTbpttBackLength(int tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
        }

        public void setInputPreProcessors(Map<String, InputPreProcessor> inputPreProcessors) {
            this.inputPreProcessors = inputPreProcessors;
        }

        public void setRedistributeParams(boolean redistributeParams) {
            this.redistributeParams = redistributeParams;
        }

        public void setGlobalConfiguration(NeuralNetConfiguration.Builder globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GraphBuilder)) {
                return false;
            }
            GraphBuilder other = (GraphBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, GraphVertex> this$vertices = this.getVertices();
            Map<String, GraphVertex> other$vertices = other.getVertices();
            if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
                return false;
            }
            Map<String, List<String>> this$vertexInputs = this.getVertexInputs();
            Map<String, List<String>> other$vertexInputs = other.getVertexInputs();
            if (this$vertexInputs == null ? other$vertexInputs != null : !((Object)this$vertexInputs).equals(other$vertexInputs)) {
                return false;
            }
            List<String> this$networkInputs = this.getNetworkInputs();
            List<String> other$networkInputs = other.getNetworkInputs();
            if (this$networkInputs == null ? other$networkInputs != null : !((Object)this$networkInputs).equals(other$networkInputs)) {
                return false;
            }
            List<InputType> this$networkInputTypes = this.getNetworkInputTypes();
            List<InputType> other$networkInputTypes = other.getNetworkInputTypes();
            if (this$networkInputTypes == null ? other$networkInputTypes != null : !((Object)this$networkInputTypes).equals(other$networkInputTypes)) {
                return false;
            }
            List<String> this$networkOutputs = this.getNetworkOutputs();
            List<String> other$networkOutputs = other.getNetworkOutputs();
            if (this$networkOutputs == null ? other$networkOutputs != null : !((Object)this$networkOutputs).equals(other$networkOutputs)) {
                return false;
            }
            if (this.isPretrain() != other.isPretrain()) {
                return false;
            }
            if (this.isBackprop() != other.isBackprop()) {
                return false;
            }
            BackpropType this$backpropType = this.getBackpropType();
            BackpropType other$backpropType = other.getBackpropType();
            if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
                return false;
            }
            if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
                return false;
            }
            if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
                return false;
            }
            Map<String, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
            Map<String, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
            if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
                return false;
            }
            if (this.isRedistributeParams() != other.isRedistributeParams()) {
                return false;
            }
            NeuralNetConfiguration.Builder this$globalConfiguration = this.getGlobalConfiguration();
            NeuralNetConfiguration.Builder other$globalConfiguration = other.getGlobalConfiguration();
            return !(this$globalConfiguration == null ? other$globalConfiguration != null : !((Object)this$globalConfiguration).equals(other$globalConfiguration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GraphBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, GraphVertex> $vertices = this.getVertices();
            result = result * 59 + ($vertices == null ? 0 : ((Object)$vertices).hashCode());
            Map<String, List<String>> $vertexInputs = this.getVertexInputs();
            result = result * 59 + ($vertexInputs == null ? 0 : ((Object)$vertexInputs).hashCode());
            List<String> $networkInputs = this.getNetworkInputs();
            result = result * 59 + ($networkInputs == null ? 0 : ((Object)$networkInputs).hashCode());
            List<InputType> $networkInputTypes = this.getNetworkInputTypes();
            result = result * 59 + ($networkInputTypes == null ? 0 : ((Object)$networkInputTypes).hashCode());
            List<String> $networkOutputs = this.getNetworkOutputs();
            result = result * 59 + ($networkOutputs == null ? 0 : ((Object)$networkOutputs).hashCode());
            result = result * 59 + (this.isPretrain() ? 79 : 97);
            result = result * 59 + (this.isBackprop() ? 79 : 97);
            BackpropType $backpropType = this.getBackpropType();
            result = result * 59 + ($backpropType == null ? 0 : ((Object)((Object)$backpropType)).hashCode());
            result = result * 59 + this.getTbpttFwdLength();
            result = result * 59 + this.getTbpttBackLength();
            Map<String, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
            result = result * 59 + ($inputPreProcessors == null ? 0 : ((Object)$inputPreProcessors).hashCode());
            result = result * 59 + (this.isRedistributeParams() ? 79 : 97);
            NeuralNetConfiguration.Builder $globalConfiguration = this.getGlobalConfiguration();
            result = result * 59 + ($globalConfiguration == null ? 0 : ((Object)$globalConfiguration).hashCode());
            return result;
        }

        public String toString() {
            return "ComputationGraphConfiguration.GraphBuilder(vertices=" + this.getVertices() + ", vertexInputs=" + this.getVertexInputs() + ", networkInputs=" + this.getNetworkInputs() + ", networkInputTypes=" + this.getNetworkInputTypes() + ", networkOutputs=" + this.getNetworkOutputs() + ", pretrain=" + this.isPretrain() + ", backprop=" + this.isBackprop() + ", backpropType=" + (Object)((Object)this.getBackpropType()) + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ", inputPreProcessors=" + this.getInputPreProcessors() + ", redistributeParams=" + this.isRedistributeParams() + ", globalConfiguration=" + this.getGlobalConfiguration() + ")";
        }
    }
}

