/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.sptree;

import java.io.Serializable;

public class HeapItem
implements Serializable,
Comparable<HeapItem> {
    private int index;
    private double distance;

    public HeapItem(int index, double distance) {
        this.index = index;
        this.distance = distance;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeapItem heapItem = (HeapItem)o;
        if (this.index != heapItem.index) {
            return false;
        }
        return Double.compare(heapItem.distance, this.distance) == 0;
    }

    public int hashCode() {
        int result = this.index;
        long temp = Double.doubleToLongBits(this.distance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int compareTo(HeapItem o) {
        return this.distance < o.distance ? 1 : 0;
    }
}

