/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster.info;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.clustering.cluster.Cluster;
import org.deeplearning4j.clustering.cluster.ClusterSet;
import org.deeplearning4j.clustering.cluster.info.ClusterInfo;

public class ClusterSetInfo {
    private Map<String, ClusterInfo> clustersInfos = new HashMap<String, ClusterInfo>();
    private Table<String, String, Double> distancesBetweenClustersCenters = HashBasedTable.create();
    private AtomicInteger pointLocationChange = new AtomicInteger(0);
    private boolean threadSafe;

    public ClusterSetInfo() {
        this(false);
    }

    public ClusterSetInfo(boolean threadSafe) {
        this.threadSafe = threadSafe;
        if (threadSafe) {
            this.clustersInfos = Collections.synchronizedMap(this.clustersInfos);
        }
    }

    public static ClusterSetInfo initialize(ClusterSet clusterSet, boolean threadSafe) {
        ClusterSetInfo info = new ClusterSetInfo();
        int j = clusterSet.getClusterCount();
        for (int i = 0; i < j; ++i) {
            info.addClusterInfo(clusterSet.getClusters().get(i).getId());
        }
        return info;
    }

    public void removeClusterInfos(List<Cluster> clusters) {
        for (Cluster cluster : clusters) {
            this.clustersInfos.remove(cluster.getId());
        }
    }

    public ClusterInfo addClusterInfo(String clusterId) {
        ClusterInfo clusterInfo = new ClusterInfo(this.threadSafe);
        this.clustersInfos.put(clusterId, clusterInfo);
        return clusterInfo;
    }

    public ClusterInfo getClusterInfo(String clusterId) {
        return this.clustersInfos.get(clusterId);
    }

    public double getAveragePointDistanceFromClusterCenter() {
        if (this.clustersInfos == null || this.clustersInfos.size() == 0) {
            return 0.0;
        }
        double average = 0.0;
        for (ClusterInfo info : this.clustersInfos.values()) {
            average += info.getAveragePointDistanceFromCenter();
        }
        return average / (double)this.clustersInfos.size();
    }

    public double getPointDistanceFromClusterVariance() {
        if (this.clustersInfos == null || this.clustersInfos.size() == 0) {
            return 0.0;
        }
        double average = 0.0;
        for (ClusterInfo info : this.clustersInfos.values()) {
            average += info.getPointDistanceFromCenterVariance();
        }
        return average / (double)this.clustersInfos.size();
    }

    public int getPointsCount() {
        int count = 0;
        for (ClusterInfo clusterInfo : this.clustersInfos.values()) {
            count += clusterInfo.getPointDistancesFromCenter().size();
        }
        return count;
    }

    public Map<String, ClusterInfo> getClustersInfos() {
        return this.clustersInfos;
    }

    public void setClustersInfos(Map<String, ClusterInfo> clustersInfos) {
        this.clustersInfos = clustersInfos;
    }

    public Table<String, String, Double> getDistancesBetweenClustersCenters() {
        return this.distancesBetweenClustersCenters;
    }

    public void setDistancesBetweenClustersCenters(Table<String, String, Double> interClusterDistances) {
        this.distancesBetweenClustersCenters = interClusterDistances;
    }

    public AtomicInteger getPointLocationChange() {
        return this.pointLocationChange;
    }

    public void setPointLocationChange(AtomicInteger pointLocationChange) {
        this.pointLocationChange = pointLocationChange;
    }
}

