/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.Solver;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;

public abstract class BaseLayer<LayerConfT extends Layer>
implements org.deeplearning4j.nn.api.Layer {
    protected INDArray input;
    protected Map<String, INDArray> params;
    protected NeuralNetConfiguration conf;
    protected INDArray dropoutMask;
    protected ParamInitializer paramInitializer;
    protected double score = 0.0;
    protected ConvexOptimizer optimizer;
    protected Gradient gradient;
    protected Collection<IterationListener> iterationListeners = new ArrayList<IterationListener>();
    protected int index = 0;
    protected int inputMiniBatchSize;

    public BaseLayer(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    public BaseLayer(NeuralNetConfiguration conf, INDArray input) {
        this.input = input;
        this.conf = conf;
    }

    protected LayerConfT layerConf() {
        return (LayerConfT)this.conf.getLayer();
    }

    public INDArray getInput() {
        return this.input;
    }

    public void setInput(INDArray input, boolean training) {
        if (this.conf.getLayer().getDropOut() > 0.0 && training) {
            this.dropoutMask = Dropout.applyDropout(input, this.conf.getLayer().getDropOut(), this.dropoutMask);
        }
        this.input = input;
    }

    @Override
    public void setInput(INDArray input) {
        this.setInput(input, true);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Collection<IterationListener> getListeners() {
        return this.iterationListeners;
    }

    @Override
    public void setListeners(Collection<IterationListener> listeners) {
        this.iterationListeners = listeners != null ? listeners : new ArrayList();
    }

    @Override
    public void setListeners(IterationListener ... listeners) {
        this.iterationListeners = new ArrayList<IterationListener>();
        for (IterationListener l : listeners) {
            this.iterationListeners.add(l);
        }
    }

    @Override
    public Gradient error(INDArray errorSignal) {
        INDArray W = this.getParam("W");
        DefaultGradient nextLayerGradient = new DefaultGradient();
        INDArray wErrorSignal = errorSignal.mmul(W.transpose());
        nextLayerGradient.gradientForVariable().put("W", wErrorSignal);
        return nextLayerGradient;
    }

    @Override
    public INDArray derivativeActivation(INDArray input) {
        INDArray deriv = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), input).derivative());
        return deriv;
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        DefaultGradient ret = new DefaultGradient();
        INDArray weightErrorSignal = layerError.getGradientFor("W");
        INDArray weightError = weightErrorSignal.transpose().mmul(activation).transpose();
        ret.gradientForVariable().put("W", weightError);
        INDArray biasGradient = weightError.mean(new int[]{0});
        ret.gradientForVariable().put("b", biasGradient);
        return ret;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray z = this.preOutput(this.input);
        INDArray activationDerivative = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), z).derivative());
        INDArray delta = epsilon.muli(activationDerivative);
        DefaultGradient ret = new DefaultGradient();
        ret.gradientForVariable().put("W", delta.transpose().mmul(this.input).transpose());
        ret.gradientForVariable().put("b", delta.sum(new int[]{0}));
        INDArray epsilonNext = this.params.get("W").mmul(delta.transpose()).transpose();
        return new Pair<Gradient, INDArray>(ret, epsilonNext);
    }

    @Override
    public void fit() {
        this.fit(this.input);
    }

    @Override
    public void computeGradientAndScore() {
        if (this.input == null) {
            return;
        }
        INDArray output = this.activate(true);
        this.setScoreWithZ(output);
    }

    protected void setScoreWithZ(INDArray z) {
    }

    @Override
    public INDArray preOutput(INDArray x, Layer.TrainingMode training) {
        return this.preOutput(x, training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public INDArray activate(Layer.TrainingMode training) {
        return this.activate(training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public INDArray activate(INDArray input, Layer.TrainingMode training) {
        return this.activate(input, training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public Gradient gradient() {
        return this.gradient;
    }

    @Override
    public void iterate(INDArray input) {
        this.setInput(input.dup());
        this.applyDropOutIfNecessary(this.input, true);
        Gradient gradient = this.gradient();
        for (String paramType : gradient.gradientForVariable().keySet()) {
            this.update(gradient.getGradientFor(paramType), paramType);
        }
    }

    @Override
    public void update(Gradient gradient) {
        for (String paramType : gradient.gradientForVariable().keySet()) {
            this.update(gradient.getGradientFor(paramType), paramType);
        }
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        this.setParam(paramType, this.getParam(paramType).addi(gradient));
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        if (this.optimizer == null) {
            Solver solver = new Solver.Builder().model(this).configure(this.conf()).build();
            this.optimizer = solver.getOptimizer();
        }
        return this.optimizer;
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public INDArray params() {
        return Nd4j.toFlattened((char)'f', this.params.values());
    }

    @Override
    public INDArray getParam(String param) {
        return this.params.get(param);
    }

    @Override
    public void setParam(String key, INDArray val) {
        this.params.put(key, val);
    }

    @Override
    public void setParams(INDArray params) {
        List<String> parameterList = this.conf.variables();
        int length = 0;
        for (String s : parameterList) {
            length += this.getParam(s).length();
        }
        if (params.length() != length) {
            throw new IllegalArgumentException("Unable to set parameters: must be of length " + length);
        }
        int idx = 0;
        Set<String> paramKeySet = this.params.keySet();
        for (String s : paramKeySet) {
            INDArray param = this.getParam(s);
            INDArray get = params.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)idx, (int)(idx + param.length()))});
            if (param.length() != get.length()) {
                throw new IllegalStateException("Parameter " + s + " should have been of length " + param.length() + " but was " + get.length());
            }
            this.setParam(s, get.reshape('f', param.shape()));
            idx += param.length();
        }
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        this.params = paramTable;
    }

    @Override
    public void initParams() {
        this.paramInitializer.init(this.paramTable(), this.conf());
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.params;
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        if (x == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        this.setInput(x, training);
        this.applyDropOutIfNecessary(x, training);
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        if (this.conf.isUseDropConnect() && training && this.conf.getLayer().getDropOut() > 0.0) {
            W = Dropout.applyDropConnect(this, "W");
        }
        INDArray ret = x.mmul(W).addiRowVector(b);
        return ret;
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        if (this.conf.isUseDropConnect() && training) {
            W = Dropout.applyDropConnect(this, "W");
        }
        INDArray ret = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), this.input().mmul(W).addiRowVector(b)));
        return ret;
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input, true);
        return this.activate(true);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input, training);
        return this.activate(training);
    }

    @Override
    public INDArray activate() {
        return this.activate(false);
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.preOutput(x, true);
    }

    @Override
    public double calcL2() {
        if (!this.conf.isUseRegularization() || this.conf.getL2() <= 0.0) {
            return 0.0;
        }
        return 0.5 * this.conf.getL2() * Transforms.pow((INDArray)this.getParam("W"), (Number)2).sum(new int[]{Integer.MAX_VALUE}).getDouble(0);
    }

    @Override
    public double calcL1() {
        if (!this.conf.isUseRegularization() || this.conf.getL1() <= 0.0) {
            return 0.0;
        }
        return this.conf.getL1() * Transforms.abs((INDArray)this.getParam("W")).sum(new int[]{Integer.MAX_VALUE}).getDouble(0);
    }

    @Override
    public int batchSize() {
        return this.input.size(0);
    }

    @Override
    public INDArray activationMean() {
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        return this.input().mmul(W).addiRowVector(b);
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.conf;
    }

    @Override
    public void clear() {
        if (this.input != null) {
            this.input.data().destroy();
            this.input = null;
        }
    }

    protected void applyDropOutIfNecessary(INDArray input, boolean training) {
        if (this.conf.getLayer().getDropOut() > 0.0 && !this.conf.isUseDropConnect() && training) {
            this.dropoutMask = Dropout.applyDropout(input, this.conf.getLayer().getDropOut(), this.dropoutMask);
        }
    }

    @Override
    public void merge(org.deeplearning4j.nn.api.Layer l, int batchSize) {
        this.setParams(this.params().addi(l.params().divi((Number)batchSize)));
        this.computeGradientAndScore();
    }

    @Override
    public org.deeplearning4j.nn.api.Layer clone() {
        org.deeplearning4j.nn.api.Layer layer = null;
        try {
            Constructor<?> c = this.getClass().getConstructor(NeuralNetConfiguration.class);
            layer = (org.deeplearning4j.nn.api.Layer)c.newInstance(this.conf);
            LinkedHashMap<String, INDArray> linkedTable = new LinkedHashMap<String, INDArray>();
            for (String s : this.params.keySet()) {
                linkedTable.put(s, this.params.get(s).dup());
            }
            layer.setParamTable(linkedTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layer;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public int numParams() {
        int ret = 0;
        for (INDArray val : this.params.values()) {
            ret += val.length();
        }
        return ret;
    }

    @Override
    public void fit(INDArray input) {
        if (input != null) {
            this.setInput(input.dup());
            this.applyDropOutIfNecessary(this.input, true);
        }
        Solver solver = new Solver.Builder().model(this).configure(this.conf()).listeners(this.getListeners()).build();
        this.optimizer = solver.getOptimizer();
        solver.optimize();
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.score());
    }

    @Override
    public INDArray input() {
        return this.input;
    }

    @Override
    public void validateInput() {
    }

    protected Gradient createGradient(INDArray ... gradients) {
        DefaultGradient ret = new DefaultGradient();
        if (gradients.length != this.conf.variables().size()) {
            throw new IllegalArgumentException("Unable to create gradients...not equal to number of parameters");
        }
        for (int i = 0; i < gradients.length; ++i) {
            INDArray paramI = this.getParam(this.conf.variables().get(i));
            if (!Arrays.equals(paramI.shape(), gradients[i].shape())) {
                throw new IllegalArgumentException("Gradient at index " + i + " had wrong gradient size of " + Arrays.toString(gradients[i].shape()) + " when should have been " + Arrays.toString(paramI.shape()));
            }
            ret.gradientForVariable().put(this.conf.variables().get(i), gradients[i]);
        }
        return ret;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "conf=" + this.conf + ", input=" + this.input + ", params=" + this.params + ", dropoutMask=" + this.dropoutMask + ", paramInitializer=" + this.paramInitializer + ", score=" + this.score + ", optimizer=" + this.optimizer + ", listeners=" + this.iterationListeners + '}';
    }

    @Override
    public org.deeplearning4j.nn.api.Layer transpose() {
        org.deeplearning4j.nn.api.Layer layer;
        if (!(this.conf.getLayer() instanceof FeedForwardLayer)) {
            throw new UnsupportedOperationException("unsupported layer type: " + this.conf.getLayer().getClass().getName());
        }
        INDArray W = this.getParam("W");
        INDArray b = this.getParam("b");
        try {
            Constructor<?> c = this.getClass().getConstructor(NeuralNetConfiguration.class, INDArray.class, INDArray.class, INDArray.class);
            NeuralNetConfiguration clone = this.conf.clone();
            FeedForwardLayer clonedLayerConf = (FeedForwardLayer)clone.getLayer();
            int nIn = clonedLayerConf.getNOut();
            int nOut = clonedLayerConf.getNIn();
            clonedLayerConf.setNIn(nIn);
            clonedLayerConf.setNOut(nOut);
            layer = (org.deeplearning4j.nn.api.Layer)c.newInstance(this.conf, W.transpose(), b.transpose(), this.input != null ? this.input.transpose() : null);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to construct transposed layer", e);
        }
        return layer;
    }

    @Override
    public void accumulateScore(double accum) {
        this.score += accum;
    }

    @Override
    public void setInputMiniBatchSize(int size) {
        this.inputMiniBatchSize = size;
    }

    @Override
    public int getInputMiniBatchSize() {
        return this.inputMiniBatchSize;
    }
}

