/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.util.SerializationUtils;

public class DiskBasedQueue<E>
implements Queue<E>,
Serializable {
    private File dir;
    private Queue<String> paths = new ConcurrentLinkedDeque<String>();
    private ScheduledExecutorService executorService;
    private AtomicBoolean running = new AtomicBoolean(true);
    private Queue<E> save = new ConcurrentLinkedDeque();

    public DiskBasedQueue() {
        this(".queue");
    }

    public DiskBasedQueue(String path) {
        this(new File(path));
    }

    public DiskBasedQueue(File dir) {
        this.dir = dir;
        if (!dir.exists() && dir.isDirectory()) {
            throw new IllegalArgumentException("Illegal queue: must be a directory");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.listFiles() != null && dir.listFiles().length > 1) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        dir.mkdir();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (DiskBasedQueue.this.running.get()) {
                    while (!DiskBasedQueue.this.save.isEmpty()) {
                        DiskBasedQueue.this.addAndSave(DiskBasedQueue.this.save.poll());
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        this.save.add(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.addAndSave(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        String path = this.paths.poll();
        Object ret = SerializationUtils.readObject(new File(path));
        File item = new File(path);
        item.delete();
        return (E)ret;
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    private void addAndSave(E e) {
        File path = new File(this.dir, UUID.randomUUID().toString());
        SerializationUtils.saveObject(e, path);
        this.paths.add(path.getAbsolutePath());
    }
}

