/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.stepfunctions;

import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.optimize.stepfunctions.DefaultStepFunction;
import org.deeplearning4j.optimize.stepfunctions.GradientStepFunction;
import org.deeplearning4j.optimize.stepfunctions.NegativeDefaultStepFunction;
import org.deeplearning4j.optimize.stepfunctions.NegativeGradientStepFunction;

public class StepFunctions {
    private static final DefaultStepFunction DEFAULT_STEP_FUNCTION_INSTANCE = new DefaultStepFunction();
    private static final GradientStepFunction GRADIENT_STEP_FUNCTION_INSTANCE = new GradientStepFunction();
    private static final NegativeDefaultStepFunction NEGATIVE_DEFAULT_STEP_FUNCTION_INSTANCE = new NegativeDefaultStepFunction();
    private static final NegativeGradientStepFunction NEGATIVE_GRADIENT_STEP_FUNCTION_INSTANCE = new NegativeGradientStepFunction();

    public static org.deeplearning4j.optimize.api.StepFunction createStepFunction(StepFunction stepFunction) {
        if (stepFunction == null) {
            return null;
        }
        if (stepFunction instanceof org.deeplearning4j.nn.conf.stepfunctions.DefaultStepFunction) {
            return DEFAULT_STEP_FUNCTION_INSTANCE;
        }
        if (stepFunction instanceof org.deeplearning4j.nn.conf.stepfunctions.GradientStepFunction) {
            return GRADIENT_STEP_FUNCTION_INSTANCE;
        }
        if (stepFunction instanceof org.deeplearning4j.nn.conf.stepfunctions.NegativeDefaultStepFunction) {
            return NEGATIVE_DEFAULT_STEP_FUNCTION_INSTANCE;
        }
        if (stepFunction instanceof org.deeplearning4j.nn.conf.stepfunctions.NegativeGradientStepFunction) {
            return NEGATIVE_GRADIENT_STEP_FUNCTION_INSTANCE;
        }
        throw new RuntimeException("unknown step function: " + stepFunction);
    }
}

