/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.ImageLSTM;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class ImageLSTMParamInitializer
implements ParamInitializer {
    public static final String RECURRENT_WEIGHT_KEY = "RW";
    public static final String INPUT_WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        ImageLSTM layerConf = (ImageLSTM)conf.getLayer();
        Distribution dist = Distributions.createDistribution(layerConf.getDist());
        int inputSize = layerConf.getNIn();
        int hiddenSize = 8;
        int outputSize = layerConf.getNOut();
        conf.addVariable(RECURRENT_WEIGHT_KEY);
        conf.addVariable(INPUT_WEIGHT_KEY);
        conf.addVariable(BIAS_KEY);
        params.put(RECURRENT_WEIGHT_KEY, WeightInitUtil.initWeights(inputSize + hiddenSize, 4 * hiddenSize, layerConf.getWeightInit(), dist));
        params.put(INPUT_WEIGHT_KEY, WeightInitUtil.initWeights(hiddenSize, outputSize, layerConf.getWeightInit(), dist));
        params.put(BIAS_KEY, Nd4j.zeros((int)outputSize));
        params.get(RECURRENT_WEIGHT_KEY).data().persist();
        params.get(BIAS_KEY).data().persist();
        params.get(INPUT_WEIGHT_KEY).data().persist();
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }
}

