/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.datasets.fetchers.BaseDataFetcher;
import org.deeplearning4j.util.SerializationUtils;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.util.ArrayUtil;

public class CurvesDataFetcher
extends BaseDataFetcher {
    public static final String CURVES_URL = "https://s3.amazonaws.com/dl4j-distribution/curves.ser";
    public static final String LOCAL_DIR_NAME = "curves";
    public static final String CURVES_FILE_NAME = "curves.ser";
    private DataSet data;

    public CurvesDataFetcher() throws IOException {
        this.download();
        this.totalExamples = this.data.numExamples();
    }

    private void download() throws IOException {
        File tmpDir = new File(System.getProperty("user.home"));
        File baseDir = new File(tmpDir, LOCAL_DIR_NAME);
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        File dataFile = new File(baseDir, CURVES_FILE_NAME);
        if (!dataFile.exists() || !dataFile.isFile()) {
            log.info("Downloading curves dataset...");
            FileUtils.copyURLToFile((URL)new URL(CURVES_URL), (File)dataFile);
        }
        this.data = (DataSet)SerializationUtils.readObject(dataFile);
    }

    @Override
    public boolean hasMore() {
        return super.hasMore();
    }

    @Override
    public void fetch(int numExamples) {
        if (this.cursor >= this.data.numExamples()) {
            this.cursor = this.data.numExamples();
        }
        this.curr = this.data.get(ArrayUtil.range((int)this.cursor, (int)(this.cursor + numExamples)));
        log.info("Fetched " + this.curr.numExamples());
        if (this.cursor + numExamples < this.data.numExamples()) {
            this.cursor += numExamples;
        } else if (this.cursor + numExamples > this.data.numExamples()) {
            this.cursor = this.data.numExamples() - 1;
        }
    }
}

