/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;

public class FeedForwardToRnnPreProcessor
implements InputPreProcessor {
    private static final long serialVersionUID = 7696179434618200847L;

    @Override
    public INDArray preProcess(INDArray input, Layer layer) {
        if (input.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., activations for FF layer)");
        }
        int[] shape = input.shape();
        int miniBatchSize = layer.getInputMiniBatchSize();
        INDArray reshaped = input.reshape(new int[]{miniBatchSize, shape[0] / miniBatchSize, shape[1]});
        return reshaped.permute(new int[]{0, 2, 1});
    }

    @Override
    public INDArray backprop(INDArray output, Layer layer) {
        if (output.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., epsilons from RNN layer)");
        }
        int[] shape = output.shape();
        if (shape[0] == 1) {
            return output.tensorAlongDimension(0, new int[]{1, 2});
        }
        if (shape[2] == 1) {
            return output.tensorAlongDimension(0, new int[]{1, 0});
        }
        INDArray permuted = output.permute(new int[]{0, 2, 1});
        return permuted.reshape(shape[0] * shape[2], shape[1]);
    }

    @Override
    public FeedForwardToRnnPreProcessor clone() {
        try {
            FeedForwardToRnnPreProcessor clone = (FeedForwardToRnnPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToRnnPreProcessor)) {
            return false;
        }
        FeedForwardToRnnPreProcessor other = (FeedForwardToRnnPreProcessor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToRnnPreProcessor;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "FeedForwardToRnnPreProcessor()";
    }
}

