/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;

public class GravesLSTM
extends BaseLayer<org.deeplearning4j.nn.conf.layers.GravesLSTM> {
    public GravesLSTM(NeuralNetConfiguration conf) {
        super(conf);
    }

    public GravesLSTM(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray[] activations = this.activateHelper(true);
        INDArray outputActivations = activations[0];
        INDArray memCellActivations = activations[1];
        INDArray ifogZs = activations[2];
        INDArray ifogAs = activations[3];
        INDArray inputWeights = this.getParam("W");
        INDArray recurrentWeights = this.getParam("RW");
        int hiddenLayerSize = recurrentWeights.size(0);
        int prevLayerSize = inputWeights.size(0);
        int miniBatchSize = epsilon.size(0);
        boolean is2dInput = epsilon.rank() < 3;
        int timeSeriesLength = is2dInput ? 1 : epsilon.size(2);
        INDArray wi = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
        INDArray wI = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
        INDArray wf = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
        INDArray wF = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
        INDArray wFF = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(4 * hiddenLayerSize), (int)(4 * hiddenLayerSize + 1))});
        INDArray wo = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
        INDArray wO = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
        INDArray wOO = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(4 * hiddenLayerSize + 1), (int)(4 * hiddenLayerSize + 2))});
        INDArray wg = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
        INDArray wG = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
        INDArray wGG = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(4 * hiddenLayerSize + 2), (int)(4 * hiddenLayerSize + 3))});
        INDArray biasGradients = Nd4j.zeros((int[])new int[]{miniBatchSize, 4 * hiddenLayerSize, timeSeriesLength});
        INDArray inputWeightGradients = Nd4j.zeros((int[])new int[]{prevLayerSize, 4 * hiddenLayerSize, timeSeriesLength});
        INDArray recurrentWeightGradients = Nd4j.zeros((int[])new int[]{hiddenLayerSize, 4 * hiddenLayerSize + 3, timeSeriesLength});
        INDArray epsilonNext = Nd4j.zeros((int[])new int[]{miniBatchSize, prevLayerSize, timeSeriesLength});
        INDArray nablaCellStateNext = Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize);
        for (int t = timeSeriesLength - 1; t >= 0; --t) {
            INDArray nablaCellState;
            INDArray prevMemCellActivations = t == 0 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : memCellActivations.tensorAlongDimension(t - 1, new int[]{1, 0});
            INDArray prevHiddenUnitActivation = t == 0 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : outputActivations.tensorAlongDimension(t - 1, new int[]{1, 0});
            INDArray currMemCellActivations = is2dInput ? memCellActivations : memCellActivations.tensorAlongDimension(t, new int[]{1, 0});
            INDArray deltaiNext = t == timeSeriesLength - 1 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : biasGradients.tensorAlongDimension(t + 1, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)miniBatchSize), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
            INDArray deltafNext = t == timeSeriesLength - 1 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : biasGradients.tensorAlongDimension(t + 1, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)miniBatchSize), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
            INDArray deltaoNext = t == timeSeriesLength - 1 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : biasGradients.tensorAlongDimension(t + 1, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)miniBatchSize), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
            INDArray deltagNext = t == timeSeriesLength - 1 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : biasGradients.tensorAlongDimension(t + 1, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)miniBatchSize), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
            INDArray epsilonSlice = is2dInput ? epsilon : epsilon.tensorAlongDimension(t, new int[]{1, 0});
            INDArray nablaOut = epsilonSlice.dup().addi(deltaiNext.mmul(wI.transpose())).addi(deltafNext.mmul(wF.transpose())).addi(deltaoNext.mmul(wO.transpose())).addi(deltagNext.mmul(wG.transpose()));
            INDArray sigmahOfS = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), currMemCellActivations.dup()));
            INDArray zo = is2dInput ? ifogZs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))}) : ifogZs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
            INDArray sigmaoPrimeOfZo = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("sigmoid", zo).derivative());
            INDArray deltao = nablaOut.mul(sigmahOfS).muli(sigmaoPrimeOfZo);
            INDArray sigmahPrimeOfS = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), currMemCellActivations.dup()).derivative());
            INDArray ao = is2dInput ? ifogAs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))}) : ifogAs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
            INDArray nextForgetGateAs = t == timeSeriesLength - 1 ? Nd4j.zeros((int)miniBatchSize, (int)hiddenLayerSize) : ifogAs.tensorAlongDimension(t + 1, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
            nablaCellStateNext = nablaCellState = nablaOut.mul(ao).muli(sigmahPrimeOfS).addi(nextForgetGateAs.mul(nablaCellStateNext)).addi(deltafNext.mmul(Nd4j.diag((INDArray)wFF))).addi(deltaoNext.mmul(Nd4j.diag((INDArray)wOO))).addi(deltagNext.mmul(Nd4j.diag((INDArray)wGG)));
            INDArray zf = is2dInput ? ifogZs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))}) : ifogZs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
            INDArray deltaf = nablaCellState.mul(prevMemCellActivations).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("sigmoid", zf).derivative()));
            INDArray zg = is2dInput ? ifogZs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))}) : ifogZs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
            INDArray ai = is2dInput ? ifogAs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))}) : ifogAs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
            INDArray deltag = nablaCellState.mul(ai).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("sigmoid", zg).derivative()));
            INDArray zi = is2dInput ? ifogZs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)}) : ifogZs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
            INDArray ag = is2dInput ? ifogAs.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))}) : ifogAs.tensorAlongDimension(t, new int[]{1, 0}).get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
            INDArray deltai = nablaCellState.mul(ag).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), zi).derivative()));
            INDArray prevLayerActivationSlice = is2dInput ? this.input : this.input.tensorAlongDimension(t, new int[]{1, 0});
            inputWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)}, deltai.transpose().mmul(prevLayerActivationSlice).transpose());
            inputWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))}, deltaf.transpose().mmul(prevLayerActivationSlice).transpose());
            inputWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))}, deltao.transpose().mmul(prevLayerActivationSlice).transpose());
            inputWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))}, deltag.transpose().mmul(prevLayerActivationSlice).transpose());
            if (t > 0) {
                recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)}, deltai.transpose().mmul(prevHiddenUnitActivation).transpose());
                recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))}, deltaf.transpose().mmul(prevHiddenUnitActivation).transpose());
                recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))}, deltao.transpose().mmul(prevHiddenUnitActivation).transpose());
                recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))}, deltag.transpose().mmul(prevHiddenUnitActivation).transpose());
                INDArray dLdwFF = deltaf.mul(prevMemCellActivations).sum(new int[]{0}).transpose();
                recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), new NDArrayIndex(new int[]{4 * hiddenLayerSize})}, dLdwFF);
                INDArray dLdwGG = deltag.mul(prevMemCellActivations).sum(new int[]{0}).transpose();
                recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), new NDArrayIndex(new int[]{4 * hiddenLayerSize + 2})}, dLdwGG);
            }
            INDArray dLdwOO = deltao.mul(currMemCellActivations).sum(new int[]{0}).transpose();
            recurrentWeightGradients.tensorAlongDimension(t, new int[]{1, 0}).put(new INDArrayIndex[]{NDArrayIndex.all(), new NDArrayIndex(new int[]{4 * hiddenLayerSize + 1})}, dLdwOO);
            INDArray bGradSlice = is2dInput ? biasGradients : biasGradients.tensorAlongDimension(t, new int[]{1, 0});
            bGradSlice.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)}, deltai);
            bGradSlice.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))}, deltaf);
            bGradSlice.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))}, deltao);
            bGradSlice.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))}, deltag);
            INDArray epsilonNextSlice = wi.mmul(deltai.transpose()).transpose().addi(wf.mmul(deltaf.transpose()).transpose()).addi(wo.mmul(deltao.transpose()).transpose()).addi(wg.mmul(deltag.transpose()).transpose());
            epsilonNext.tensorAlongDimension(t, new int[]{1, 0}).assign(epsilonNextSlice);
        }
        DefaultGradient retGradient = new DefaultGradient();
        retGradient.gradientForVariable().put("W", inputWeightGradients.sum(new int[]{2}));
        retGradient.gradientForVariable().put("RW", recurrentWeightGradients.sum(new int[]{2}));
        retGradient.gradientForVariable().put("b", biasGradients.sum(new int[]{2}).sum(new int[]{0}));
        return new Pair<Gradient, INDArray>(retGradient, epsilonNext);
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.activate(x, true);
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        return this.activate(x, training);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input, training);
        return this.activateHelper(training)[0];
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.activateHelper(true)[0];
    }

    @Override
    public INDArray activate(boolean training) {
        return this.activateHelper(training)[0];
    }

    @Override
    public INDArray activate() {
        return this.activateHelper()[0];
    }

    private INDArray[] activateHelper() {
        return this.activateHelper(false);
    }

    private INDArray[] activateHelper(boolean training) {
        INDArray recurrentWeights = this.getParam("RW");
        INDArray inputWeights = this.getParam("W");
        INDArray biases = this.getParam("b");
        boolean is2dInput = this.input.rank() < 3;
        int timeSeriesLength = is2dInput ? 1 : this.input.size(2);
        int hiddenLayerSize = recurrentWeights.size(0);
        int miniBatchSize = this.input.size(0);
        int nIn = inputWeights.size(0);
        if (this.conf.isUseDropConnect() && training && this.conf.getLayer().getDropOut() > 0.0) {
            inputWeights = Dropout.applyDropConnect(this, "W");
        }
        INDArray wi = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
        INDArray wI = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
        INDArray bi = biases.get(new INDArrayIndex[]{new NDArrayIndex(new int[]{0}), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)});
        INDArray wf = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
        INDArray wF = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
        INDArray wFF = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(4 * hiddenLayerSize), (int)(4 * hiddenLayerSize + 1))});
        INDArray bf = biases.get(new INDArrayIndex[]{new NDArrayIndex(new int[]{0}), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))});
        INDArray wo = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
        INDArray wO = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
        INDArray wOO = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(4 * hiddenLayerSize + 1), (int)(4 * hiddenLayerSize + 2))});
        INDArray bo = biases.get(new INDArrayIndex[]{new NDArrayIndex(new int[]{0}), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))});
        INDArray wg = inputWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
        INDArray wG = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
        INDArray wGG = recurrentWeights.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(4 * hiddenLayerSize + 2), (int)(4 * hiddenLayerSize + 3))});
        INDArray bg = biases.get(new INDArrayIndex[]{new NDArrayIndex(new int[]{0}), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))});
        INDArray outputActivations = Nd4j.zeros((int[])new int[]{miniBatchSize, hiddenLayerSize, timeSeriesLength});
        INDArray ifogZ = Nd4j.zeros((int[])new int[]{miniBatchSize, 4 * hiddenLayerSize, timeSeriesLength});
        INDArray ifogA = Nd4j.zeros((int[])new int[]{miniBatchSize, 4 * hiddenLayerSize, timeSeriesLength});
        INDArray memCellActivations = Nd4j.zeros((int[])new int[]{miniBatchSize, hiddenLayerSize, timeSeriesLength});
        for (int t = 0; t < timeSeriesLength; ++t) {
            INDArray miniBatchData = is2dInput ? this.input : this.input.tensorAlongDimension(t, new int[]{1, 0});
            INDArray prevOutputActivations = t == 0 ? Nd4j.zeros((int[])new int[]{miniBatchSize, hiddenLayerSize}) : outputActivations.tensorAlongDimension(t - 1, new int[]{1, 0});
            INDArray prevMemCellActivations = t == 0 ? Nd4j.zeros((int[])new int[]{miniBatchSize, hiddenLayerSize}) : memCellActivations.tensorAlongDimension(t - 1, new int[]{1, 0});
            INDArray inputActivations = miniBatchData.mmul(wi).addi(prevOutputActivations.mmul(wI)).addiRowVector(bi);
            INDArrayIndex[] iIndexes = new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)0, (int)hiddenLayerSize)};
            ifogZ.tensorAlongDimension(t, new int[]{1, 0}).put(iIndexes, inputActivations);
            ifogA.tensorAlongDimension(t, new int[]{1, 0}).put(iIndexes, Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), inputActivations)));
            INDArray forgetGateActivations = miniBatchData.mmul(wf).addi(prevOutputActivations.mmul(wF)).addi(prevMemCellActivations.mmul(Nd4j.diag((INDArray)wFF))).addiRowVector(bf);
            INDArrayIndex[] fIndexes = new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)hiddenLayerSize, (int)(2 * hiddenLayerSize))};
            ifogZ.tensorAlongDimension(t, new int[]{1, 0}).put(fIndexes, forgetGateActivations);
            ifogA.tensorAlongDimension(t, new int[]{1, 0}).put(fIndexes, Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("sigmoid", forgetGateActivations)));
            INDArray inputModGateActivations = miniBatchData.mmul(wg).addi(prevOutputActivations.mmul(wG)).addi(prevMemCellActivations.mmul(Nd4j.diag((INDArray)wGG))).addiRowVector(bg);
            INDArrayIndex[] gIndexes = new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(3 * hiddenLayerSize), (int)(4 * hiddenLayerSize))};
            ifogZ.tensorAlongDimension(t, new int[]{1, 0}).put(gIndexes, inputModGateActivations);
            ifogA.tensorAlongDimension(t, new int[]{1, 0}).put(gIndexes, Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("sigmoid", inputModGateActivations)));
            INDArray currentMemoryCellActivations = forgetGateActivations.mul(prevMemCellActivations).addi(inputModGateActivations.mul(inputActivations));
            currentMemoryCellActivations = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), currentMemoryCellActivations));
            INDArray outputGateActivations = miniBatchData.mmul(wo).addi(prevOutputActivations.mmul(wO)).addi(currentMemoryCellActivations.mmul(Nd4j.diag((INDArray)wOO))).addiRowVector(bo);
            INDArrayIndex[] oIndexes = new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)(2 * hiddenLayerSize), (int)(3 * hiddenLayerSize))};
            ifogZ.tensorAlongDimension(t, new int[]{1, 0}).put(oIndexes, outputGateActivations);
            ifogA.tensorAlongDimension(t, new int[]{1, 0}).put(oIndexes, Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("sigmoid", outputGateActivations)));
            INDArray currHiddenUnitActivations = outputGateActivations.mul(currentMemoryCellActivations);
            outputActivations.tensorAlongDimension(t, new int[]{1, 0}).assign(currHiddenUnitActivations);
            memCellActivations.tensorAlongDimension(t, new int[]{1, 0}).assign(currentMemoryCellActivations);
        }
        return new INDArray[]{outputActivations, memCellActivations, ifogZ, ifogA};
    }

    @Override
    public INDArray activationMean() {
        return this.activate();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double calcL2() {
        if (!this.conf.isUseRegularization() || this.conf.getL2() <= 0.0) {
            return 0.0;
        }
        double l2 = Transforms.pow((INDArray)this.getParam("RW"), (Number)2).sum(new int[]{Integer.MAX_VALUE}).getDouble(0) + Transforms.pow((INDArray)this.getParam("W"), (Number)2).sum(new int[]{Integer.MAX_VALUE}).getDouble(0);
        return 0.5 * this.conf.getL2() * l2;
    }

    @Override
    public double calcL1() {
        if (!this.conf.isUseRegularization() || this.conf.getL1() <= 0.0) {
            return 0.0;
        }
        double l1 = Transforms.abs((INDArray)this.getParam("RW")).sum(new int[]{Integer.MAX_VALUE}).getDouble(0) + Transforms.abs((INDArray)this.getParam("W")).sum(new int[]{Integer.MAX_VALUE}).getDouble(0);
        return this.conf.getL1() * l1;
    }
}

