/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RnnToFeedForwardPreProcessor
implements InputPreProcessor {
    private static final long serialVersionUID = -2334789406636365730L;
    private final int timeSeriesLength;

    @JsonCreator
    public RnnToFeedForwardPreProcessor(@JsonProperty(value="timeSeriesLength") int timeSeriesLength) {
        this.timeSeriesLength = timeSeriesLength;
    }

    @Override
    public INDArray preProcess(INDArray input) {
        if (input.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., activations for RNN layer)");
        }
        int[] shape = input.shape();
        INDArray permuted = input.permute(new int[]{0, 2, 1});
        return permuted.reshape(shape[0] * this.timeSeriesLength, shape[1]);
    }

    @Override
    public INDArray backprop(INDArray output) {
        if (output.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., epsilons from feed forward layer)");
        }
        int[] shape = output.shape();
        INDArray reshaped = output.reshape(new int[]{shape[0] / this.timeSeriesLength, this.timeSeriesLength, shape[1]});
        return reshaped.permute(new int[]{0, 2, 1});
    }

    @Override
    public RnnToFeedForwardPreProcessor clone() {
        try {
            RnnToFeedForwardPreProcessor clone = (RnnToFeedForwardPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getTimeSeriesLength() {
        return this.timeSeriesLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnnToFeedForwardPreProcessor)) {
            return false;
        }
        RnnToFeedForwardPreProcessor other = (RnnToFeedForwardPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getTimeSeriesLength() == other.getTimeSeriesLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RnnToFeedForwardPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeSeriesLength();
        return result;
    }

    public String toString() {
        return "RnnToFeedForwardPreProcessor(timeSeriesLength=" + this.getTimeSeriesLength() + ")";
    }
}

