/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.deeplearning4j.nn.conf.preprocessor.BaseInputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ReshapePreProcessor
extends BaseInputPreProcessor {
    private int[] fromShape;
    private int[] toShape;
    private boolean dynamic = true;

    @JsonCreator
    public ReshapePreProcessor(@JsonProperty(value="fromShape") int[] fromShape, @JsonProperty(value="toShape") int[] toShape, @JsonProperty(value="dynamic") boolean dynamic) {
        this.fromShape = fromShape;
        this.toShape = toShape;
        this.dynamic = dynamic;
    }

    public ReshapePreProcessor(int ... toShape) {
        this(null, toShape, true);
    }

    public ReshapePreProcessor(int[] fromShape, int[] toShape) {
        this(fromShape, toShape, true);
    }

    @Override
    public INDArray preProcess(INDArray input) {
        if (this.dynamic) {
            this.fromShape[0] = input.shape()[0];
        }
        if (input.shape().length == this.toShape.length) {
            return input;
        }
        return input.reshape(this.toShape);
    }

    @Override
    public INDArray backprop(INDArray output) {
        if (this.fromShape == null || output.shape().length == this.fromShape.length) {
            return output;
        }
        return output.reshape(this.fromShape);
    }

    @Override
    public ReshapePreProcessor clone() {
        ReshapePreProcessor clone = (ReshapePreProcessor)super.clone();
        if (clone.fromShape != null) {
            clone.fromShape = (int[])clone.fromShape.clone();
        }
        if (clone.toShape != null) {
            clone.toShape = (int[])clone.toShape.clone();
        }
        return clone;
    }

    public int[] getFromShape() {
        return this.fromShape;
    }

    public int[] getToShape() {
        return this.toShape;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setFromShape(int[] fromShape) {
        this.fromShape = fromShape;
    }

    public void setToShape(int[] toShape) {
        this.toShape = toShape;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReshapePreProcessor)) {
            return false;
        }
        ReshapePreProcessor other = (ReshapePreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getFromShape(), other.getFromShape())) {
            return false;
        }
        if (!Arrays.equals(this.getToShape(), other.getToShape())) {
            return false;
        }
        return this.isDynamic() == other.isDynamic();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReshapePreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getFromShape());
        result = result * 59 + Arrays.hashCode(this.getToShape());
        result = result * 59 + (this.isDynamic() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ReshapePreProcessor(fromShape=" + Arrays.toString(this.getFromShape()) + ", toShape=" + Arrays.toString(this.getToShape()) + ", dynamic=" + this.isDynamic() + ")";
    }
}

