/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.mnist.draw;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.datasets.DataSet;
import org.deeplearning4j.datasets.iterator.impl.MnistDataSetIterator;
import org.deeplearning4j.datasets.mnist.draw.DrawMnistGreyScale;
import org.deeplearning4j.nn.BaseNeuralNetwork;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;

public class LoadAndDraw {
    public static void main(String[] args) throws Exception {
        MnistDataSetIterator iter = new MnistDataSetIterator(60, 60000);
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(args[0]));
        BaseNeuralNetwork network = (BaseNeuralNetwork)ois.readObject();
        DataSet test = null;
        while (iter.hasNext()) {
            test = iter.next();
            DoubleMatrix reconstructed = network.reconstruct((DoubleMatrix)test.getFirst());
            for (int i = 0; i < test.numExamples(); ++i) {
                DoubleMatrix draw1 = ((DoubleMatrix)test.get(i).getFirst()).mul(255.0);
                DoubleMatrix reconstructed2 = reconstructed.getRow(i);
                DoubleMatrix draw2 = MatrixUtil.binomial(reconstructed2, 1, (RandomGenerator)new MersenneTwister(123)).mul(255.0);
                DrawMnistGreyScale d = new DrawMnistGreyScale(draw1);
                d.title = "REAL";
                d.draw();
                DrawMnistGreyScale d2 = new DrawMnistGreyScale(draw2, 100, 100);
                d2.title = "TEST";
                d2.draw();
                Thread.sleep(10000L);
                d.frame.dispose();
                d2.frame.dispose();
            }
        }
    }
}

