/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.util.List;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.datasets.DataSet;
import org.deeplearning4j.datasets.iterator.DataSetFetcher;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataFetcher
implements DataSetFetcher {
    private static final long serialVersionUID = -859588773699432365L;
    protected int cursor = 0;
    protected int numOutcomes = -1;
    protected int inputColumns = -1;
    protected DataSet curr;
    protected int totalExamples;
    protected static Logger log = LoggerFactory.getLogger(BaseDataFetcher.class);

    protected DoubleMatrix createInputMatrix(int numRows) {
        return new DoubleMatrix(numRows, this.inputColumns);
    }

    protected DoubleMatrix createOutputVector(int outcomeLabel) {
        return MatrixUtil.toOutcomeVector(outcomeLabel, this.numOutcomes);
    }

    protected DoubleMatrix createOutputMatrix(int numRows) {
        return new DoubleMatrix(numRows, this.numOutcomes);
    }

    protected void initializeCurrFromList(List<Pair<DoubleMatrix, DoubleMatrix>> examples) {
        if (examples.isEmpty()) {
            log.warn("Warning: empty dataset from the fetcher");
        }
        DoubleMatrix inputs = this.createInputMatrix(examples.size());
        DoubleMatrix labels = this.createOutputMatrix(examples.size());
        for (int i = 0; i < examples.size(); ++i) {
            inputs.putRow(i, examples.get(i).getFirst());
            labels.putRow(i, examples.get(i).getSecond());
        }
        this.curr = new DataSet(inputs, labels);
    }

    @Override
    public boolean hasMore() {
        return this.cursor < this.totalExamples;
    }

    @Override
    public DataSet next() {
        return this.curr;
    }

    @Override
    public int totalOutcomes() {
        return this.numOutcomes;
    }

    @Override
    public int inputColumns() {
        return this.inputColumns;
    }

    @Override
    public int totalExamples() {
        return this.totalExamples;
    }

    @Override
    public void reset() {
        this.cursor = 0;
    }

    @Override
    public int cursor() {
        return this.cursor;
    }
}

