/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RecursiveParamInitializer
extends DefaultParamInitializer {
    public static final String W = "w";
    public static final String U = "u";
    public static final String BIAS = "b";
    public static final String C = "c";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        int vis = conf.getnIn();
        int out = vis * 2;
        params.put(W, WeightInitUtil.initWeights(new int[]{out, vis}, conf.getWeightInit(), conf.getActivationFunction(), conf.getDist()));
        params.put(U, WeightInitUtil.initWeights(new int[]{vis, out}, conf.getWeightInit(), conf.getActivationFunction(), conf.getDist()));
        params.put(BIAS, WeightInitUtil.initWeights(new int[]{out}, conf.getWeightInit(), conf.getActivationFunction(), conf.getDist()));
        params.put(C, WeightInitUtil.initWeights(new int[]{vis}, conf.getWeightInit(), conf.getActivationFunction(), conf.getDist()));
        conf.getGradientList().add(W);
        conf.getGradientList().add(U);
        conf.getGradientList().add(BIAS);
        conf.getGradientList().add(C);
    }
}

