/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class LSTMParamInitializer
implements ParamInitializer {
    public static final String RECURRENT_WEIGHTS = "recurrentweights";
    public static final String DECODER_BIAS = "decoderbias";
    public static final String DECODER_WEIGHTS = "decoderweights";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        int inputSize = conf.getnIn();
        int hiddenSize = conf.getnIn();
        int outputSize = conf.getnOut();
        conf.getGradientList().add(RECURRENT_WEIGHTS);
        conf.getGradientList().add(DECODER_WEIGHTS);
        conf.getGradientList().add(DECODER_BIAS);
        params.put(RECURRENT_WEIGHTS, WeightInitUtil.initWeights(inputSize + hiddenSize + 1, 4 * hiddenSize, conf.getWeightInit(), conf.getActivationFunction(), conf.getDist()));
        params.put(DECODER_WEIGHTS, WeightInitUtil.initWeights(hiddenSize, outputSize, conf.getWeightInit(), conf.getActivationFunction(), conf.getDist()));
        params.put(DECODER_BIAS, Nd4j.zeros((int)outputSize));
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }
}

