/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class DefaultParamInitializer
implements ParamInitializer {
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        params.put(WEIGHT_KEY, this.createWeightMatrix(conf));
        params.put(BIAS_KEY, this.createBias(conf));
        conf.getGradientList().add(WEIGHT_KEY);
        conf.getGradientList().add(BIAS_KEY);
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }

    protected INDArray createBias(NeuralNetConfiguration conf) {
        return Nd4j.zeros((int)conf.getnOut());
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf) {
        INDArray W = WeightInitUtil.initWeights(conf.getnIn(), conf.getnOut(), conf.getWeightInit(), conf.getActivationFunction(), conf.getDist());
        return W;
    }
}

