/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.featuredetectors.autoencoder;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.deeplearning4j.util.MathUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class AutoEncoder
extends BasePretrainNetwork {
    private static final long serialVersionUID = -6445530486350763837L;

    public AutoEncoder(NeuralNetConfiguration conf) {
        super(conf);
    }

    public AutoEncoder(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    public INDArray getCorruptedInput(INDArray x, double corruptionLevel) {
        INDArray corrupted = Nd4j.zeros((int)x.rows(), (int)x.columns());
        for (int i = 0; i < x.rows(); ++i) {
            for (int j = 0; j < x.columns(); ++j) {
                corrupted.put(i, j, (Number)MathUtils.binomial(this.conf.getRng(), 1, 1.0 - corruptionLevel));
            }
        }
        corrupted.muli(x);
        return corrupted;
    }

    @Override
    public Pair<INDArray, INDArray> sampleHiddenGivenVisible(INDArray v) {
        INDArray ret = this.encode(v);
        return new Pair<INDArray, INDArray>(ret, ret);
    }

    @Override
    public Pair<INDArray, INDArray> sampleVisibleGivenHidden(INDArray h) {
        INDArray ret = this.decode(h);
        return new Pair<INDArray, INDArray>(ret, ret);
    }

    public INDArray encode(INDArray x) {
        INDArray preAct;
        INDArray W = this.getParam("W");
        INDArray hBias = this.getParam("b");
        if (this.conf.isConcatBiases()) {
            INDArray concat = Nd4j.hstack((INDArray[])new INDArray[]{W, hBias.transpose()});
            preAct = x.mmul(concat);
        } else {
            preAct = x.mmul(W).addiRowVector(hBias);
        }
        INDArray ret = (INDArray)this.conf.getActivationFunction().apply((Object)preAct);
        return ret;
    }

    public INDArray decode(INDArray y) {
        INDArray W = this.getParam("W");
        INDArray vBias = this.getParam("vb");
        if (this.conf.isConcatBiases()) {
            INDArray preAct = y.mmul(W.transpose());
            preAct = Nd4j.hstack((INDArray[])new INDArray[]{preAct, Nd4j.ones((int)preAct.rows(), (int)1)});
            return (INDArray)this.conf.getActivationFunction().apply((Object)preAct);
        }
        INDArray preAct = y.mmul(W.transpose());
        preAct.addiRowVector(vBias);
        return (INDArray)this.conf.getActivationFunction().apply((Object)preAct);
    }

    @Override
    public INDArray transform(INDArray x) {
        INDArray y = this.encode(x);
        return this.decode(y);
    }

    @Override
    public Gradient getGradient() {
        INDArray W = this.getParam("W");
        double corruptionLevel = this.conf.getCorruptionLevel();
        INDArray corruptedX = corruptionLevel > 0.0 ? this.getCorruptedInput(this.input, corruptionLevel) : this.input;
        INDArray y = this.encode(corruptedX);
        INDArray z = this.decode(y);
        INDArray visibleLoss = this.input.sub(z);
        INDArray hiddenLoss = this.conf.getSparsity() == 0.0 ? visibleLoss.mmul(W).muli(y).muli(y.rsub((Number)1)) : visibleLoss.mmul(W).muli(y).muli(y.addi((Number)(-this.conf.getSparsity())));
        INDArray wGradient = corruptedX.transpose().mmul(hiddenLoss).addi(visibleLoss.transpose().mmul(y));
        INDArray hBiasGradient = hiddenLoss.mean(0);
        INDArray vBiasGradient = visibleLoss.mean(0);
        Gradient gradient = this.createGradient(wGradient, vBiasGradient, hBiasGradient);
        return gradient;
    }
}

