/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.berkeley.Counter;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.util.FingerPrintKeyer;
import org.deeplearning4j.util.MathUtils;
import org.deeplearning4j.util.StringCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringGrid
extends ArrayList<List<String>> {
    private static final long serialVersionUID = 4702427632483221813L;
    private String sep;
    private int numColumns = -1;
    private static final Logger log = LoggerFactory.getLogger(StringGrid.class);
    public static final String NONE = "NONE";

    public StringGrid(StringGrid grid) {
        this.sep = grid.sep;
        this.numColumns = grid.numColumns;
        this.addAll(grid);
        this.fillOut();
    }

    public StringGrid(String sep, int numColumns) {
        this(sep, new ArrayList<String>());
        this.numColumns = numColumns;
        this.fillOut();
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    private void fillOut() {
        for (List list : this) {
            if (list.size() >= this.numColumns) continue;
            int diff = this.numColumns - list.size();
            for (int i = 0; i < diff; ++i) {
                list.add(NONE);
            }
        }
    }

    public static StringGrid fromFile(String file, String sep) throws IOException {
        List read = FileUtils.readLines((File)new File(file));
        if (read.isEmpty()) {
            throw new IllegalStateException("Nothing to read; file is empty");
        }
        return new StringGrid(sep, read);
    }

    public static StringGrid fromInput(InputStream from, String sep) throws IOException {
        List read = IOUtils.readLines((InputStream)from);
        if (read.isEmpty()) {
            throw new IllegalStateException("Nothing to read; file is empty");
        }
        return new StringGrid(sep, read);
    }

    public StringGrid(String sep, Collection<String> data) {
        this.sep = sep;
        ArrayList<String> list = new ArrayList<String>(data);
        for (int i = 0; i < list.size(); ++i) {
            String line = ((String)list.get(i)).trim();
            if (line.indexOf("\"") > 0) {
                Counter<Character> counter = new Counter<Character>();
                for (int j = 0; j < line.length(); ++j) {
                    counter.incrementCount(Character.valueOf(line.charAt(j)), 1.0);
                }
                if (counter.getCount(Character.valueOf('\"')) > 1.0) {
                    String[] split = StringUtils.splitOnCharWithQuoting(line, sep.charAt(0), '\"', '\\');
                    this.add(new ArrayList<String>(Arrays.asList(split)));
                    continue;
                }
                ArrayList<String> row = new ArrayList<String>(Arrays.asList(StringUtils.splitOnCharWithQuoting(line, sep.charAt(0), '\"', '\\')));
                if (this.numColumns < 0) {
                    this.numColumns = row.size();
                    continue;
                }
                if (row.size() != this.numColumns) {
                    log.warn("Row " + i + " had invalid number of columns  line was " + line);
                    continue;
                }
                this.add(row);
                continue;
            }
            ArrayList<String> row = new ArrayList<String>(Arrays.asList(StringUtils.splitOnCharWithQuoting(line, sep.charAt(0), '\"', '\\')));
            if (this.numColumns < 0) {
                this.numColumns = row.size();
                continue;
            }
            if (row.size() != this.numColumns) {
                log.warn("Could not add " + line);
                continue;
            }
            this.add(row);
        }
        this.fillOut();
    }

    public void removeRowsWithEmptyColumn(int column) {
        ArrayList<List> remove = new ArrayList<List>();
        for (List list : this) {
            if (!((String)list.get(column)).equals(NONE)) continue;
            remove.add(list);
        }
        this.removeAll(remove);
    }

    public void head(int num) {
        if (num >= this.size()) {
            num = this.size();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            builder.append(this.get(i) + "\n");
        }
        log.info(builder.toString());
    }

    public void removeColumns(Integer ... columns) {
        if (columns.length < 1) {
            throw new IllegalArgumentException("Columns must contain at least one column");
        }
        List<Integer> removeOrder = Arrays.asList(columns);
        Collections.sort(removeOrder);
        for (List list : this) {
            ArrayList remove = new ArrayList();
            for (int i = 0; i < columns.length; ++i) {
                remove.add(list.get(columns[i]));
            }
            list.removeAll(remove);
        }
    }

    public void removeRowsWithEmptyColumn(int column, String missingValue) {
        ArrayList<List> remove = new ArrayList<List>();
        for (List list : this) {
            if (!((String)list.get(column)).equals(missingValue)) continue;
            remove.add(list);
        }
        this.removeAll(remove);
    }

    public List<List<String>> getRowsWithColumnValues(Collection<String> values, int column) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        for (List val : this) {
            if (!values.contains(val.get(column))) continue;
            ret.add(val);
        }
        return ret;
    }

    public void sortColumnsByWordLikelihoodIncluded(final int column) {
        final Counter<String> counter = new Counter<String>();
        List<String> col = this.getColumn(column);
        for (String string : col) {
            StringTokenizer tokenizer = new StringTokenizer(string);
            while (tokenizer.hasMoreTokens()) {
                counter.incrementCount(tokenizer.nextToken(), 1.0);
            }
        }
        if (counter.totalCount() <= 0.0) {
            log.warn("Unable to calculate probability; nothing found");
            return;
        }
        counter.incrementAll(counter.keySet(), 1.0);
        HashSet<String> remove = new HashSet<String>();
        for (String key : counter.keySet()) {
            if (key.length() >= 2 && !key.matches("[a-z]+")) continue;
            remove.add(key);
        }
        for (String key : remove) {
            counter.removeKey(key);
        }
        counter.pruneKeysBelowThreshold(4.0);
        final double d = counter.totalCount();
        Collections.sort(this, new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                double c1 = StringGrid.this.sumOverTokens(counter, o1.get(column), d);
                double c2 = StringGrid.this.sumOverTokens(counter, o2.get(column), d);
                return Double.compare(c1, c2);
            }
        });
    }

    private double sumOverTokens(Counter<String> counter, String column, double totalCount) {
        StringTokenizer tokenizer = new StringTokenizer(column);
        double count = 0.0;
        while (tokenizer.hasMoreTokens()) {
            count += Math.log(counter.getCount(column) / totalCount);
        }
        return count;
    }

    public StringCluster clusterColumn(int column) {
        return new StringCluster(this.getColumn(column));
    }

    public void dedupeByClusterAll() {
        for (int i = 0; i < this.size(); ++i) {
            this.dedupeByCluster(i);
        }
    }

    public void dedupeByCluster(int column) {
        StringCluster cluster = this.clusterColumn(column);
        System.out.println(cluster.get("family mcdonalds restaurant"));
        System.out.println(cluster.get("family mcdonalds restaurants"));
        List<Map<String, Integer>> list2 = cluster.getClusters();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i).size() <= 1) continue;
            System.out.println(list2.get(i));
        }
        FingerPrintKeyer keyer = new FingerPrintKeyer();
        HashSet<Integer> alreadyDeDupped = new HashSet<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            List<Integer> list;
            String key = keyer.key((String)((List)this.get(i)).get(column), new Object[0]);
            Map map = (Map)cluster.get(key);
            if (map == null || map.size() <= 1 || (list = this.filterRowsByColumn(column, map.keySet())).size() <= 1) continue;
            this.modifyRows(alreadyDeDupped, column, list, map);
        }
    }

    private void modifyRows(Set<Integer> alreadyDeDupped, Integer column, List<Integer> rows, Map<String, Integer> cluster) {
        String chosenKey = null;
        Integer max = null;
        for (String key : cluster.keySet()) {
            StringTokenizer val = new StringTokenizer(key);
            ArrayList<Object> list = new ArrayList<Object>();
            boolean allLower = true;
            while (val.hasMoreTokens()) {
                String token = val.nextToken();
                if (token.length() >= 3 && token.matches("[A-Z]+")) continue;
                list.add(token);
            }
            for (String string : list) {
                allLower = allLower && string.matches("[a-z]+");
            }
            if (allLower || ((String)list.get(list.size() - 1)).toLowerCase().equals("the")) continue;
            if (max == null) {
                max = cluster.get(key);
                chosenKey = key;
                continue;
            }
            if (allLower || cluster.get(key) <= max) continue;
            max = cluster.get(key);
            chosenKey = key;
        }
        if (chosenKey == null) {
            String max2 = this.maximalValue(cluster);
            StringTokenizer val = new StringTokenizer(max2);
            ArrayList<String> list = new ArrayList<String>();
            while (val.hasMoreTokens()) {
                String token = val.nextToken();
                if (token.length() >= 3 && token.matches("[A-Z]+")) {
                    token = token.charAt(0) + token.substring(1).toLowerCase();
                }
                list.add(token);
            }
            boolean allLower = true;
            for (String s : list) {
                allLower = allLower && s.matches("[a-z]+");
            }
            if (((String)list.get(list.size() - 1)).toLowerCase().equals("the")) {
                max2 = max2.replaceAll("^[Tt]he", "");
            }
            if (allLower) {
                max2 = StringUtils.capitalize(max2);
            }
            chosenKey = max2;
        }
        for (Integer i2 : rows) {
            if (alreadyDeDupped.contains(i2)) continue;
            this.disambiguateRow(i2, column, chosenKey);
        }
    }

    private String maximalValue(Map<String, Integer> map) {
        Counter<String> counter = new Counter<String>();
        for (String s : map.keySet()) {
            counter.incrementCount(s, map.get(s).intValue());
        }
        return (String)counter.argMax();
    }

    private void disambiguateRow(Integer row, Integer column, String chosenValue) {
        System.out.println("SETTING " + row + " column " + column + " to " + chosenValue);
        ((List)this.get(row)).set(column, chosenValue);
    }

    public List<Integer> filterRowsByColumn(int column, Collection<String> values) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (!values.contains(((List)this.get(i)).get(column))) continue;
            list.add(i);
        }
        return list;
    }

    public void sortBy(final int column) {
        Collections.sort(this, new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                return o1.get(column).compareTo(o2.get(column));
            }
        });
    }

    public List<String> toLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (List list : this) {
            StringBuffer sb = new StringBuffer();
            for (String s : list) {
                sb.append(s.replaceAll(this.sep, " "));
                sb.append(this.sep);
            }
            lines.add(sb.toString().substring(0, sb.lastIndexOf(this.sep)));
        }
        return lines;
    }

    public void swap(int column1, int column2) {
        List<String> col1 = this.getColumn(column1);
        List<String> col2 = this.getColumn(column2);
        for (int i = 0; i < this.size(); ++i) {
            ((List)this.get(i)).set(column1, col2.get(i));
            ((List)this.get(i)).set(column2, col1.get(i));
        }
    }

    public void merge(int column1, int column2) {
        this.checkInvalidColumn(column1);
        this.checkInvalidColumn(column2);
        if (column1 != column2) {
            for (List list : this) {
                StringBuffer sb = new StringBuffer();
                sb.append((String)list.get(column1));
                sb.append((String)list.get(column2));
                list.set(Math.min(column1, column2), sb.toString().replaceAll("\"", "").replace(this.sep, " "));
                list.remove(Math.max(column1, column2));
            }
        }
        --this.numColumns;
    }

    public StringGrid getAllWithSimilarity(double threshold, int firstColumn, int secondColumn) {
        for (int column : new int[]{firstColumn, secondColumn}) {
            this.checkInvalidColumn(column);
        }
        StringGrid grid = new StringGrid(this.sep, this.numColumns);
        for (List list : this) {
            String[] stringArray = new String[]{(String)list.get(firstColumn), (String)list.get(secondColumn)};
            double sim = MathUtils.stringSimilarity(stringArray);
            if (!(sim >= threshold)) continue;
            grid.addRow(list);
        }
        return grid;
    }

    public void writeLinesTo(String path) throws IOException {
        FileUtils.writeLines((File)new File(path), this.toLines());
    }

    public void fillDown(String value, int column) {
        this.checkInvalidColumn(column);
        for (List list : this) {
            list.set(column, value);
        }
    }

    public StringGrid select(int column, String value) {
        StringGrid grid = new StringGrid(this.sep, this.numColumns);
        for (int i = 0; i < this.size(); ++i) {
            List row = (List)this.get(i);
            if (!((String)row.get(column)).equals(value)) continue;
            grid.addRow(row);
        }
        return grid;
    }

    public void split(int column, String sepBy) {
        List<String> col = this.getColumn(column);
        int validate = -1;
        HashSet<String> remove = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            String s = col.get(i);
            String[] split2 = StringUtils.splitOnCharWithQuoting(s, sepBy.charAt(0), '\"', '\\');
            if (validate < 0) {
                validate = split2.length;
                continue;
            }
            if (validate == split2.length) continue;
            log.warn("Row " + this.get(i) + " will be invalid after split; removing");
            remove.add(s);
        }
        for (String s : remove) {
            StringGrid grid = this.select(column, s);
            this.removeAll(grid);
        }
        HashMap replace = new HashMap();
        for (int i = 0; i < this.size(); ++i) {
            List list = (List)this.get(i);
            ArrayList<String> newList = new ArrayList<String>();
            String split = (String)list.get(column);
            String[] split2 = StringUtils.splitOnCharWithQuoting(split, sepBy.charAt(0), '\"', '\\');
            for (int j = 0; j < list.size(); ++j) {
                if (j == column) {
                    for (String s : split2) {
                        newList.add(s);
                    }
                    continue;
                }
                newList.add((String)list.get(j));
            }
            replace.put(i, newList);
        }
        for (Integer i : replace.keySet()) {
            this.set(i, replace.get(i));
        }
    }

    public void filterBySimilarity(double threshold, int firstColumn, int secondColumn) {
        for (int column : new int[]{firstColumn, secondColumn}) {
            this.checkInvalidColumn(column);
        }
        ArrayList<List> remove = new ArrayList<List>();
        for (List list : this) {
            String[] stringArray = new String[]{(String)list.get(firstColumn), (String)list.get(secondColumn)};
            double sim = MathUtils.stringSimilarity(stringArray);
            if (!(sim < threshold)) continue;
            remove.add(list);
        }
        this.removeAll(remove);
    }

    public void prependToEach(String prepend, int toColumn) {
        for (List row : this) {
            String currVal = (String)row.get(toColumn);
            row.set(toColumn, prepend + currVal);
        }
    }

    public void appendToEach(String append, int toColumn) {
        for (List row : this) {
            String currVal = (String)row.get(toColumn);
            row.set(toColumn, currVal + append);
        }
    }

    public void addColumn(List<String> column) {
        if (column.size() != this.size()) {
            throw new IllegalArgumentException("Unable to add column; not enough rows");
        }
        for (int i = 0; i < this.size(); ++i) {
            ((List)this.get(i)).add(column.get(i));
        }
    }

    public void combineColumns(int templateColumn, Integer[] paramColumns) {
        for (List list : this) {
            ArrayList format = new ArrayList();
            Integer[] integerArray = paramColumns;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int j = integerArray[i];
                format.add(list.get(j));
            }
            list.set(templateColumn, String.format((String)list.get(templateColumn), format.toArray(new String[0])));
            list.removeAll(format);
        }
    }

    public void combineColumns(int templateColumn, int[] paramColumns) {
        for (List list : this) {
            ArrayList format = new ArrayList();
            for (int j : paramColumns) {
                format.add(list.get(j));
            }
            list.set(templateColumn, String.format((String)list.get(templateColumn), format.toArray(new String[0])));
            list.removeAll(format);
        }
    }

    public void addRow(List<String> row) {
        if (row.isEmpty()) {
            log.warn("Unable to add empty row");
        } else if (!this.isEmpty() && row.size() != ((List)this.get(0)).size()) {
            log.warn("Unable to add row; not the same number of columns");
        } else {
            this.add(row);
        }
    }

    public Map<String, List<List<String>>> mapByPrimaryKey(int columnKey) {
        HashMap<String, List<List<String>>> map = new HashMap<String, List<List<String>>>();
        for (List line : this) {
            String val = (String)line.get(columnKey);
            ArrayList<ArrayList<String>> get = (ArrayList<ArrayList<String>>)map.get(val);
            if (get == null) {
                get = new ArrayList<ArrayList<String>>();
                map.put(val, get);
            }
            get.add(new ArrayList<String>(Arrays.asList(this.sep)));
        }
        return map;
    }

    public List<String> getRow(int row) {
        this.checkInvalidRow(row);
        return new ArrayList<String>((Collection)this.get(row));
    }

    public List<String> getColumn(int column) {
        this.checkInvalidColumn(column);
        ArrayList<String> ret = new ArrayList<String>();
        for (List list : this) {
            ret.add((String)list.get(column));
        }
        return ret;
    }

    private void checkInvalidRow(int row) {
        if (row < 0 || row >= this.size()) {
            throw new IllegalArgumentException("Row does not exist");
        }
    }

    private void checkInvalidColumn(int column) {
        if (column < 0 || column >= this.numColumns) {
            throw new IllegalArgumentException("Invalid column " + column);
        }
    }

    public StringGrid getRowsWithDuplicateValuesInColumn(int column) {
        this.checkInvalidColumn(column);
        StringGrid grid = new StringGrid(this.sep, this.numColumns);
        List<String> columns = this.getColumn(column);
        Counter<String> counter = new Counter<String>();
        for (String val : columns) {
            counter.incrementCount(val, 1.0);
        }
        counter.pruneKeysBelowThreshold(2.0);
        Set keys = counter.keySet();
        for (List row : this) {
            for (String key : keys) {
                if (!((String)row.get(column)).equals(key)) continue;
                grid.addRow(row);
            }
        }
        return grid;
    }

    public StringGrid getRowWithOnlyOneOccurrence(int column) {
        this.checkInvalidColumn(column);
        StringGrid grid = new StringGrid(this.sep, this.numColumns);
        List<String> columns = this.getColumn(column);
        Counter<String> counter = new Counter<String>();
        for (String val : columns) {
            counter.incrementCount(val, 1.0);
        }
        HashSet keys = new HashSet(counter.keySet());
        for (String key : keys) {
            if (!(counter.getCount(key) > 1.0)) continue;
            counter.removeKey(key);
        }
        for (List row : this) {
            for (String key : keys) {
                if (!((String)row.get(column)).equals(key)) continue;
                grid.addRow(row);
            }
        }
        return grid;
    }

    public StringGrid getUniqueRows() {
        StringGrid ret = new StringGrid(this);
        ret.stripDuplicateRows();
        return ret;
    }

    public void stripDuplicateRows() {
        HashSet<List<String>> set = new HashSet<List<String>>(this);
        this.clear();
        this.addAll(set);
    }
}

