/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.iterationlistener;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.plot.NeuralNetPlotter;

public class NeuralNetPlotterIterationListener
implements IterationListener {
    private int iterations = 10;
    private NeuralNetPlotter plotter = new NeuralNetPlotter();
    private int patchesPerRow = 100;
    private boolean renderFirst = false;

    public NeuralNetPlotterIterationListener(int iterations, NeuralNetPlotter plotter, int patchesPerRow) {
        this(iterations, plotter, patchesPerRow, false);
    }

    public NeuralNetPlotterIterationListener(int iterations, int patchesPerRow) {
        this(iterations, patchesPerRow, false);
    }

    public NeuralNetPlotterIterationListener(int iterations, NeuralNetPlotter plotter, int patchesPerRow, boolean renderFirst) {
        this.iterations = iterations;
        this.plotter = plotter;
        this.patchesPerRow = patchesPerRow;
        this.renderFirst = renderFirst;
    }

    public NeuralNetPlotterIterationListener(int iterations, int patchesPerRow, boolean renderFirst) {
        this.iterations = iterations;
        this.patchesPerRow = patchesPerRow;
        this.renderFirst = renderFirst;
    }

    public NeuralNetPlotterIterationListener(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (iteration == 0 && this.renderFirst || iteration > 0 && iteration % this.iterations == 0) {
            Layer layer = (Layer)model;
            this.plotter.plotNetworkGradient(layer, layer.gradient(), this.patchesPerRow);
        }
    }
}

