/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import java.util.Collection;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TerminationCondition;
import org.deeplearning4j.optimize.solvers.BaseOptimizer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class IterationGradientDescent
extends BaseOptimizer {
    public IterationGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Model model) {
        super(conf, stepFunction, iterationListeners, model);
    }

    public IterationGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Collection<TerminationCondition> terminationConditions, Model model) {
        super(conf, stepFunction, iterationListeners, terminationConditions, model);
    }

    @Override
    public boolean optimize() {
        for (int i = 0; i < this.conf.getNumIterations(); ++i) {
            Pair<Gradient, Double> score = this.gradientAndScore();
            this.model.update(score.getFirst());
            for (IterationListener listener : this.iterationListeners) {
                listener.iterationDone(this.model, i);
            }
        }
        return true;
    }

    @Override
    public void preProcessLine(INDArray line) {
        if (this.conf.isConstrainGradientToUnitNorm()) {
            line.divi(line.norm2(Integer.MAX_VALUE));
        }
    }

    @Override
    public void postStep() {
    }
}

