/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.multilayer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Classifier;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.OutputLayer;
import org.deeplearning4j.nn.layers.factory.LayerFactories;
import org.deeplearning4j.optimize.GradientAdjustment;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.MultiLayerUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.FeatureUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLayerNetwork
implements Serializable,
Classifier {
    private static final Logger log = LoggerFactory.getLogger(MultiLayerNetwork.class);
    private static final long serialVersionUID = -5029161847383716484L;
    protected Layer[] layers;
    protected INDArray input;
    protected INDArray labels;
    protected boolean initCalled = false;
    private List<IterationListener> listeners = new ArrayList<IterationListener>();
    protected NeuralNetConfiguration defaultConfiguration;
    protected MultiLayerConfiguration layerWiseConfigurations;
    protected INDArray mask;

    public MultiLayerNetwork(MultiLayerConfiguration conf) {
        this.layerWiseConfigurations = conf;
        this.defaultConfiguration = conf.getConf(0);
    }

    public MultiLayerNetwork(String conf, INDArray params) {
        this(MultiLayerConfiguration.fromJson(conf));
        this.init();
        this.setParameters(params);
    }

    public MultiLayerNetwork(MultiLayerConfiguration conf, INDArray params) {
        this(conf);
        this.init();
        this.setParameters(params);
    }

    protected void intializeConfigurations() {
        if (this.layerWiseConfigurations == null) {
            this.layerWiseConfigurations = new MultiLayerConfiguration.Builder().build();
        }
        if (this.layers == null) {
            this.layers = new Layer[this.getnLayers()];
        }
        if (this.defaultConfiguration == null) {
            this.defaultConfiguration = new NeuralNetConfiguration.Builder().build();
        }
        if (this.layerWiseConfigurations == null || this.layerWiseConfigurations.getConfs().isEmpty()) {
            for (int i = 0; i < this.layerWiseConfigurations.getHiddenLayerSizes().length + 1; ++i) {
                this.layerWiseConfigurations.getConfs().add(this.defaultConfiguration.clone());
            }
        }
    }

    public void pretrain(DataSetIterator iter) {
        if (!this.layerWiseConfigurations.isPretrain()) {
            return;
        }
        for (int i = 0; i < this.getnLayers(); ++i) {
            DataSet next;
            if (i == 0) {
                while (iter.hasNext()) {
                    next = (DataSet)iter.next();
                    this.input = next.getFeatureMatrix();
                    if (this.getInput() == null || this.getLayers() == null) {
                        this.setInput(this.input);
                        this.initializeLayers(this.input);
                    } else {
                        this.setInput(this.input);
                    }
                    this.getLayers()[i].fit(next.getFeatureMatrix());
                    log.info("Training on layer " + (i + 1) + " with " + this.input.slices() + " examples");
                }
                iter.reset();
                continue;
            }
            while (iter.hasNext()) {
                next = (DataSet)iter.next();
                INDArray layerInput = next.getFeatureMatrix();
                for (int j = 1; j <= i; ++j) {
                    layerInput = this.activationFromPrevLayer(j - 1, layerInput);
                }
                log.info("Training on layer " + (i + 1) + " with " + layerInput.slices() + " examples");
                this.getLayers()[i].fit(layerInput);
            }
            iter.reset();
        }
    }

    public void pretrain(INDArray input) {
        if (!this.layerWiseConfigurations.isPretrain()) {
            return;
        }
        INDArray layerInput = null;
        for (int i = 0; i < this.getnLayers() - 1; ++i) {
            layerInput = i == 0 ? input : this.activationFromPrevLayer(i - 1, layerInput);
            log.info("Training on layer " + (i + 1) + " with " + layerInput.slices() + " examples");
            this.getLayers()[i].fit(layerInput);
        }
    }

    @Override
    public int batchSize() {
        return this.input.slices();
    }

    @Override
    public NeuralNetConfiguration conf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray input() {
        return this.input;
    }

    @Override
    public void validateInput() {
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray getParam(String param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, INDArray> paramTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParam(String key, INDArray val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray transform(INDArray data) {
        return this.output(data);
    }

    public MultiLayerConfiguration getLayerWiseConfigurations() {
        return this.layerWiseConfigurations;
    }

    public void setLayerWiseConfigurations(MultiLayerConfiguration layerWiseConfigurations) {
        this.layerWiseConfigurations = layerWiseConfigurations;
    }

    public void initializeLayers(INDArray input) {
        if (input == null) {
            throw new IllegalArgumentException("Unable to initialize neuralNets with empty input");
        }
        int[] hiddenLayerSizes = this.getLayerWiseConfigurations().getHiddenLayerSizes();
        if (input.shape().length == 2) {
            for (int i = 0; i < hiddenLayerSizes.length; ++i) {
                if (hiddenLayerSizes[i] >= 1) continue;
                throw new IllegalArgumentException("All hidden layer sizes must be >= 1");
            }
        }
        this.input = input;
        if (!this.initCalled) {
            this.init();
        }
    }

    public void init() {
        if (this.layerWiseConfigurations == null || this.layers == null) {
            this.intializeConfigurations();
        }
        INDArray layerInput = this.input();
        int inputSize = 0;
        if (this.getnLayers() < 1) {
            throw new IllegalStateException("Unable to createComplex network neuralNets; number specified is less than 1");
        }
        int[] hiddenLayerSizes = this.layerWiseConfigurations.getHiddenLayerSizes();
        int numHiddenLayersSizesUsed = 1;
        if (this.layers == null || this.layers[0] == null) {
            Layer.Type type;
            if (this.layers == null) {
                this.layers = new Layer[this.getnLayers()];
            }
            for (int i = 0; i < this.getnLayers(); ++i) {
                if (i == 0) {
                    inputSize = this.layerWiseConfigurations.getConf(0).getnIn();
                    if (this.input == null) {
                        layerInput = this.input = Nd4j.ones((int)inputSize);
                    }
                } else if (LayerFactories.typeForFactory(this.layerWiseConfigurations.getConf(i)) == Layer.Type.FEED_FORWARD) {
                    inputSize = hiddenLayerSizes[numHiddenLayersSizesUsed - 1];
                }
                if (i == 0) {
                    type = LayerFactories.typeForFactory(this.layerWiseConfigurations.getConf(i));
                    if (type == Layer.Type.FEED_FORWARD) {
                        this.layerWiseConfigurations.getConf(i).setnIn(inputSize);
                        this.layerWiseConfigurations.getConf(i).setnOut(hiddenLayerSizes[i]);
                    }
                    this.layerWiseConfigurations.getConf(i).setnIn(inputSize);
                    this.layerWiseConfigurations.getConf(i).setnOut(hiddenLayerSizes[i]);
                    this.layers[i] = LayerFactories.getFactory(this.layerWiseConfigurations.getConf(i)).create(this.layerWiseConfigurations.getConf(i));
                    continue;
                }
                if (i >= this.getLayers().length - 1) continue;
                if (this.input != null) {
                    layerInput = this.activationFromPrevLayer(i - 1, layerInput);
                }
                if ((type = LayerFactories.typeForFactory(this.layerWiseConfigurations.getConf(i))) == Layer.Type.FEED_FORWARD) {
                    ++numHiddenLayersSizesUsed;
                    this.layerWiseConfigurations.getConf(i).setnIn(layerInput.columns());
                    this.layerWiseConfigurations.getConf(i).setnOut(hiddenLayerSizes[i]);
                }
                this.layers[i] = LayerFactories.getFactory(this.layerWiseConfigurations.getConf(i)).create(this.layerWiseConfigurations.getConf(i), this.listeners);
            }
            NeuralNetConfiguration last = this.layerWiseConfigurations.getConf(this.layerWiseConfigurations.getConfs().size() - 1);
            type = LayerFactories.typeForFactory(this.layerWiseConfigurations.getConf(this.layerWiseConfigurations.getConfs().size() - 1));
            if (type == Layer.Type.FEED_FORWARD) {
                last.setnIn(hiddenLayerSizes[hiddenLayerSizes.length - 1]);
            }
            this.layers[this.layers.length - 1] = LayerFactories.getFactory(last).create(last);
            this.initCalled = true;
            this.initMask();
        }
    }

    public INDArray activate() {
        return this.getLayers()[this.getLayers().length - 1].activate();
    }

    public INDArray activate(int layer) {
        return this.getLayers()[layer].activate();
    }

    public INDArray activate(int layer, INDArray input) {
        return this.getLayers()[layer].activate(input);
    }

    public void initialize(DataSet data) {
        this.setInput(data.getFeatureMatrix());
        this.feedForward(this.getInput());
        this.labels = data.getLabels();
        if (this.getOutputLayer() instanceof OutputLayer) {
            OutputLayer o = (OutputLayer)this.getOutputLayer();
            o.setLabels(this.labels);
        }
    }

    public INDArray activationFromPrevLayer(int curr, INDArray input) {
        if (this.getLayerWiseConfigurations().getInputPreProcess(curr) != null) {
            input = this.getLayerWiseConfigurations().getInputPreProcess(curr).preProcess(input);
        }
        INDArray ret = this.layers[curr].activate(input);
        if (this.getLayerWiseConfigurations().getProcessors() != null && this.getLayerWiseConfigurations().getPreProcessor(curr) != null) {
            ret = this.getLayerWiseConfigurations().getPreProcessor(curr).preProcess(ret);
            return ret;
        }
        return ret;
    }

    public List<INDArray> feedForward() {
        INDArray currInput = this.input;
        ArrayList<INDArray> activations = new ArrayList<INDArray>();
        activations.add(currInput);
        for (int i = 0; i < this.layers.length; ++i) {
            currInput = this.activationFromPrevLayer(i, currInput);
            this.applyDropConnectIfNecessary(currInput);
            activations.add(currInput);
        }
        return activations;
    }

    public List<INDArray> feedForward(INDArray input) {
        if (input == null) {
            throw new IllegalStateException("Unable to perform feed forward; no input found");
        }
        this.input = this.getLayerWiseConfigurations().getInputPreProcess(0) != null ? this.getLayerWiseConfigurations().getInputPreProcess(0).preProcess(input) : input;
        return this.feedForward();
    }

    @Override
    public Gradient gradient() {
        DefaultGradient ret = new DefaultGradient();
        for (int i = 0; i < this.layers.length; i += 2) {
            ret.gradientForVariable().put(String.valueOf(i), this.layers[i].gradient().gradient());
        }
        return ret;
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.getOutputLayer().score());
    }

    protected void applyDropConnectIfNecessary(INDArray input) {
        if (this.layerWiseConfigurations.isUseDropConnect()) {
            INDArray mean = Nd4j.valueArrayOf((int)input.slices(), (int)input.columns(), (double)0.5);
            INDArray mask = Nd4j.getDistributions().createBinomial(1, mean).sample(mean.shape());
            input.muli(mask);
            if (this.defaultConfiguration.getL2() > 0.0) {
                input.muli((Number)this.defaultConfiguration.getL2());
            }
        }
    }

    protected List<INDArray> computeDeltasR(INDArray v) {
        int i;
        ArrayList<INDArray> deltaRet = new ArrayList<INDArray>();
        INDArray[] deltas = new INDArray[this.getnLayers() + 1];
        List<INDArray> activations = this.feedForward();
        List<INDArray> rActivations = this.feedForwardR(activations, v);
        ArrayList<INDArray> weights = new ArrayList<INDArray>();
        ArrayList<INDArray> biases = new ArrayList<INDArray>();
        ArrayList<String> activationFunctions = new ArrayList<String>();
        for (int j = 0; j < this.getLayers().length; ++j) {
            weights.add(this.getLayers()[j].getParam("W"));
            biases.add(this.getLayers()[j].getParam("b"));
            activationFunctions.add(this.getLayers()[j].conf().getActivationFunction());
        }
        INDArray rix = rActivations.get(rActivations.size() - 1).divi((Number)this.input.slices());
        LinAlgExceptions.assertValidNum((INDArray)rix);
        for (i = this.getnLayers() - 1; i >= 0; --i) {
            deltas[i] = activations.get(i).transpose().mmul(rix);
            this.applyDropConnectIfNecessary(deltas[i]);
            if (i <= 0) continue;
            rix = rix.mmul(((INDArray)weights.get(i)).addRowVector((INDArray)biases.get(i)).transpose()).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform((String)activationFunctions.get(i - 1), activations.get(i)).derivative()));
        }
        for (i = 0; i < deltas.length - 1; ++i) {
            if (this.defaultConfiguration.isConstrainGradientToUnitNorm()) {
                double sum = deltas[i].sum(Integer.MAX_VALUE).getDouble(0);
                if (sum > 0.0) {
                    deltaRet.add(deltas[i].div(deltas[i].norm2(Integer.MAX_VALUE)));
                } else {
                    deltaRet.add(deltas[i]);
                }
            } else {
                deltaRet.add(deltas[i]);
            }
            LinAlgExceptions.assertValidNum((INDArray)((INDArray)deltaRet.get(i)));
        }
        return deltaRet;
    }

    public void dampingUpdate(double rho, double boost, double decrease) {
        if (rho < 0.25 || Double.isNaN(rho)) {
            this.layerWiseConfigurations.setDampingFactor(this.getLayerWiseConfigurations().getDampingFactor() * boost);
        } else if (rho > 0.75) {
            this.layerWiseConfigurations.setDampingFactor(this.getLayerWiseConfigurations().getDampingFactor() * decrease);
        }
    }

    public double reductionRatio(INDArray p, double currScore, double score, INDArray gradient) {
        double currentDamp = this.layerWiseConfigurations.getDampingFactor();
        this.layerWiseConfigurations.setDampingFactor(0.0);
        INDArray denom = this.getBackPropRGradient(p);
        denom.muli((Number)0.5).muli(p.mul(denom)).sum(0);
        denom.subi(gradient.mul(p).sum(0));
        double rho = (currScore - score) / (Double)denom.getScalar(0).element();
        this.layerWiseConfigurations.setDampingFactor(currentDamp);
        if (score - currScore > 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return rho;
    }

    protected List<Pair<INDArray, INDArray>> computeDeltas2() {
        int i;
        ArrayList<Pair<INDArray, INDArray>> deltaRet = new ArrayList<Pair<INDArray, INDArray>>();
        List<INDArray> activations = this.feedForward();
        INDArray[] deltas = new INDArray[activations.size() - 1];
        INDArray[] preCons = new INDArray[activations.size() - 1];
        INDArray ix = activations.get(activations.size() - 1).sub(this.labels).div((Number)this.labels.slices());
        ArrayList<INDArray> weights = new ArrayList<INDArray>();
        ArrayList<INDArray> biases = new ArrayList<INDArray>();
        ArrayList<String> activationFunctions = new ArrayList<String>();
        for (int j = 0; j < this.getLayers().length; ++j) {
            weights.add(this.getLayers()[j].getParam("W"));
            biases.add(this.getLayers()[j].getParam("b"));
            activationFunctions.add(this.getLayers()[j].conf().getActivationFunction());
        }
        for (i = weights.size() - 1; i >= 0; --i) {
            deltas[i] = activations.get(i).transpose().mmul(ix);
            preCons[i] = Transforms.pow((INDArray)activations.get(i).transpose(), (Number)2).mmul(Transforms.pow((INDArray)ix, (Number)2)).muli((Number)this.labels.slices());
            this.applyDropConnectIfNecessary(deltas[i]);
            if (i <= 0) continue;
            ix = ix.mmul(((INDArray)weights.get(i)).transpose()).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform((String)activationFunctions.get(i - 1), activations.get(i)).derivative()));
        }
        for (i = 0; i < deltas.length; ++i) {
            if (this.defaultConfiguration.isConstrainGradientToUnitNorm()) {
                deltaRet.add(new Pair<INDArray, INDArray>(deltas[i].divi(deltas[i].norm2(Integer.MAX_VALUE)), preCons[i]));
                continue;
            }
            deltaRet.add(new Pair<INDArray, INDArray>(deltas[i], preCons[i]));
        }
        return deltaRet;
    }

    public INDArray getBackPropRGradient(INDArray v) {
        return this.pack(this.backPropGradientR(v));
    }

    public Pair<INDArray, INDArray> getBackPropGradient2() {
        List<Pair<Pair<INDArray, INDArray>, Pair<INDArray, INDArray>>> deltas = this.backPropGradient2();
        ArrayList<Pair<INDArray, INDArray>> deltaNormal = new ArrayList<Pair<INDArray, INDArray>>();
        ArrayList<Pair<INDArray, INDArray>> deltasPreCon = new ArrayList<Pair<INDArray, INDArray>>();
        for (int i = 0; i < deltas.size(); ++i) {
            deltaNormal.add(deltas.get(i).getFirst());
            deltasPreCon.add(deltas.get(i).getSecond());
        }
        return new Pair<INDArray, INDArray>(this.pack(deltaNormal), this.pack(deltasPreCon));
    }

    public MultiLayerNetwork clone() {
        MultiLayerNetwork ret;
        try {
            Constructor<?> constructor = this.getClass().getDeclaredConstructor(MultiLayerConfiguration.class);
            ret = (MultiLayerNetwork)constructor.newInstance(this.getLayerWiseConfigurations());
            ret.update(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to cloe network");
        }
        return ret;
    }

    @Override
    public INDArray params() {
        ArrayList<INDArray> params = new ArrayList<INDArray>();
        for (int i = 0; i < this.getnLayers(); ++i) {
            params.add(this.layers[i].params());
        }
        return Nd4j.toFlattened(params);
    }

    @Override
    public void setParams(INDArray params) {
        this.setParameters(params);
    }

    @Override
    public int numParams() {
        int length = 0;
        for (int i = 0; i < this.layers.length; ++i) {
            length += this.layers[i].numParams();
        }
        return length;
    }

    public INDArray pack() {
        return this.params();
    }

    public INDArray pack(List<Pair<INDArray, INDArray>> layers) {
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (Pair<INDArray, INDArray> layer : layers) {
            list.add(layer.getFirst());
            list.add(layer.getSecond());
        }
        return Nd4j.toFlattened(list);
    }

    @Override
    public double score(org.nd4j.linalg.dataset.api.DataSet data) {
        return this.score(data.getFeatureMatrix(), data.getLabels());
    }

    public List<Pair<INDArray, INDArray>> unPack(INDArray param) {
        if (param.slices() != 1) {
            param = param.reshape(1, param.length());
        }
        ArrayList<Pair<INDArray, INDArray>> ret = new ArrayList<Pair<INDArray, INDArray>>();
        int curr = 0;
        for (int i = 0; i < this.layers.length; ++i) {
            int layerLength = this.layers[i].getParam("W").length() + this.layers[i].getParam("b").length();
            INDArray subMatrix = param.get(new NDArrayIndex[]{NDArrayIndex.interval((int)curr, (int)(curr + layerLength))});
            INDArray weightPortion = subMatrix.get(new NDArrayIndex[]{NDArrayIndex.interval((int)0, (int)this.layers[i].getParam("W").length())});
            int beginHBias = this.layers[i].getParam("W").length();
            int endHbias = subMatrix.length();
            INDArray hBiasPortion = subMatrix.get(new NDArrayIndex[]{NDArrayIndex.interval((int)beginHBias, (int)endHbias)});
            int layerLengthSum = weightPortion.length() + hBiasPortion.length();
            if (layerLengthSum != layerLength) {
                if (hBiasPortion.length() != this.layers[i].getParam("b").length()) {
                    throw new IllegalStateException("Hidden bias on layer " + i + " was off");
                }
                if (weightPortion.length() != this.layers[i].getParam("W").length()) {
                    throw new IllegalStateException("Weight portion on layer " + i + " was off");
                }
            }
            ret.add(new Pair<INDArray, INDArray>(weightPortion.reshape(this.layers[i].getParam("W").slices(), this.layers[i].getParam("W").columns()), hBiasPortion.reshape(this.layers[i].getParam("b").slices(), this.layers[i].getParam("b").columns())));
            curr += layerLength;
        }
        return ret;
    }

    protected List<Pair<Pair<INDArray, INDArray>, Pair<INDArray, INDArray>>> backPropGradient2() {
        List<Pair<INDArray, INDArray>> deltas = this.computeDeltas2();
        ArrayList<Pair<Pair<INDArray, INDArray>, Pair<INDArray, INDArray>>> list = new ArrayList<Pair<Pair<INDArray, INDArray>, Pair<INDArray, INDArray>>>();
        ArrayList<Pair<INDArray, INDArray>> grad = new ArrayList<Pair<INDArray, INDArray>>();
        ArrayList<Pair<INDArray, INDArray>> preCon = new ArrayList<Pair<INDArray, INDArray>>();
        for (int l = 0; l < deltas.size(); ++l) {
            INDArray gradientChange = deltas.get(l).getFirst();
            INDArray preConGradientChange = deltas.get(l).getSecond();
            if (l < this.layers.length && gradientChange.length() != this.layers[l].getParam("W").length()) {
                throw new IllegalStateException("Gradient change not equal to weight change");
            }
            INDArray deltaColumnSums = deltas.get(l).getFirst().mean(0);
            INDArray preConColumnSums = deltas.get(l).getSecond().mean(0);
            grad.add(new Pair<INDArray, INDArray>(gradientChange, deltaColumnSums));
            preCon.add(new Pair<INDArray, INDArray>(preConGradientChange, preConColumnSums));
            if (l < this.layers.length && deltaColumnSums.length() != this.layers[l].getParam("b").length()) {
                throw new IllegalStateException("Bias change not equal to weight change");
            }
            if (l != this.getLayers().length || deltaColumnSums.length() == this.getOutputLayer().getParam("b").length()) continue;
            throw new IllegalStateException("Bias change not equal to weight change");
        }
        INDArray g = this.pack(grad);
        INDArray con = this.pack(preCon);
        INDArray theta = this.params();
        if (this.mask == null) {
            this.initMask();
        }
        g.addi(theta.mul((Number)this.defaultConfiguration.getL2()).muli(this.mask));
        INDArray conAdd = Transforms.pow((INDArray)this.mask.mul((Number)this.defaultConfiguration.getL2()).add(Nd4j.valueArrayOf((int)g.slices(), (int)g.columns(), (double)this.layerWiseConfigurations.getDampingFactor())), (Number)0.75);
        con.addi(conAdd);
        List<Pair<INDArray, INDArray>> gUnpacked = this.unPack(g);
        List<Pair<INDArray, INDArray>> conUnpacked = this.unPack(con);
        for (int i = 0; i < gUnpacked.size(); ++i) {
            list.add(new Pair<Pair<INDArray, INDArray>, Pair<INDArray, INDArray>>(gUnpacked.get(i), conUnpacked.get(i)));
        }
        return list;
    }

    @Override
    public void fit(DataSetIterator iter) {
        if (this.layerWiseConfigurations.isPretrain()) {
            this.pretrain(iter);
            iter.reset();
            this.finetune(iter);
        }
        if (this.layerWiseConfigurations.isBackward()) {
            iter.reset();
            while (iter.hasNext()) {
                DataSet next = (DataSet)iter.next();
                this.doBackWard(next.getFeatureMatrix(), next.getLabels());
            }
        }
    }

    protected void doBackWard(INDArray input, INDArray labels) {
        this.setInput(input);
        this.labels = labels;
        this.feedForward();
        if (!(this.getOutputLayer() instanceof OutputLayer)) {
            log.warn("Warning: final layer isn't output layer. You can ignore this message if you just intend on using a a deep neural network with no output layer.");
            return;
        }
        OutputLayer output = (OutputLayer)this.getOutputLayer();
        if (labels == null) {
            throw new IllegalStateException("No labels found");
        }
        output.setLabels(labels);
        Gradient[] errors = new Gradient[this.getnLayers()];
        for (int i = 0; i < this.getLayerWiseConfigurations().getConf(0).getNumIterations(); ++i) {
            List<INDArray> activations = this.feedForward();
            INDArray outputActivate = activations.get(activations.size() - 1);
            INDArray ixInitial = labels.sub(outputActivate).subi(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.getOutputLayer().conf().getActivationFunction(), outputActivate).derivative()));
            Gradient ix = new DefaultGradient();
            ix.gradientForVariable().put("W", ixInitial);
            errors[errors.length - 1] = ix;
            for (int j = this.getnLayers() - 1; j >= 0; --j) {
                ix = this.getLayers()[j].backwardGradient(activations.get(j), ix);
                errors[j] = ix;
            }
            for (int k = 0; k < this.getnLayers(); ++k) {
                Gradient update = this.getLayers()[k].calcGradient(errors[k], activations.get(k));
                GradientAdjustment.updateGradientAccordingToParams(this.getLayers()[k].conf(), i, update, input.slices(), this.getLayers()[k].getOptimizer().adaGradForVariables(), this.getLayers()[k]);
                this.getLayers()[k].update(update);
            }
            for (IterationListener listener : this.listeners) {
                listener.iterationDone(this.getOutputLayer(), i);
            }
        }
    }

    public List<IterationListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<IterationListener> listeners) {
        this.listeners = listeners;
        if (this.layers == null) {
            this.init();
        }
        for (Layer layer : this.layers) {
            layer.setIterationListeners(listeners);
        }
    }

    public void finetune(DataSetIterator iter) {
        DataSet data;
        log.info("Finetune phase ");
        iter.reset();
        while (iter.hasNext() && (data = (DataSet)iter.next()).getFeatureMatrix() != null && data.getLabels() != null) {
            this.setInput(data.getFeatureMatrix());
            this.setLabels(data.getLabels());
            if (this.getOutputLayer().conf().getOptimizationAlgo() != OptimizationAlgorithm.HESSIAN_FREE) {
                this.feedForward();
                if (!(this.getOutputLayer() instanceof OutputLayer)) continue;
                OutputLayer o = (OutputLayer)this.getOutputLayer();
                o.fit(o.input(), this.getLabels());
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    public void finetune(INDArray labels) {
        if (labels != null) {
            this.labels = labels;
        }
        if (!(this.getOutputLayer() instanceof OutputLayer)) {
            log.warn("Output layer not instance of output layer returning.");
            return;
        }
        log.info("Finetune phase");
        OutputLayer o = (OutputLayer)this.getOutputLayer();
        if (this.getOutputLayer().conf().getOptimizationAlgo() == OptimizationAlgorithm.HESSIAN_FREE) {
            throw new UnsupportedOperationException();
        }
        List<INDArray> activations = this.feedForward();
        o.fit(activations.get(activations.size() - 2), labels);
    }

    @Override
    public int[] predict(INDArray d) {
        INDArray output = this.output(d);
        int[] ret = new int[d.slices()];
        if (d.isRowVector()) {
            ret[0] = Nd4j.getBlasWrapper().iamax(output);
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Nd4j.getBlasWrapper().iamax(output.getRow(i));
            }
        }
        return ret;
    }

    @Override
    public INDArray labelProbabilities(INDArray examples) {
        List<INDArray> feed = this.feedForward(examples);
        OutputLayer o = (OutputLayer)this.getOutputLayer();
        return o.labelProbabilities(feed.get(feed.size() - 1));
    }

    @Override
    public void fit(INDArray examples, INDArray labels) {
        this.setInput(examples);
        if (this.layerWiseConfigurations.isPretrain()) {
            this.pretrain(this.getInput());
            this.finetune(labels);
        }
        if (this.layerWiseConfigurations.isBackward()) {
            this.doBackWard(this.getInput(), labels);
        }
    }

    @Override
    public void fit(INDArray data) {
        this.pretrain(data);
    }

    @Override
    public void iterate(INDArray input) {
        this.pretrain(input);
    }

    @Override
    public void fit(org.nd4j.linalg.dataset.api.DataSet data) {
        this.fit(data.getFeatureMatrix(), data.getLabels());
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        this.fit(examples, FeatureUtil.toOutcomeMatrix((int[])labels, (int)this.getOutputLayer().conf().getnOut()));
    }

    public INDArray output(INDArray x) {
        List<INDArray> activations = this.feedForward(x);
        return activations.get(activations.size() - 1);
    }

    public INDArray reconstruct(INDArray x, int layerNum) {
        List<INDArray> forward = this.feedForward(x);
        return forward.get(layerNum - 1);
    }

    public void printConfiguration() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (NeuralNetConfiguration conf : this.getLayerWiseConfigurations().getConfs()) {
            sb.append(" Layer " + count++ + " conf " + conf);
        }
        log.info(sb.toString());
    }

    public void update(MultiLayerNetwork network) {
        this.defaultConfiguration = network.defaultConfiguration;
        this.input = network.input;
        this.labels = network.labels;
        this.layers = (Layer[])ArrayUtils.clone((Object[])network.layers);
    }

    @Override
    public double score(INDArray input, INDArray labels) {
        this.feedForward(input);
        this.setLabels(labels);
        Evaluation eval = new Evaluation();
        eval.eval(labels, this.labelProbabilities(input));
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return this.labels.columns();
    }

    public double score(DataSet data) {
        this.feedForward(data.getFeatureMatrix());
        this.setLabels(data.getLabels());
        return this.score();
    }

    @Override
    public void fit() {
        this.fit(this.input, this.labels);
    }

    @Override
    public void update(Gradient gradient) {
    }

    @Override
    public double score() {
        if (this.getOutputLayer().input() == null) {
            this.feedForward();
        }
        return this.getOutputLayer().score();
    }

    @Override
    public void setScore() {
    }

    @Override
    public void accumulateScore(double accum) {
    }

    @Override
    public void clear() {
        for (Layer layer : this.layers) {
            layer.clear();
        }
        this.input = null;
    }

    public double score(INDArray param) {
        INDArray params = this.params();
        this.setParameters(param);
        double ret = this.score();
        double regCost = 0.5 * this.defaultConfiguration.getL2() * (Double)Transforms.pow((INDArray)this.mask.mul(param), (Number)2).sum(Integer.MAX_VALUE).element();
        this.setParameters(params);
        return ret + regCost;
    }

    public void merge(MultiLayerNetwork network, int batchSize) {
        if (network.layers.length != this.layers.length) {
            throw new IllegalArgumentException("Unable to merge networks that are not of equal length");
        }
        for (int i = 0; i < this.getnLayers(); ++i) {
            Layer n = this.layers[i];
            Layer otherNetwork = network.layers[i];
            n.merge(otherNetwork, batchSize);
        }
        this.getOutputLayer().merge(network.getOutputLayer(), batchSize);
    }

    public void setInput(INDArray input) {
        this.input = this.getLayerWiseConfigurations().getInputPreProcess(0) != null ? this.layerWiseConfigurations.getInputPreProcess(0).preProcess(input) : input;
        if (this.layers == null) {
            this.initializeLayers(this.getInput());
        } else if (this.input == null) {
            this.input = input;
        }
    }

    private void initMask() {
        this.setMask(Nd4j.ones((int)1, (int)this.pack().length()));
    }

    public Layer getOutputLayer() {
        return this.getLayers()[this.getLayers().length - 1];
    }

    public void setParameters(INDArray params) {
        int idx = 0;
        for (int i = 0; i < this.getLayers().length; ++i) {
            Layer layer = this.getLayers()[i];
            int range = layer.numParams();
            INDArray get = params.get(new NDArrayIndex[]{NDArrayIndex.interval((int)idx, (int)(range + idx))});
            if (get.length() < 1) {
                throw new IllegalStateException("Unable to retrieve layer. No params found (length was 0");
            }
            layer.setParams(get);
            idx += range - 1;
        }
    }

    public List<INDArray> feedForwardR(List<INDArray> acts, INDArray v) {
        ArrayList<INDArray> R = new ArrayList<INDArray>();
        R.add(Nd4j.zeros((int)this.input.slices(), (int)this.input.columns()));
        List<Pair<INDArray, INDArray>> vWvB = this.unPack(v);
        List<INDArray> W = MultiLayerUtil.weightMatrices(this);
        for (int i = 0; i < this.layers.length; ++i) {
            String derivative = this.getLayers()[i].conf().getActivationFunction();
            R.add(((INDArray)R.get(i)).mmul(W.get(i)).addi(acts.get(i).mmul(vWvB.get(i).getFirst().addiRowVector(vWvB.get(i).getSecond()))).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(derivative, acts.get(i + 1)).derivative())));
        }
        return R;
    }

    public List<INDArray> feedForwardR(INDArray v) {
        return this.feedForwardR(this.feedForward(), v);
    }

    protected List<Pair<INDArray, INDArray>> backPropGradientR(INDArray v) {
        if (this.mask == null) {
            this.initMask();
        }
        List<INDArray> deltas = this.computeDeltasR(v);
        ArrayList<Pair<INDArray, INDArray>> list = new ArrayList<Pair<INDArray, INDArray>>();
        for (int l = 0; l < this.getnLayers(); ++l) {
            INDArray gradientChange = deltas.get(l);
            if (gradientChange.length() != this.getLayers()[l].getParam("W").length()) {
                throw new IllegalStateException("Gradient change not equal to weight change");
            }
            INDArray deltaColumnSums = deltas.get(l).mean(0);
            if (deltaColumnSums.length() != this.layers[l].getParam("b").length()) {
                throw new IllegalStateException("Bias change not equal to weight change");
            }
            list.add(new Pair<INDArray, INDArray>(gradientChange, deltaColumnSums));
        }
        INDArray pack = this.pack(list).addi(this.mask.mul((Number)this.defaultConfiguration.getL2()).muli(v)).addi(v.mul((Number)this.layerWiseConfigurations.getDampingFactor()));
        return this.unPack(pack);
    }

    public INDArray getLabels() {
        return this.labels;
    }

    public INDArray getInput() {
        return this.input;
    }

    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    public int getnLayers() {
        return this.layerWiseConfigurations.getConfs().size();
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Layer[] layers) {
        this.layers = layers;
    }

    public INDArray getMask() {
        return this.mask;
    }

    public void setMask(INDArray mask) {
        this.mask = mask;
    }
}

