/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.autoencoder;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class AutoEncoder
extends BasePretrainNetwork {
    private static final long serialVersionUID = -6445530486350763837L;

    public AutoEncoder(NeuralNetConfiguration conf) {
        super(conf);
    }

    public AutoEncoder(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<INDArray, INDArray> sampleHiddenGivenVisible(INDArray v) {
        INDArray ret = this.encode(v);
        return new Pair<INDArray, INDArray>(ret, ret);
    }

    @Override
    public Pair<INDArray, INDArray> sampleVisibleGivenHidden(INDArray h) {
        INDArray ret = this.decode(h);
        return new Pair<INDArray, INDArray>(ret, ret);
    }

    public INDArray encode(INDArray x) {
        INDArray W = this.getParam("W");
        INDArray hBias = this.getParam("b");
        INDArray preAct = x.mmul(W).addiRowVector(hBias);
        return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getActivationFunction(), preAct));
    }

    public INDArray decode(INDArray y) {
        INDArray W = this.getParam("W");
        INDArray vBias = this.getParam("vb");
        INDArray preAct = y.mmul(W.transposei());
        preAct.addiRowVector(vBias);
        return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getActivationFunction(), preAct));
    }

    @Override
    public INDArray transform(INDArray x) {
        INDArray y = this.encode(x);
        return this.decode(y);
    }

    @Override
    public Gradient gradient() {
        INDArray W = this.getParam("W");
        double corruptionLevel = this.conf.getCorruptionLevel();
        INDArray corruptedX = corruptionLevel > 0.0 ? this.getCorruptedInput(this.input, corruptionLevel) : this.input;
        INDArray y = this.encode(corruptedX);
        INDArray z = this.decode(y);
        INDArray visibleLoss = this.input.sub(z);
        INDArray hiddenLoss = this.conf.getSparsity() == 0.0 ? visibleLoss.mmul(W).muli(y).muli(y.rsub((Number)1)) : visibleLoss.mmul(W).muli(y).muli(y.add((Number)(-this.conf.getSparsity())));
        INDArray wGradient = corruptedX.transposei().mmul(hiddenLoss).addi(visibleLoss.transposei().mmul(y));
        INDArray hBiasGradient = hiddenLoss.mean(0);
        INDArray vBiasGradient = visibleLoss.mean(0);
        return this.createGradient(wGradient, vBiasGradient, hBiasGradient);
    }
}

