/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;

public class SubsamplingLayer
implements Layer {
    private NeuralNetConfiguration conf;
    private Layer convLayer;
    protected ParamInitializer paramInitializer;
    private Map<String, INDArray> params;

    public SubsamplingLayer(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Gradient error(INDArray input) {
        return null;
    }

    @Override
    public INDArray derivativeActivation(INDArray input) {
        INDArray deriv = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getActivationFunction(), this.activate(input)).derivative());
        return deriv;
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        return null;
    }

    @Override
    public Gradient errorSignal(Gradient error, INDArray input) {
        return null;
    }

    @Override
    public Gradient backwardGradient(INDArray activation, Gradient errorSignal) {
        return null;
    }

    @Override
    public void merge(Layer layer, int batchSize) {
    }

    @Override
    public INDArray activationMean() {
        return null;
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return null;
    }

    @Override
    public INDArray activate() {
        return null;
    }

    @Override
    public INDArray activate(INDArray input) {
        INDArray ret = null;
        int numFeatureMaps = ConvolutionUtils.numFeatureMap(this.conf);
        for (int i = 0; i < input.slices(); ++i) {
            INDArray downSampled = Transforms.downSample((INDArray)input.slice(i), (int[])this.conf.getStride());
            if (ret == null) {
                ret = Nd4j.create((int[])Ints.concat((int[][])new int[][]{{input.slices(), numFeatureMaps}, downSampled.shape()}));
            }
            ret.putSlice(i, downSampled);
        }
        return ret;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Layer clone() {
        return null;
    }

    @Override
    public Pair<Gradient, Gradient> backWard(Gradient errors, Gradient deltas, INDArray activation, String previousActivation) {
        INDArray ret = Nd4j.create((int[])this.conf.getFilterSize());
        int[] filterSize = this.conf.getFilterSize();
        int currLayerFeatureMaps = ConvolutionUtils.numFeatureMap(this.conf);
        int forwardLayerFeatureMaps = ConvolutionUtils.numFeatureMap(this.convLayer.conf());
        if (filterSize.length < 4) {
            throw new IllegalStateException("Illegal filter size found ");
        }
        for (int i = 0; i < forwardLayerFeatureMaps; ++i) {
            for (int j = 0; j < currLayerFeatureMaps; ++j) {
                INDArray featureMapError = Nd4j.create((int[])new int[]{filterSize[0], 1, filterSize[filterSize.length - 2], filterSize[filterSize.length - 1]});
                INDArray rotatedFilter = Nd4j.rot((INDArray)this.convLayer.getParam("convweights").get(new NDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all()}).slice(i).slice(j));
                INDArray forwardError = activation.slice(j);
                featureMapError.addi(Nd4j.getConvolution().convn(forwardError, rotatedFilter, Convolution.Type.FULL));
                ret.putSlice(i, featureMapError);
            }
        }
        DefaultGradient ret2 = new DefaultGradient();
        ret2.gradientForVariable().put("convweights", ret);
        return new Pair<Gradient, Gradient>(ret2, ret2);
    }

    @Override
    public Collection<IterationListener> getIterationListeners() {
        return null;
    }

    @Override
    public void setIterationListeners(Collection<IterationListener> listeners) {
    }

    @Override
    public void fit() {
    }

    @Override
    public void update(Gradient gradient) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void setScore() {
    }

    @Override
    public void accumulateScore(double accum) {
    }

    @Override
    public INDArray transform(INDArray data) {
        return this.activate(data);
    }

    @Override
    public INDArray params() {
        ArrayList<INDArray> ret = new ArrayList<INDArray>();
        for (String s : this.params.keySet()) {
            ret.add(this.params.get(s));
        }
        return Nd4j.toFlattened(ret);
    }

    @Override
    public int numParams() {
        int ret = 0;
        for (INDArray val : this.params.values()) {
            ret += val.length();
        }
        return ret;
    }

    @Override
    public void setParams(INDArray params) {
        List<String> gradientList = this.conf.variables();
        int length = 0;
        for (String s : gradientList) {
            length += this.getParam(s).length();
        }
        if (params.length() != length) {
            throw new IllegalArgumentException("Unable to set parameters: must be of length " + length);
        }
        int idx = 0;
        for (int i = 0; i < gradientList.size(); ++i) {
            INDArray param = this.getParam(gradientList.get(i));
            INDArray get = params.get(new NDArrayIndex[]{NDArrayIndex.interval((int)idx, (int)(idx + param.length()))});
            if (param.length() != get.length()) {
                throw new IllegalStateException("Parameter " + gradientList.get(i) + " should have been of length " + param.length() + " but was " + get.length());
            }
            param.assign(get.reshape(param.shape()));
            idx += param.length();
        }
        this.setScore();
    }

    @Override
    public void initParams() {
        this.paramInitializer.init(this.paramTable(), this.conf());
    }

    @Override
    public void fit(INDArray data) {
    }

    @Override
    public void iterate(INDArray input) {
    }

    @Override
    public Gradient gradient() {
        return null;
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return null;
    }

    @Override
    public int batchSize() {
        return 0;
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.conf;
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public INDArray input() {
        return null;
    }

    @Override
    public void validateInput() {
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params.get(param);
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.params;
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        this.params = paramTable;
    }

    @Override
    public void setParam(String key, INDArray val) {
        this.params.put(key, val);
    }

    @Override
    public void clear() {
    }
}

