/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.OutputPreProcessor;
import org.deeplearning4j.nn.conf.deserializers.PreProcessorDeSerializer;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.RBM;
import org.deeplearning4j.nn.conf.override.ConfOverride;
import org.deeplearning4j.nn.conf.rng.DefaultRandom;
import org.deeplearning4j.nn.conf.rng.Random;
import org.deeplearning4j.nn.conf.serializers.PreProcessorSerializer;
import org.deeplearning4j.nn.conf.stepfunctions.DefaultStepFunction;
import org.deeplearning4j.nn.conf.stepfunctions.GradientStepFunction;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private double sparsity = 0.0;
    private boolean useAdaGrad = true;
    private double lr = 0.1;
    protected double corruptionLevel = 0.3;
    protected int numIterations = 1000;
    protected double momentum = 0.5;
    protected double l2 = 0.0;
    protected boolean useRegularization = false;
    private String customLossFunction;
    protected Map<Integer, Double> momentumAfter = new HashMap<Integer, Double>();
    protected int resetAdaGradIterations = -1;
    protected int numLineSearchIterations = 100;
    protected double dropOut = 0.0;
    protected boolean applySparsity = false;
    protected WeightInit weightInit = WeightInit.VI;
    protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
    protected LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
    protected boolean constrainGradientToUnitNorm = false;
    protected Random rng;
    protected Distribution dist;
    protected StepFunction stepFunction = new GradientStepFunction();
    protected Layer layer;
    protected List<String> variables = new ArrayList<String>();
    protected int nIn;
    protected int nOut;
    protected String activationFunction;
    private RBM.VisibleUnit visibleUnit = RBM.VisibleUnit.BINARY;
    private RBM.HiddenUnit hiddenUnit = RBM.HiddenUnit.BINARY;
    protected int k = 1;
    private int[] weightShape;
    private int[] filterSize = new int[]{2, 2};
    private int[] stride = new int[]{2, 2};
    @Deprecated
    protected int kernel = 5;
    protected int batchSize = 10;
    protected boolean minimize = false;
    protected double l1 = 0.0;
    protected int[] featureMapSize = new int[]{9, 9};
    protected ConvolutionLayer.ConvolutionType convolutionType = ConvolutionLayer.ConvolutionType.MAX;

    public NeuralNetConfiguration() {
    }

    public NeuralNetConfiguration(double sparsity, boolean useAdaGrad, double lr, int k, double corruptionLevel, int numIterations, double momentum, double l2, boolean useRegularization, Map<Integer, Double> momentumAfter, int resetAdaGradIterations, double dropOut, boolean applySparsity, WeightInit weightInit, OptimizationAlgorithm optimizationAlgo, LossFunctions.LossFunction lossFunction, boolean constrainGradientToUnitNorm, Random rng, Distribution dist, int nIn, int nOut, String activationFunction, RBM.VisibleUnit visibleUnit, RBM.HiddenUnit hiddenUnit, int[] weightShape, int[] filterSize, int[] stride, int[] featureMapSize, int kernel, int batchSize, int numLineSearchIterations, boolean minimize, Layer layer, ConvolutionLayer.ConvolutionType convolutionType, double l1, String customLossFunction) {
        this.minimize = minimize;
        this.customLossFunction = customLossFunction;
        this.convolutionType = convolutionType;
        this.numLineSearchIterations = numLineSearchIterations;
        this.featureMapSize = featureMapSize;
        this.l1 = l1;
        this.batchSize = batchSize;
        if (layer == null) {
            throw new IllegalStateException("No layer defined.");
        }
        this.layer = layer;
        this.sparsity = sparsity;
        this.useAdaGrad = useAdaGrad;
        this.lr = lr;
        this.kernel = kernel;
        this.k = k;
        this.corruptionLevel = corruptionLevel;
        this.numIterations = numIterations;
        this.momentum = momentum;
        this.l2 = l2;
        this.useRegularization = useRegularization;
        this.momentumAfter = momentumAfter;
        this.resetAdaGradIterations = resetAdaGradIterations;
        this.dropOut = dropOut;
        this.applySparsity = applySparsity;
        this.weightInit = weightInit;
        this.optimizationAlgo = optimizationAlgo;
        this.lossFunction = lossFunction;
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
        this.rng = rng;
        this.dist = dist;
        this.nIn = nIn;
        this.nOut = nOut;
        this.activationFunction = activationFunction;
        this.visibleUnit = visibleUnit;
        this.hiddenUnit = hiddenUnit;
        this.weightShape = weightShape != null ? weightShape : new int[]{nIn, nOut};
        this.filterSize = filterSize;
        this.stride = stride;
    }

    public NeuralNetConfiguration(NeuralNetConfiguration neuralNetConfiguration) {
        Field[] fields;
        for (Field f : fields = NeuralNetConfiguration.class.getDeclaredFields()) {
            try {
                f.setAccessible(true);
                f.set(this, f.get(neuralNetConfiguration));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.dist == null) {
            this.dist = new NormalDistribution(0.01, 1.0);
        }
    }

    public String getCustomLossFunction() {
        return this.customLossFunction;
    }

    public void setCustomLossFunction(String customLossFunction) {
        this.customLossFunction = customLossFunction;
    }

    public ConvolutionLayer.ConvolutionType getConvolutionType() {
        return this.convolutionType;
    }

    public void setConvolutionType(ConvolutionLayer.ConvolutionType convolutionType) {
        this.convolutionType = convolutionType;
    }

    public int getNumLineSearchIterations() {
        return this.numLineSearchIterations;
    }

    public void setNumLineSearchIterations(int numLineSearchIterations) {
        this.numLineSearchIterations = numLineSearchIterations;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getKernel() {
        return this.kernel;
    }

    public void setKernel(int kernel) {
        this.kernel = kernel;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
        }
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public List<String> variables() {
        return this.variables;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public int[] getWeightShape() {
        return this.weightShape;
    }

    public void setWeightShape(int[] weightShape) {
        this.weightShape = weightShape;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public RBM.HiddenUnit getHiddenUnit() {
        return this.hiddenUnit;
    }

    public void setHiddenUnit(RBM.HiddenUnit hiddenUnit) {
        this.hiddenUnit = hiddenUnit;
    }

    public RBM.VisibleUnit getVisibleUnit() {
        return this.visibleUnit;
    }

    public void setVisibleUnit(RBM.VisibleUnit visibleUnit) {
        this.visibleUnit = visibleUnit;
    }

    public LossFunctions.LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public void setLossFunction(LossFunctions.LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public String getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(String activationFunction) {
        this.activationFunction = activationFunction;
    }

    public int getnIn() {
        return this.nIn;
    }

    public void setnIn(int nIn) {
        this.nIn = nIn;
    }

    public int getnOut() {
        return this.nOut;
    }

    public void setnOut(int nOut) {
        this.nOut = nOut;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public boolean isUseAdaGrad() {
        return this.useAdaGrad;
    }

    public void setUseAdaGrad(boolean useAdaGrad) {
        this.useAdaGrad = useAdaGrad;
    }

    public double getLr() {
        return this.lr;
    }

    public void setLr(double lr) {
        this.lr = lr;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public double getL2() {
        return this.l2;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public Map<Integer, Double> getMomentumAfter() {
        return this.momentumAfter;
    }

    public void setMomentumAfter(Map<Integer, Double> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public int getResetAdaGradIterations() {
        return this.resetAdaGradIterations;
    }

    public void setResetAdaGradIterations(int resetAdaGradIterations) {
        this.resetAdaGradIterations = resetAdaGradIterations;
    }

    public double getDropOut() {
        return this.dropOut;
    }

    public boolean isApplySparsity() {
        return this.applySparsity;
    }

    public void setApplySparsity(boolean applySparsity) {
        this.applySparsity = applySparsity;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public boolean isConstrainGradientToUnitNorm() {
        return this.constrainGradientToUnitNorm;
    }

    public void setConstrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
    }

    public Random getRng() {
        return this.rng;
    }

    public void setRng(Random rng) {
        this.rng = rng;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public int[] getFilterSize() {
        return this.filterSize;
    }

    public void setFilterSize(int[] filterSize) {
        this.filterSize = filterSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NeuralNetConfiguration that = (NeuralNetConfiguration)o;
        if (Double.compare(that.sparsity, this.sparsity) != 0) {
            return false;
        }
        if (this.useAdaGrad != that.useAdaGrad) {
            return false;
        }
        if (Double.compare(that.lr, this.lr) != 0) {
            return false;
        }
        if (Double.compare(that.corruptionLevel, this.corruptionLevel) != 0) {
            return false;
        }
        if (this.numIterations != that.numIterations) {
            return false;
        }
        if (Double.compare(that.momentum, this.momentum) != 0) {
            return false;
        }
        if (Double.compare(that.l2, this.l2) != 0) {
            return false;
        }
        if (this.useRegularization != that.useRegularization) {
            return false;
        }
        if (this.resetAdaGradIterations != that.resetAdaGradIterations) {
            return false;
        }
        if (this.numLineSearchIterations != that.numLineSearchIterations) {
            return false;
        }
        if (Double.compare(that.dropOut, this.dropOut) != 0) {
            return false;
        }
        if (this.applySparsity != that.applySparsity) {
            return false;
        }
        if (this.constrainGradientToUnitNorm != that.constrainGradientToUnitNorm) {
            return false;
        }
        if (this.nIn != that.nIn) {
            return false;
        }
        if (this.nOut != that.nOut) {
            return false;
        }
        if (this.k != that.k) {
            return false;
        }
        if (this.kernel != that.kernel) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.minimize != that.minimize) {
            return false;
        }
        if (this.momentumAfter != null ? !this.momentumAfter.equals(that.momentumAfter) : that.momentumAfter != null) {
            return false;
        }
        if (this.weightInit != that.weightInit) {
            return false;
        }
        if (this.optimizationAlgo != that.optimizationAlgo) {
            return false;
        }
        if (this.lossFunction != that.lossFunction) {
            return false;
        }
        if (this.rng != null ? !this.rng.equals(that.rng) : that.rng != null) {
            return false;
        }
        if (this.dist != null ? !this.dist.equals(that.dist) : that.dist != null) {
            return false;
        }
        if (this.stepFunction != null ? !this.stepFunction.equals(that.stepFunction) : that.stepFunction != null) {
            return false;
        }
        if (this.layer != null ? !this.layer.equals(that.layer) : that.layer != null) {
            return false;
        }
        if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) {
            return false;
        }
        if (this.activationFunction != null ? !this.activationFunction.equals(that.activationFunction) : that.activationFunction != null) {
            return false;
        }
        if (this.visibleUnit != that.visibleUnit) {
            return false;
        }
        if (this.hiddenUnit != that.hiddenUnit) {
            return false;
        }
        if (!Arrays.equals(this.weightShape, that.weightShape)) {
            return false;
        }
        if (!Arrays.equals(this.filterSize, that.filterSize)) {
            return false;
        }
        if (!Arrays.equals(this.stride, that.stride)) {
            return false;
        }
        return this.convolutionType == that.convolutionType;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.sparsity);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.useAdaGrad ? 1 : 0);
        temp = Double.doubleToLongBits(this.lr);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.corruptionLevel);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numIterations;
        temp = Double.doubleToLongBits(this.momentum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.l2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.useRegularization ? 1 : 0);
        result = 31 * result + (this.momentumAfter != null ? this.momentumAfter.hashCode() : 0);
        result = 31 * result + this.resetAdaGradIterations;
        result = 31 * result + this.numLineSearchIterations;
        temp = Double.doubleToLongBits(this.dropOut);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.applySparsity ? 1 : 0);
        result = 31 * result + (this.weightInit != null ? this.weightInit.hashCode() : 0);
        result = 31 * result + (this.optimizationAlgo != null ? this.optimizationAlgo.hashCode() : 0);
        result = 31 * result + (this.lossFunction != null ? this.lossFunction.hashCode() : 0);
        result = 31 * result + (this.constrainGradientToUnitNorm ? 1 : 0);
        result = 31 * result + (this.rng != null ? this.rng.hashCode() : 0);
        result = 31 * result + (this.dist != null ? this.dist.hashCode() : 0);
        result = 31 * result + (this.stepFunction != null ? this.stepFunction.hashCode() : 0);
        result = 31 * result + (this.layer != null ? this.layer.hashCode() : 0);
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        result = 31 * result + this.nIn;
        result = 31 * result + this.nOut;
        result = 31 * result + (this.activationFunction != null ? this.activationFunction.hashCode() : 0);
        result = 31 * result + (this.visibleUnit != null ? this.visibleUnit.hashCode() : 0);
        result = 31 * result + (this.hiddenUnit != null ? this.hiddenUnit.hashCode() : 0);
        result = 31 * result + this.k;
        result = 31 * result + (this.weightShape != null ? Arrays.hashCode(this.weightShape) : 0);
        result = 31 * result + (this.filterSize != null ? Arrays.hashCode(this.filterSize) : 0);
        result = 31 * result + (this.stride != null ? Arrays.hashCode(this.stride) : 0);
        result = 31 * result + this.kernel;
        result = 31 * result + this.batchSize;
        result = 31 * result + (this.minimize ? 1 : 0);
        result = 31 * result + (this.convolutionType != null ? this.convolutionType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NeuralNetConfiguration{sparsity=" + this.sparsity + ", useAdaGrad=" + this.useAdaGrad + ", lr=" + this.lr + ", corruptionLevel=" + this.corruptionLevel + ", numIterations=" + this.numIterations + ", momentum=" + this.momentum + ", l2=" + this.l2 + ", useRegularization=" + this.useRegularization + ", momentumAfter=" + this.momentumAfter + ", resetAdaGradIterations=" + this.resetAdaGradIterations + ", numLineSearchIterations=" + this.numLineSearchIterations + ", dropOut=" + this.dropOut + ", applySparsity=" + this.applySparsity + ", weightInit=" + (Object)((Object)this.weightInit) + ", optimizationAlgo=" + (Object)((Object)this.optimizationAlgo) + ", lossFunction=" + this.lossFunction + ", constrainGradientToUnitNorm=" + this.constrainGradientToUnitNorm + ", rng=" + this.rng + ", dist=" + this.dist + ", stepFunction=" + this.stepFunction + ", layer=" + this.layer + ", variables=" + this.variables + ", nIn=" + this.nIn + ", nOut=" + this.nOut + ", activationFunction='" + this.activationFunction + '\'' + ", visibleUnit=" + (Object)((Object)this.visibleUnit) + ", hiddenUnit=" + (Object)((Object)this.hiddenUnit) + ", k=" + this.k + ", weightShape=" + Arrays.toString(this.weightShape) + ", filterSize=" + Arrays.toString(this.filterSize) + ", stride=" + Arrays.toString(this.stride) + ", kernel=" + this.kernel + ", batchSize=" + this.batchSize + ", minimize=" + this.minimize + ", convolutionType=" + (Object)((Object)this.convolutionType) + '}';
    }

    public NeuralNetConfiguration clone() {
        return new NeuralNetConfiguration(this);
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret.replaceAll("\"activationFunction\",", "");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public double getL1() {
        return this.l1;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public int[] getFeatureMapSize() {
        return this.featureMapSize;
    }

    public void setFeatureMapSize(int[] featureMapSize) {
        this.featureMapSize = featureMapSize;
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public void setCorruptionLevel(double corruptionLevel) {
        this.corruptionLevel = corruptionLevel;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setDropOut(double dropOut) {
        this.dropOut = dropOut;
    }

    public static ObjectMapper mapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule module = new SimpleModule();
        module.addSerializer(OutputPreProcessor.class, (JsonSerializer)new PreProcessorSerializer());
        module.addDeserializer(OutputPreProcessor.class, (JsonDeserializer)new PreProcessorDeSerializer());
        ret.registerModule((Module)module);
        return ret;
    }

    public static class Builder {
        private int k = 1;
        private String customLossFunction;
        @Deprecated
        private int kernel = 5;
        private double corruptionLevel = 0.3f;
        private double sparsity = 0.0;
        private boolean useAdaGrad = true;
        private double lr = 0.1f;
        private double momentum = 0.5;
        private double l2 = 0.0;
        private boolean useRegularization = false;
        private Map<Integer, Double> momentumAfter;
        private int resetAdaGradIterations = -1;
        private double dropOut = 0.0;
        private boolean applySparsity = false;
        private WeightInit weightInit = WeightInit.VI;
        private OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
        private boolean constrainGradientToUnitNorm = false;
        private Random rng = new DefaultRandom();
        private Distribution dist = new NormalDistribution(0.001, 1.0);
        private LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
        private int nIn;
        private int nOut;
        private String activationFunction = "sigmoid";
        private RBM.VisibleUnit visibleUnit = RBM.VisibleUnit.BINARY;
        private RBM.HiddenUnit hiddenUnit = RBM.HiddenUnit.BINARY;
        private int numIterations = 1000;
        private int[] weightShape;
        private int[] filterSize = new int[]{2, 2, 2, 2};
        private int[] featureMapSize = new int[]{2, 2};
        private int[] stride = new int[]{2, 2};
        private StepFunction stepFunction = new DefaultStepFunction();
        private Layer layer;
        private int batchSize = 100;
        private int numLineSearchIterations = 100;
        private boolean minimize = false;
        private ConvolutionLayer.ConvolutionType convolutionType = ConvolutionLayer.ConvolutionType.MAX;
        private double l1 = 0.0;

        public Builder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder customLossFunction(String customLossFunction) {
            this.customLossFunction = customLossFunction;
            return this;
        }

        public Builder convolutionType(ConvolutionLayer.ConvolutionType convolutionType) {
            this.convolutionType = convolutionType;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder numLineSearchIterations(int numLineSearchIterations) {
            this.numLineSearchIterations = numLineSearchIterations;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder kernel(int kernel) {
            this.kernel = kernel;
            return this;
        }

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list(int size) {
            if (size < 2) {
                throw new IllegalArgumentException("Number of layers must be > 1");
            }
            ArrayList<Builder> list = new ArrayList<Builder>();
            for (int i = 0; i < size; ++i) {
                list.add(this.clone());
            }
            return new ListBuilder(list);
        }

        public Builder clone() {
            Field[] fields;
            Builder b = new Builder();
            for (Field f : fields = Builder.class.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    f.set(b, f.get(this));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return b;
        }

        public Builder featureMapSize(int ... featureMapSize) {
            this.featureMapSize = featureMapSize;
            return this;
        }

        public Builder stride(int[] stride) {
            this.stride = stride;
            return this;
        }

        public Builder filterSize(int ... filterSize) {
            if (filterSize == null) {
                return this;
            }
            if (filterSize.length != 4) {
                throw new IllegalArgumentException("Invalid filter size must be length 4");
            }
            this.filterSize = filterSize;
            return this;
        }

        public Builder weightShape(int[] weightShape) {
            this.weightShape = weightShape;
            return this;
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder sparsity(double sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        public Builder useAdaGrad(boolean useAdaGrad) {
            this.useAdaGrad = useAdaGrad;
            return this;
        }

        public Builder learningRate(double lr) {
            this.lr = lr;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder k(int k) {
            this.k = k;
            return this;
        }

        public Builder corruptionLevel(double corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
            return this;
        }

        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return this;
        }

        @Deprecated
        public Builder adagradResetIterations(int resetAdaGradIterations) {
            this.resetAdaGradIterations = resetAdaGradIterations;
            return this;
        }

        public Builder dropOut(double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder applySparsity(boolean applySparsity) {
            this.applySparsity = applySparsity;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder rng(Random rng) {
            this.rng = rng;
            return this;
        }

        public NeuralNetConfiguration build() {
            NeuralNetConfiguration ret = new NeuralNetConfiguration(this.sparsity, this.useAdaGrad, this.lr, this.k, this.corruptionLevel, this.numIterations, this.momentum, this.l2, this.useRegularization, this.momentumAfter, this.resetAdaGradIterations, this.dropOut, this.applySparsity, this.weightInit, this.optimizationAlgo, this.lossFunction, this.constrainGradientToUnitNorm, this.rng, this.dist, this.nIn, this.nOut, this.activationFunction, this.visibleUnit, this.hiddenUnit, this.weightShape, this.filterSize, this.stride, this.featureMapSize, this.kernel, this.batchSize, this.numLineSearchIterations, this.minimize, this.layer, this.convolutionType, this.l1, this.customLossFunction);
            ret.useAdaGrad = this.useAdaGrad;
            ret.stepFunction = this.stepFunction;
            return ret;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder resetAdaGradIterations(int resetAdaGradIterations) {
            this.resetAdaGradIterations = resetAdaGradIterations;
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder lossFunction(LossFunctions.LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return this;
        }

        public Builder constrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
            this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
            return this;
        }

        public Builder nIn(int nIn) {
            this.nIn = nIn;
            return this;
        }

        public Builder nOut(int nOut) {
            this.nOut = nOut;
            return this;
        }

        public Builder activationFunction(String activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        public Builder visibleUnit(RBM.VisibleUnit visibleUnit) {
            this.visibleUnit = visibleUnit;
            return this;
        }

        public Builder hiddenUnit(RBM.HiddenUnit hiddenUnit) {
            this.hiddenUnit = hiddenUnit;
            return this;
        }
    }

    public static class ListBuilder
    extends MultiLayerConfiguration.Builder {
        private List<Builder> layerwise;

        public ListBuilder(List<Builder> list) {
            this.layerwise = list;
        }

        @Override
        public ListBuilder backward(boolean backward) {
            this.backward = backward;
            return this;
        }

        @Override
        public ListBuilder hiddenLayerSizes(int ... hiddenLayerSizes) {
            this.hiddenLayerSizes = hiddenLayerSizes;
            return this;
        }

        @Override
        public MultiLayerConfiguration build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            for (int i = 0; i < this.layerwise.size(); ++i) {
                if (this.confOverrides.get(i) != null) {
                    ((ConfOverride)this.confOverrides.get(i)).overrideLayer(i, this.layerwise.get(i));
                }
                list.add(this.layerwise.get(i).build());
            }
            return new MultiLayerConfiguration.Builder().backward(this.backward).inputPreProcessors(this.inputPreProcessor).useDropConnect(this.useDropConnect).pretrain(this.pretrain).preProcessors(this.preProcessors).hiddenLayerSizes(this.hiddenLayerSizes).confs(list).build();
        }
    }
}

