/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.algorithm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ArrayUtils;
import org.deeplearning4j.clustering.algorithm.ClusteringAlgorithm;
import org.deeplearning4j.clustering.algorithm.iteration.IterationHistory;
import org.deeplearning4j.clustering.algorithm.iteration.IterationInfo;
import org.deeplearning4j.clustering.algorithm.strategy.ClusteringStrategy;
import org.deeplearning4j.clustering.algorithm.strategy.ClusteringStrategyType;
import org.deeplearning4j.clustering.algorithm.strategy.OptimisationStrategy;
import org.deeplearning4j.clustering.cluster.Cluster;
import org.deeplearning4j.clustering.cluster.ClusterSet;
import org.deeplearning4j.clustering.cluster.ClusterUtils;
import org.deeplearning4j.clustering.cluster.Point;
import org.deeplearning4j.clustering.cluster.info.ClusterSetInfo;
import org.deeplearning4j.util.MultiThreadUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseClusteringAlgorithm
implements ClusteringAlgorithm,
Serializable {
    private static final long serialVersionUID = 338231277453149972L;
    private static final Logger log = LoggerFactory.getLogger(BaseClusteringAlgorithm.class);
    private ClusteringStrategy clusteringStrategy;
    private IterationHistory iterationHistory;
    private int currentIteration = 0;
    private ClusterSet clusterSet;
    private List<Point> initialPoints;
    private transient ExecutorService exec;

    protected BaseClusteringAlgorithm(ClusteringStrategy clusteringStrategy) {
        this.clusteringStrategy = clusteringStrategy;
        this.exec = MultiThreadUtils.newExecutorService();
    }

    public static BaseClusteringAlgorithm setup(ClusteringStrategy clusteringStrategy) {
        return new BaseClusteringAlgorithm(clusteringStrategy);
    }

    @Override
    public ClusterSet applyTo(List<Point> points) {
        this.resetState(points);
        this.initClusters();
        this.iterations();
        return this.clusterSet;
    }

    private void resetState(List<Point> points) {
        this.iterationHistory = new IterationHistory();
        this.currentIteration = 0;
        this.clusterSet = null;
        this.initialPoints = points;
    }

    private void iterations() {
        while (!this.clusteringStrategy.getTerminationCondition().isSatisfied(this.iterationHistory) || this.iterationHistory.getMostRecentIterationInfo().isStrategyApplied()) {
            ++this.currentIteration;
            this.removePoints();
            this.classifyPoints();
            this.applyClusteringStrategy();
        }
    }

    protected void classifyPoints() {
        ClusterSetInfo clusterSetInfo = ClusterUtils.classifyPoints(this.clusterSet, this.initialPoints, this.exec);
        ClusterUtils.refreshClustersCenters(this.clusterSet, clusterSetInfo, this.exec);
        this.iterationHistory.getIterationsInfos().put(this.currentIteration, new IterationInfo(this.currentIteration, clusterSetInfo));
    }

    protected void initClusters() {
        ArrayList<Point> points = new ArrayList<Point>(this.initialPoints);
        Random random = new Random();
        this.clusterSet = new ClusterSet(this.clusteringStrategy.getDistanceFunction());
        this.clusterSet.addNewClusterWithCenter((Point)points.remove(random.nextInt(points.size())));
        int initialClusterCount = this.clusteringStrategy.getInitialClusterCount();
        INDArray dxs = Nd4j.create((int)points.size());
        dxs.addi((Number)new Double(Double.MAX_VALUE));
        block0: while (this.clusterSet.getClusterCount() < initialClusterCount) {
            dxs = ClusterUtils.computeSquareDistancesFromNearestCluster(this.clusterSet, points, dxs, this.exec);
            double r = (double)random.nextFloat() * Nd4j.max((INDArray)dxs.getRow(0)).getDouble(0);
            for (int i = 0; i < dxs.length(); ++i) {
                if (!(dxs.getDouble(i) >= r)) continue;
                this.clusterSet.addNewClusterWithCenter((Point)points.remove(i));
                dxs = Nd4j.create((double[])ArrayUtils.remove((double[])dxs.data().asDouble(), (int)i));
                continue block0;
            }
        }
        ClusterSetInfo initialClusterSetInfo = ClusterUtils.computeClusterSetInfo(this.clusterSet);
        this.iterationHistory.getIterationsInfos().put(this.currentIteration, new IterationInfo(this.currentIteration, initialClusterSetInfo));
    }

    protected void applyClusteringStrategy() {
        int removedCount;
        if (!this.isStrategyApplicableNow()) {
            return;
        }
        ClusterSetInfo clusterSetInfo = this.iterationHistory.getMostRecentClusterSetInfo();
        if (!this.clusteringStrategy.isAllowEmptyClusters() && (removedCount = this.removeEmptyClusters(clusterSetInfo)) > 0) {
            int splitCount;
            this.iterationHistory.getMostRecentIterationInfo().setStrategyApplied(true);
            if (this.clusteringStrategy.isStrategyOfType(ClusteringStrategyType.FIXED_CLUSTER_COUNT) && this.clusterSet.getClusterCount() < this.clusteringStrategy.getInitialClusterCount() && (splitCount = ClusterUtils.splitMostSpreadOutClusters(this.clusterSet, clusterSetInfo, this.clusteringStrategy.getInitialClusterCount() - this.clusterSet.getClusterCount(), this.exec)) > 0) {
                this.iterationHistory.getMostRecentIterationInfo().setStrategyApplied(true);
            }
        }
        if (this.clusteringStrategy.isStrategyOfType(ClusteringStrategyType.OPTIMIZATION)) {
            this.optimize();
        }
    }

    protected void optimize() {
        ClusterSetInfo clusterSetInfo = this.iterationHistory.getMostRecentClusterSetInfo();
        OptimisationStrategy optimization = (OptimisationStrategy)this.clusteringStrategy;
        boolean applied = ClusterUtils.applyOptimization(optimization, this.clusterSet, clusterSetInfo, this.exec);
        this.iterationHistory.getMostRecentIterationInfo().setStrategyApplied(applied);
    }

    private boolean isStrategyApplicableNow() {
        return this.clusteringStrategy.isOptimizationDefined() && this.iterationHistory.getIterationCount() != 0 && this.clusteringStrategy.isOptimizationApplicableNow(this.iterationHistory);
    }

    protected int removeEmptyClusters(ClusterSetInfo clusterSetInfo) {
        List<Cluster> removedClusters = this.clusterSet.removeEmptyClusters();
        clusterSetInfo.removeClusterInfos(removedClusters);
        return removedClusters.size();
    }

    protected void removePoints() {
        this.clusterSet.removePoints();
    }
}

