/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.berkeley;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.deeplearning4j.berkeley.SloppyMath;

public class StringUtils {
    private static final int SLURPBUFFSIZE = 16000;
    private static final String PROP = "prop";

    private StringUtils() {
    }

    public static boolean find(String str, String regex) {
        return Pattern.compile(regex).matcher(str).find();
    }

    public static boolean lookingAt(String str, String regex) {
        return Pattern.compile(regex).matcher(str).lookingAt();
    }

    public static boolean matches(String str, String regex) {
        return Pattern.compile(regex).matcher(str).matches();
    }

    public static String slurpFile(File file) throws IOException {
        FileReader r = new FileReader(file);
        return StringUtils.slurpReader(r);
    }

    public static String slurpGBFileNoExceptions(String filename) {
        return StringUtils.slurpFileNoExceptions(filename, "GB18030");
    }

    public static String slurpFile(String filename, String encoding) throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        return StringUtils.slurpReader(r);
    }

    public static String slurpFileNoExceptions(String filename, String encoding) {
        try {
            return StringUtils.slurpFile(filename, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static String slurpGBFile(String filename) throws IOException {
        return StringUtils.slurpFile(filename, "GB18030");
    }

    public static String slurpReader(Reader reader) {
        BufferedReader r = new BufferedReader(reader);
        StringBuffer buff = new StringBuffer();
        try {
            int amountRead;
            char[] chars = new char[16000];
            while ((amountRead = r.read(chars, 0, 16000)) >= 0) {
                buff.append(chars, 0, amountRead);
            }
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return buff.toString();
    }

    public static String slurpFile(String filename) throws IOException {
        return StringUtils.slurpReader(new FileReader(filename));
    }

    public static String slurpFileNoExceptions(File file) {
        try {
            return StringUtils.slurpReader(new FileReader(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(String filename) {
        try {
            return StringUtils.slurpFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpGBURL(URL u) throws IOException {
        return StringUtils.slurpURL(u, "GB18030");
    }

    public static String slurpGBURLNoExceptions(URL u) {
        try {
            return StringUtils.slurpGBURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURLNoExceptions(URL u, String encoding) {
        try {
            return StringUtils.slurpURL(u, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(URL u, String encoding) throws IOException {
        String temp;
        InputStream is;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        uc.setReadTimeout(30000);
        try {
            is = uc.getInputStream();
        }
        catch (SocketTimeoutException e) {
            System.err.println("Time out. Return empty string");
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuffer buff = new StringBuffer(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURL(URL u) throws IOException {
        String temp;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        InputStream is = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer buff = new StringBuffer(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURLNoExceptions(URL u) {
        try {
            return StringUtils.slurpURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(String path) throws Exception {
        return StringUtils.slurpURL(new URL(path));
    }

    public static String slurpURLNoExceptions(String path) {
        try {
            return StringUtils.slurpURL(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String join(Iterable l, String glue) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Object o : l) {
            if (!first) {
                sb.append(glue);
            }
            sb.append(o.toString());
            first = false;
        }
        return sb.toString();
    }

    public static String join(List<?> l, String glue) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(glue);
            }
            Object x = l.get(i);
            sb.append(x.toString());
        }
        return sb.toString();
    }

    public static String join(Object[] elements, String glue) {
        return StringUtils.join(Arrays.asList(elements), glue);
    }

    public static String join(List l) {
        return StringUtils.join(l, " ");
    }

    public static String join(Object[] elements) {
        return StringUtils.join(elements, " ");
    }

    public static List split(String s) {
        return StringUtils.split(s, "\\s+");
    }

    public static List split(String str, String regex) {
        return Arrays.asList(str.split(regex));
    }

    public static String pad(String str, int totalChars) {
        if (str == null) {
            str = "null";
        }
        int slen = str.length();
        StringBuffer sb = new StringBuffer(str);
        for (int i = 0; i < totalChars - slen; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String pad(Object obj, int totalChars) {
        return StringUtils.pad(obj.toString(), totalChars);
    }

    public static String padOrTrim(String str, int num) {
        int leng;
        if (str == null) {
            str = "null";
        }
        if ((leng = str.length()) < num) {
            StringBuffer sb = new StringBuffer(str);
            for (int i = 0; i < num - leng; ++i) {
                sb.append(" ");
            }
            return sb.toString();
        }
        if (leng > num) {
            return str.substring(0, num);
        }
        return str;
    }

    public static String padOrTrim(Object obj, int totalChars) {
        return StringUtils.padOrTrim(obj.toString(), totalChars);
    }

    public static String padLeft(String str, int totalChars) {
        if (str == null) {
            str = "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < totalChars - str.length(); ++i) {
            sb.append(" ");
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padLeft(Object obj, int totalChars) {
        return StringUtils.padLeft(obj.toString(), totalChars);
    }

    public static String padLeft(int i, int totalChars) {
        return StringUtils.padLeft(new Integer(i), totalChars);
    }

    public static String padLeft(double d, int totalChars) {
        return StringUtils.padLeft(new Double(d), totalChars);
    }

    public static String trim(String s, int maxWidth) {
        if (s.length() <= maxWidth) {
            return s;
        }
        return s.substring(0, maxWidth);
    }

    public static String trim(Object obj, int maxWidth) {
        return StringUtils.trim(obj.toString(), maxWidth);
    }

    public static String fileNameClean(String s) {
        char[] chars = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                sb.append(c);
                continue;
            }
            if (c == ' ' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append("x" + c + "x");
        }
        return sb.toString();
    }

    public static int nthIndex(String s, char ch, int n) {
        int index = 0;
        for (int i = 0; i < n; ++i) {
            if (index == s.length() - 1) {
                return -1;
            }
            if ((index = s.indexOf(ch, index + 1)) != -1) continue;
            return -1;
        }
        return index;
    }

    public static String truncate(int n, int smallestDigit, int biggestDigit) {
        int j;
        int numDigits = biggestDigit - smallestDigit + 1;
        char[] result = new char[numDigits];
        for (j = 1; j < smallestDigit; ++j) {
            n /= 10;
        }
        for (j = numDigits - 1; j >= 0; --j) {
            result[j] = Character.forDigit(n % 10, 10);
            n /= 10;
        }
        return new String(result);
    }

    public static Map<String, String[]> argsToMap(String[] args) {
        return StringUtils.argsToMap(args, new HashMap<String, Integer>());
    }

    public static Map<String, String[]> argsToMap(String[] args, Map<String, Integer> flagsToNumArgs) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.charAt(0) == '-') {
                Integer maxFlagArgs = flagsToNumArgs.get(key);
                int max = maxFlagArgs == null ? 0 : maxFlagArgs;
                ArrayList<String> flagArgs = new ArrayList<String>();
                for (int j = 0; j < max && i + 1 < args.length && args[i + 1].charAt(0) != '-'; ++j) {
                    flagArgs.add(args[i + 1]);
                    ++i;
                }
                if (result.containsKey(key)) {
                    String[] newFlagArg = new String[((String[])result.get(key)).length + flagsToNumArgs.get(key)];
                    int oldNumArgs = ((String[])result.get(key)).length;
                    System.arraycopy(result.get(key), 0, newFlagArg, 0, oldNumArgs);
                    for (int j = 0; j < flagArgs.size(); ++j) {
                        newFlagArg[j + oldNumArgs] = (String)flagArgs.get(j);
                    }
                    continue;
                }
                result.put(key, flagArgs.toArray(new String[0]));
                continue;
            }
            remainingArgs.add(args[i]);
        }
        result.put(null, remainingArgs.toArray(new String[0]));
        return result;
    }

    public static Properties argsToProperties(String[] args) {
        return StringUtils.argsToProperties(args, new HashMap());
    }

    public static Properties argsToProperties(String[] args, Map flagsToNumArgs) {
        Properties result = new Properties();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.charAt(0) == '-') {
                Integer maxFlagArgs = (Integer)flagsToNumArgs.get(key = key.substring(1));
                int max = maxFlagArgs == null ? 1 : maxFlagArgs;
                ArrayList<String> flagArgs = new ArrayList<String>();
                for (int j = 0; j < max && i + 1 < args.length && args[i + 1].charAt(0) != '-'; ++j) {
                    flagArgs.add(args[i + 1]);
                    ++i;
                }
                if (flagArgs.size() == 0) {
                    result.setProperty(key, "true");
                    continue;
                }
                result.setProperty(key, StringUtils.join(flagArgs, " "));
                if (!key.equalsIgnoreCase(PROP)) continue;
                try {
                    result.load(new BufferedInputStream(new FileInputStream(result.getProperty(PROP))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            remainingArgs.add(args[i]);
        }
        result.setProperty("", StringUtils.join(remainingArgs, " "));
        return result;
    }

    public static Properties stringToProperties(String str) {
        Properties result = new Properties();
        String[] props = str.trim().split(",\\s*");
        for (int i = 0; i < props.length; ++i) {
            String value;
            String key;
            String term = props[i];
            int divLoc = term.indexOf("=");
            if (divLoc >= 0) {
                key = term.substring(0, divLoc);
                value = term.substring(divLoc + 1);
            } else {
                key = term;
                value = "true";
            }
            result.setProperty(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printToFile(File file, String message, boolean append) {
        FileWriter fw = null;
        try (PrintWriter pw = null;){
            fw = new FileWriter(file, append);
            pw = new PrintWriter(fw);
            pw.print(message);
        }
    }

    public static void printToFile(File file, String message) {
        StringUtils.printToFile(file, message, false);
    }

    public static void printToFile(String filename, String message, boolean append) {
        StringUtils.printToFile(new File(filename), message, append);
    }

    public static void printToFile(String filename, String message) {
        StringUtils.printToFile(new File(filename), message, false);
    }

    public static Map parseCommandLineArguments(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.charAt(0) != '-') continue;
            if (i + 1 < args.length) {
                String value = args[i + 1];
                if (value.charAt(0) != '-') {
                    result.put(key, value);
                    ++i;
                    continue;
                }
                result.put(key, null);
                continue;
            }
            result.put(key, null);
        }
        return result;
    }

    public static String stripNonAlphaNumerics(String orig) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static void printStringOneCharPerLine(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            System.out.println(c + " '" + (char)c + "' ");
        }
    }

    public static String escapeString(String s, char[] charsToEscape, char escapeChar) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == escapeChar) {
                result.append(escapeChar);
            } else {
                for (int j = 0; j < charsToEscape.length; ++j) {
                    if (c != charsToEscape[j]) continue;
                    result.append(escapeChar);
                    break;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String[] splitOnCharWithQuoting(String s, char splitChar, char quoteChar, char escapeChar) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int length = s.length();
        StringBuffer b = new StringBuffer();
        block0: while (i < length) {
            char curr = s.charAt(i);
            if (curr == splitChar) {
                if (b.length() > 0) {
                    result.add(b.toString());
                    b = new StringBuffer();
                }
                ++i;
                continue;
            }
            if (curr == quoteChar) {
                ++i;
                while (i < length) {
                    curr = s.charAt(i);
                    if (curr == escapeChar) {
                        b.append(s.charAt(i + 1));
                        i += 2;
                        continue;
                    }
                    if (curr == quoteChar) {
                        ++i;
                        continue block0;
                    }
                    b.append(s.charAt(i));
                    ++i;
                }
                continue;
            }
            b.append(curr);
            ++i;
        }
        if (b.length() > 0) {
            result.add(b.toString());
        }
        return result.toArray(new String[0]);
    }

    public static int longestCommonSubstring(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return 0;
        }
        if (m == 0) {
            return 0;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = 0;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = 0;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                d[i][j] = s_i == t_j ? SloppyMath.max(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1] + 1) : Math.max(d[i - 1][j], d[i][j - 1]);
            }
        }
        return d[n][m];
    }

    public static int editDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = SloppyMath.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public static String pennPOSToWordnetPOS(String s) {
        if (s.matches("NN|NNP|NNS|NNPS")) {
            return "noun";
        }
        if (s.matches("VB|VBD|VBG|VBN|VBZ|VBP|MD")) {
            return "verb";
        }
        if (s.matches("JJ|JJR|JJS|CD")) {
            return "adjective";
        }
        if (s.matches("RB|RBR|RBS|RP|WRB")) {
            return "adverb";
        }
        return null;
    }

    public static String capitalize(String s) {
        if (s.charAt(0) >= 'a') {
            return (char)(s.charAt(0) + -32) + s.substring(1);
        }
        return s;
    }

    public static List<Matcher> allMatches(String str, String regex) {
        Matcher m;
        Pattern p = Pattern.compile(regex);
        ArrayList<Matcher> matches = new ArrayList<Matcher>();
        while ((m = p.matcher(str)).find()) {
            matches.add(m);
            str = str.substring(m.end());
        }
        return matches;
    }

    public static void main(String[] args) throws IOException {
        String[] s = new String[]{"there once was a man", "this one is a manic", "hey there", "there once was a mane", "once in a manger.", "where is one match?"};
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                System.out.println("s1: " + s[i]);
                System.out.println("s2: " + s[j]);
                System.out.println("edit distance: " + StringUtils.editDistance(s[i], s[j]));
                System.out.println("LCS:           " + StringUtils.longestCommonSubstring(s[i], s[j]));
                System.out.println();
            }
        }
    }
}

