/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.exception.InvalidStepException;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.GradientAdjustment;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TerminationCondition;
import org.deeplearning4j.optimize.solvers.BackTrackLineSearch;
import org.deeplearning4j.optimize.terminations.EpsTermination;
import org.deeplearning4j.optimize.terminations.ZeroDirection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdaGrad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOptimizer
implements ConvexOptimizer {
    protected NeuralNetConfiguration conf;
    protected AdaGrad adaGrad;
    protected int iteration = 0;
    protected static final Logger log = LoggerFactory.getLogger(BaseOptimizer.class);
    protected StepFunction stepFunction;
    protected Collection<IterationListener> iterationListeners = new ArrayList<IterationListener>();
    protected Collection<TerminationCondition> terminationConditions = new ArrayList<TerminationCondition>();
    protected Model model;
    protected BackTrackLineSearch lineMaximizer;
    protected double step;
    private int batchSize = 10;
    protected double score;
    protected double oldScore;
    protected double stpMax = Double.MAX_VALUE;
    public static final String GRADIENT_KEY = "g";
    public static final String SCORE_KEY = "score";
    public static final String PARAMS_KEY = "params";
    protected Map<String, AdaGrad> adaGradForVariable = new ConcurrentHashMap<String, AdaGrad>();
    protected Map<String, Object> searchState = new ConcurrentHashMap<String, Object>();

    public BaseOptimizer(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Model model) {
        this(conf, stepFunction, iterationListeners, Arrays.asList(new ZeroDirection(), new EpsTermination()), model);
    }

    public BaseOptimizer(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Collection<TerminationCondition> terminationConditions, Model model) {
        this.conf = conf;
        this.stepFunction = stepFunction;
        this.iterationListeners = iterationListeners != null ? iterationListeners : new ArrayList();
        this.terminationConditions = terminationConditions;
        this.model = model;
        this.lineMaximizer = new BackTrackLineSearch(model, stepFunction, this);
        this.lineMaximizer.setStpmax(this.stpMax);
        this.lineMaximizer.setMaxIterations(conf.getNumLineSearchIterations());
    }

    @Override
    public void updateGradientAccordingToParams(INDArray gradient, INDArray params, int batchSize) {
        GradientAdjustment.updateGradientAccordingToParams(this.conf, 0, this.adaGrad, gradient, params, batchSize);
    }

    @Override
    public double score() {
        this.model.setScore();
        return this.model.score();
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        this.model.setScore();
        Pair<Gradient, Double> pair = this.model.gradientAndScore();
        this.updateGradientAccordingToParams(pair.getFirst(), this.model, this.model.batchSize());
        return pair;
    }

    @Override
    public boolean optimize() {
        this.model.validateInput();
        Pair<Gradient, Double> pair = this.gradientAndScore();
        this.setupSearchState(pair);
        this.score = pair.getSecond();
        INDArray gradient = (INDArray)this.searchState.get(GRADIENT_KEY);
        for (TerminationCondition condition : this.terminationConditions) {
            if (!condition.terminate(0.0, 0.0, new Object[]{gradient})) continue;
            log.info("Hit termination condition " + condition.getClass().getName());
            return true;
        }
        boolean testLineSearch = this.preFirstStepProcess(gradient);
        if (testLineSearch) {
            try {
                INDArray params = (INDArray)this.searchState.get(PARAMS_KEY);
                this.step = this.lineMaximizer.optimize(this.step, params, gradient);
            }
            catch (InvalidStepException e) {
                log.warn("Invalid step...continuing another iteration");
            }
            gradient = (INDArray)this.searchState.get(GRADIENT_KEY);
            this.postFirstStep(gradient);
            if (this.step == 0.0) {
                log.warn("Unable to step in direction");
                return false;
            }
        }
        for (int i = 0; i < this.conf.getNumIterations(); ++i) {
            this.preProcessLine(gradient);
            try {
                INDArray params = (INDArray)this.searchState.get(PARAMS_KEY);
                this.step = this.lineMaximizer.optimize(this.step, params, gradient);
            }
            catch (InvalidStepException e) {
                log.warn("Invalid step...continuing another iteration");
            }
            for (IterationListener listener : this.iterationListeners) {
                listener.iterationDone(this.model, i);
            }
            this.oldScore = this.score;
            pair = this.gradientAndScore();
            this.setupSearchState(pair);
            for (TerminationCondition condition : this.terminationConditions) {
                if (!condition.terminate(this.score, this.oldScore, new Object[]{gradient})) continue;
                return true;
            }
            this.postStep();
            for (TerminationCondition condition : this.terminationConditions) {
                if (!condition.terminate(this.score, this.oldScore, new Object[]{gradient})) continue;
                return true;
            }
        }
        return true;
    }

    protected void postFirstStep(INDArray gradient) {
    }

    protected boolean preFirstStepProcess(INDArray gradient) {
        return false;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void preProcessLine(INDArray line) {
    }

    @Override
    public void postStep() {
    }

    @Override
    public AdaGrad getAdaGrad() {
        return this.adaGrad;
    }

    @Override
    public Map<String, AdaGrad> adaGradForVariables() {
        return this.adaGradForVariable;
    }

    @Override
    public AdaGrad getAdaGradForVariable(String variable) {
        return this.adaGradForVariable.get(variable);
    }

    @Override
    public void updateGradientAccordingToParams(Gradient gradient, Model params, int batchSize) {
        GradientAdjustment.updateGradientAccordingToParams(this.conf, this.iteration, gradient, batchSize, this.adaGradForVariable, params);
    }

    @Override
    public void setupSearchState(Pair<Gradient, Double> pair) {
        INDArray gradient = pair.getFirst().gradient(this.conf.variables());
        INDArray params = this.model.params();
        this.searchState.put(GRADIENT_KEY, gradient);
        this.searchState.put(SCORE_KEY, pair.getSecond());
        this.searchState.put(PARAMS_KEY, params);
        this.score = pair.getSecond();
    }
}

